/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.EditSourceFileAction;
import de.uka.ilkd.key.gui.actions.SendFeedbackAction;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.proof.SVInstantiationExceptionWithPosition;
import de.uka.ilkd.key.util.ExceptionTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.key_project.util.java.IOUtil;
import org.key_project.util.java.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ExceptionDialog
extends JDialog {
    public static final Font MESSAGE_FONT = new Font("Monospaced", 0, 12);
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionDialog.class);
    private JScrollPane stScroll;
    private JTextArea stTextArea;
    private Location location;
    private final Throwable exception;

    public static void showDialog(Window parent, Throwable exception) {
        ExceptionDialog dlg = new ExceptionDialog(parent, exception);
        if (parent != null) {
            dlg.setLocationRelativeTo(parent);
        }
        dlg.setVisible(true);
        dlg.dispose();
    }

    private ExceptionDialog(Window parent, Throwable exception) {
        super(parent, "Parser Messages", Dialog.ModalityType.DOCUMENT_MODAL);
        this.exception = exception;
        if (exception != null) {
            try {
                this.location = ExceptionTools.getLocation((Throwable)exception);
            }
            catch (MalformedURLException e) {
                this.location = null;
                LOGGER.error("Creating a Location failed for {}", (Object)exception, (Object)e);
            }
        }
        this.init();
    }

    private JPanel createButtonPanel() {
        ActionListener closeListener = e -> this.setVisible(false);
        ItemListener detailsBoxListener = e -> {
            Container contentPane = this.getContentPane();
            if (e.getStateChange() == 1) {
                contentPane.add((Component)this.stScroll, new GridBagConstraints(0, 3, 1, 1, 1.0, 10.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                contentPane.remove(this.stScroll);
            }
            this.pack();
            contentPane.repaint();
        };
        JButton reloadButton = new JButton("Reload");
        reloadButton.setAction(MainWindow.getInstance().getOpenMostRecentFileAction());
        reloadButton.addActionListener(closeListener);
        JButton closeButton = new JButton("Close");
        closeButton.addActionListener(closeListener);
        this.getRootPane().setDefaultButton(closeButton);
        JCheckBox detailsBox = new JCheckBox("Show Details");
        detailsBox.setSelected(false);
        detailsBox.addItemListener(detailsBoxListener);
        JPanel bPanel = new JPanel();
        JButton sendFeedbackButton = new JButton(new SendFeedbackAction(this, this.exception));
        bPanel.add(sendFeedbackButton);
        JButton editSourceFileButton = new JButton("Edit Source File");
        EditSourceFileAction action = new EditSourceFileAction(this, this.exception);
        editSourceFileButton.addActionListener(action);
        if (!Location.isValidLocation((Location)this.location)) {
            editSourceFileButton.setEnabled(false);
        }
        bPanel.add(editSourceFileButton);
        bPanel.add(closeButton);
        bPanel.add(detailsBox);
        return bPanel;
    }

    private JScrollPane createStacktraceTextAreaScroll() {
        JScrollPane scroll = new JScrollPane(this.stTextArea);
        scroll.setBorder(new TitledBorder("Stack Trace"));
        scroll.setPreferredSize(new Dimension(500, 300));
        return scroll;
    }

    private JTextArea createStacktraceTextArea() {
        JTextArea result = new JTextArea();
        result.setEditable(false);
        result.setTabSize(4);
        result.setFont(MESSAGE_FONT);
        return result;
    }

    private void setStackTraceText() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.exception.printStackTrace(pw);
        this.stTextArea.setText(sw.toString());
    }

    private JScrollPane createExcTextAreaScroll() {
        JTextArea exTextArea = this.createStacktraceTextArea();
        Dimension textPaneDim = new Dimension(500, 200);
        exTextArea.setColumns(120);
        exTextArea.setLineWrap(true);
        exTextArea.setWrapStyleWord(true);
        String orgMsg = this.exception.getMessage();
        if (orgMsg == null) {
            orgMsg = "";
        }
        StringBuilder message = new StringBuilder(orgMsg);
        if (this.location != null) {
            try (InputStream is = IOUtil.openStream((String)this.location.getFileURL().toString());
                 InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                List list = br.lines().limit(this.location.getLine()).collect(Collectors.toList());
                String line = (String)list.get(this.location.getLine() - 1);
                String pointLine = StringUtil.repeat((String)" ", (int)(this.location.getColumn() - 1)) + "^";
                message.append(StringUtil.NEW_LINE).append(StringUtil.NEW_LINE).append(line).append(StringUtil.NEW_LINE).append(pointLine);
            }
            catch (IOException e) {
                LOGGER.error("Creating an error line did not work for {}", (Object)this.location, (Object)e);
            }
        }
        exTextArea.setText(message.toString());
        exTextArea.setTabSize(2);
        exTextArea.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(exTextArea);
        scroll.setBorder(new TitledBorder(this.exception.getClass().getName()));
        scroll.setPreferredSize(textPaneDim);
        return scroll;
    }

    private JPanel createLocationPanel() {
        if (this.location == null) {
            return null;
        }
        JPanel lPanel = new JPanel();
        JTextField fTextField = new JTextField();
        JTextField lTextField = new JTextField();
        JTextField cTextField = new JTextField();
        fTextField.setEditable(false);
        lTextField.setEditable(false);
        cTextField.setEditable(false);
        if (this.location.getFileURL() != null) {
            fTextField.setText("URL: " + this.location.getFileURL());
            lPanel.add(fTextField);
        }
        if (this.exception instanceof SVInstantiationExceptionWithPosition) {
            lTextField.setText("Row: " + this.location.getLine());
        } else {
            lTextField.setText("Line: " + this.location.getLine());
        }
        lPanel.add(lTextField);
        cTextField.setText("Column: " + this.location.getColumn());
        lPanel.add(cTextField);
        return lPanel;
    }

    private void init() {
        Container cp = this.getContentPane();
        cp.setLayout(new GridBagLayout());
        cp.add((Component)this.createExcTextAreaScroll(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0E-10, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel locationPanel = this.createLocationPanel();
        if (locationPanel != null) {
            cp.add((Component)locationPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        JPanel buttonPanel = this.createButtonPanel();
        cp.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.stTextArea = this.createStacktraceTextArea();
        this.stScroll = this.createStacktraceTextAreaScroll();
        this.setStackTraceText();
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }
}

