/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.GUIListener;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.fonticons.IconFontSwing;
import de.uka.ilkd.key.gui.prooftree.DisableGoal;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import de.uka.ilkd.key.proof.ProofTreeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.key_project.util.collection.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoalList
extends JList<Goal>
implements TabPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoalList.class);
    public static final Icon GOAL_LIST_ICON = IconFontSwing.buildIcon(FontAwesomeSolid.FLAG_CHECKERED, 16.0f);
    private static final long serialVersionUID = 1632264315383703798L;
    private static final ImageIcon keyIcon = IconFactory.keyHole(20, 20);
    private static final Icon disabledGoalIcon = IconFactory.keyHoleInteractive(20, 20);
    private static final Icon linkedGoalIcon = IconFactory.keyHoleLinked(20, 20);
    private static final int MAX_DISPLAYED_SEQUENT_LENGTH = 100;
    private final SelectingGoalListModel selectingListModel;
    private final GoalListModel goalListModel;
    private final WeakHashMap<Sequent, String> seqToString = new WeakHashMap();
    private KeYMediator mediator;
    private GoalListInteractiveListener interactiveListener = new GoalListInteractiveListener();
    private GoalListSelectionListener selectionListener = new GoalListSelectionListener();
    private GoalListGUIListener guiListener = new GoalListGUIListener();

    public GoalList(KeYMediator mediator) {
        this();
        this.setMediator(mediator);
    }

    public GoalList() {
        this.setSelectionMode(0);
        this.goalListModel = new GoalListModel();
        this.selectingListModel = new SelectingGoalListModel(this.goalListModel);
        this.setModel(this.selectingListModel);
        this.setCellRenderer(new IconCellRenderer());
        this.addListSelectionListener(new GoalListSelectionListern());
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GoalList.this.setSelectedIndex(GoalList.this.locationToIndex(e.getPoint()));
                if (e.isPopupTrigger()) {
                    GoalList.this.popupMenu().show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        };
        this.addMouseListener(ml);
        this.updateUI();
        KeYGuiExtensionFacade.installKeyboardShortcuts(this.mediator, this, KeYGuiExtension.KeyboardShortcuts.GOAL_LIST);
    }

    @Override
    public String getTitle() {
        return "Goals";
    }

    @Override
    public Icon getIcon() {
        return GOAL_LIST_ICON;
    }

    @Override
    public JComponent getComponent() {
        return new JScrollPane(this);
    }

    private JPopupMenu popupMenu() {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new DisableSingleGoal());
        menu.add(new DisableOtherGoals());
        return menu;
    }

    private void setMediator(KeYMediator m) {
        if (this.mediator != null) {
            this.unregister();
        }
        this.mediator = m;
        this.register();
        this.selectingListModel.setProof(this.mediator.getSelectedProof());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font myFont = UIManager.getFont("KEY_FONT_GOAL_LIST_VIEW");
        if (myFont != null) {
            this.setFont(myFont);
        } else {
            LOGGER.debug("goallist: Warning: Use standard font. Could not find font: {}", (Object)"KEY_FONT_GOAL_LIST_VIEW");
        }
    }

    private void register() {
        this.mediator().addKeYSelectionListener(this.selectionListener);
        this.mediator().getUI().getProofControl().addAutoModeListener(this.interactiveListener);
        this.mediator().addGUIListener(this.guiListener);
    }

    private void unregister() {
        if (this.mediator() != null) {
            this.mediator().removeKeYSelectionListener(this.selectionListener);
            this.mediator().getUI().getProofControl().removeAutoModeListener(this.interactiveListener);
            this.mediator().removeGUIListener(this.guiListener);
        }
    }

    @Override
    public void removeNotify() {
    }

    private KeYMediator mediator() {
        return this.mediator;
    }

    private void goalChosen() {
        Goal goal = (Goal)this.getSelectedValue();
        if (goal != null) {
            this.mediator().goalChosen(goal);
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
    }

    private void selectSelectedGoal() {
        this.clearSelection();
        if (this.mediator() != null) {
            try {
                Goal selGoal = this.mediator().getSelectedGoal();
                if (selGoal != null) {
                    this.setSelectedValue(selGoal, true);
                }
            }
            catch (IllegalStateException e) {
                LOGGER.debug("GoalList: No proof loaded.");
            }
        }
        this.validate();
    }

    private String seqToString(Sequent seq) {
        String res = this.seqToString.get(seq);
        if (res == null) {
            LogicPrinter sp = new LogicPrinter(new ProgramPrinter(null), this.mediator().getNotationInfo(), this.mediator().getServices(), true);
            sp.printSequent(seq);
            res = sp.toString().replace('\n', ' ');
            res = res.substring(0, Math.min(100, res.length()));
            this.seqToString.put(seq, res);
        }
        return res;
    }

    private class IconCellRenderer
    extends DefaultListCellRenderer
    implements Serializable {
        private static final long serialVersionUID = -8178991338906184819L;

        public IconCellRenderer() {
            GoalList.this.setToolTipText("GOAL");
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Icon statusIcon;
            String valueStr;
            Color col = Color.black;
            if (value instanceof Goal) {
                Sequent seq = ((Goal)value).sequent();
                valueStr = "(#" + ((Goal)value).node().serialNr() + ") " + GoalList.this.seqToString(seq);
                statusIcon = ((Goal)value).isLinked() ? linkedGoalIcon : (((Goal)value).isAutomatic() ? keyIcon : disabledGoalIcon);
            } else {
                valueStr = "" + value;
                statusIcon = keyIcon;
            }
            DefaultListCellRenderer sup = (DefaultListCellRenderer)super.getListCellRendererComponent(list, valueStr, index, isSelected, cellHasFocus);
            sup.setIcon(statusIcon);
            sup.setForeground(col);
            return sup;
        }
    }

    private class SelectingGoalListModel
    extends AbstractListModel<Goal> {
        private static final long serialVersionUID = 7395134147866131926L;
        private final GoalListModel delegate;
        private final ArrayList<Integer> entries = new ArrayList(10);
        private final DelegateListener delegateListener = new DelegateListener();
        private int delegateSize;
        private Proof proof = null;

        public SelectingGoalListModel(GoalListModel delegate) {
            this.delegate = delegate;
        }

        @Override
        public int getSize() {
            return this.entries.size();
        }

        @Override
        public Goal getElementAt(int i) {
            if (i < 0 || i >= this.getSize()) {
                return null;
            }
            return this.delegate.getElementAt(this.getDelegateIndex(i));
        }

        private int getDelegateIndex(int i) {
            return this.entries.get(i);
        }

        protected void setProof(Proof p) {
            this.delegate.removeListDataListener(this.delegateListener);
            this.proof = p;
            this.delegate.setProof(p);
            this.setup();
            this.delegate.addListDataListener(this.delegateListener);
        }

        private boolean isHiddenGoal(Goal goal) {
            return this.proof != null && goal.node().isClosed();
        }

        private void setup() {
            this.entries.clear();
            this.selectFromInterval(0, this.delegate.getSize());
            this.updateDelegateSize();
            this.fireContentsChanged(this, 0, this.getSize() - 1);
            GoalList.this.selectSelectedGoal();
        }

        private int selectFromInterval(int delegateBegin, int delegateEnd) {
            delegateEnd = Math.min(delegateEnd, this.delegate.getSize());
            int ind = this.delegatePosToMappingPos(delegateBegin);
            for (int i = delegateBegin; i < delegateEnd; ++i) {
                Goal goal = this.delegate.getElementAt(i);
                if (this.isHiddenGoal(goal)) continue;
                this.entries.add(ind++, i);
            }
            return ind;
        }

        private int removeInterval(int delegateBegin, int delegateEnd) {
            int ind = this.delegatePosToMappingPos(delegateBegin);
            while (ind != this.entries.size() && this.getDelegateIndex(ind) < delegateEnd) {
                this.entries.remove(ind);
            }
            return ind;
        }

        private int delegatePosToMappingPos(int delegateIndex) {
            for (int res = 0; res != this.entries.size(); ++res) {
                if (this.getDelegateIndex(res) < delegateIndex) continue;
                return res;
            }
            return this.entries.size();
        }

        private void shiftTail(int begin, int amount) {
            while (begin != this.entries.size()) {
                this.entries.set(begin, this.getDelegateIndex(begin) + amount);
                ++begin;
            }
        }

        private int delegateSizeChange() {
            return this.delegate.getSize() - this.delegateSize;
        }

        private void updateDelegateSize() {
            this.delegateSize = this.delegate.getSize();
        }

        private class DelegateListener
        implements ListDataListener {
            private DelegateListener() {
            }

            private int delegateBegin(ListDataEvent e) {
                return e.getIndex0();
            }

            private int delegateEnd(ListDataEvent e) {
                return e.getIndex1() + 1;
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                int oldDelegateEnd = this.delegateEnd(e) - SelectingGoalListModel.this.delegateSizeChange();
                int begin = SelectingGoalListModel.this.removeInterval(this.delegateBegin(e), oldDelegateEnd);
                SelectingGoalListModel.this.shiftTail(begin, SelectingGoalListModel.this.delegateSizeChange());
                int end = SelectingGoalListModel.this.selectFromInterval(this.delegateBegin(e), this.delegateEnd(e));
                SelectingGoalListModel.this.updateDelegateSize();
                int changeBegin = begin;
                int changeEnd = end - 1;
                if (changeEnd >= changeBegin) {
                    SelectingGoalListModel.this.fireContentsChanged(this, changeBegin, changeEnd);
                }
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                int oldSize = SelectingGoalListModel.this.entries.size();
                int end = SelectingGoalListModel.this.selectFromInterval(this.delegateBegin(e), this.delegateEnd(e));
                SelectingGoalListModel.this.shiftTail(end, SelectingGoalListModel.this.delegateSizeChange());
                SelectingGoalListModel.this.updateDelegateSize();
                int addBegin = end - (SelectingGoalListModel.this.entries.size() - oldSize);
                int addEnd = end - 1;
                if (addEnd >= addBegin) {
                    SelectingGoalListModel.this.fireIntervalAdded(this, addBegin, addEnd);
                }
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                int oldSize = SelectingGoalListModel.this.entries.size();
                int begin = SelectingGoalListModel.this.removeInterval(this.delegateBegin(e), this.delegateEnd(e));
                SelectingGoalListModel.this.shiftTail(begin, SelectingGoalListModel.this.delegateSizeChange());
                SelectingGoalListModel.this.updateDelegateSize();
                int remBegin = begin;
                int remEnd = begin + (oldSize - SelectingGoalListModel.this.entries.size()) - 1;
                if (remEnd >= remBegin) {
                    SelectingGoalListModel.this.fireIntervalRemoved(this, remBegin, remEnd);
                }
            }
        }
    }

    private class GoalListInteractiveListener
    implements AutoModeListener {
        private GoalListInteractiveListener() {
        }

        public void autoModeStarted(ProofEvent e) {
            if (GoalList.this.goalListModel.isAttentive()) {
                GoalList.this.mediator().removeKeYSelectionListener(GoalList.this.selectionListener);
            }
            GoalList.this.goalListModel.setAttentive(false);
        }

        public void autoModeStopped(ProofEvent e) {
            if (!GoalList.this.goalListModel.isAttentive()) {
                GoalList.this.mediator().addKeYSelectionListener(GoalList.this.selectionListener);
            }
            GoalList.this.goalListModel.setAttentive(true);
        }
    }

    private class GoalListSelectionListener
    implements KeYSelectionListener {
        private GoalListSelectionListener() {
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
            GoalList.this.selectSelectedGoal();
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            LOGGER.debug("GoalList: initialize with new proof");
            GoalList.this.selectingListModel.setProof(e.getSource().getSelectedProof());
            GoalList.this.validate();
        }
    }

    private class GoalListGUIListener
    implements GUIListener,
    Serializable {
        private static final long serialVersionUID = -1826501525753975124L;

        private GoalListGUIListener() {
        }

        @Override
        public void modalDialogOpened(EventObject e) {
            GoalList.this.setEnabled(false);
        }

        @Override
        public void modalDialogClosed(EventObject e) {
            GoalList.this.setEnabled(true);
        }

        @Override
        public void shutDown(EventObject e) {
        }
    }

    public class GoalListSelectionListern
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            int firstIndex = e.getFirstIndex();
            if (firstIndex >= 0 && firstIndex < GoalList.this.getModel().getSize() && GoalList.this.mediator.getSelectedGoal() != GoalList.this.getSelectedValue()) {
                GoalList.this.goalChosen();
            }
        }
    }

    private final class DisableOtherGoals
    extends DisableGoal {
        private static final long serialVersionUID = 4077876260098617901L;

        DisableOtherGoals() {
            if (GoalList.this.getSelectedValue() != null) {
                Goal g = (Goal)GoalList.this.getSelectedValue();
                this.putValue("Name", g.isAutomatic() ? "Set Other Goals Interactive" : "Set Other Goals Automatic");
                this.putValue("ShortDescription", g.isAutomatic() ? "No automatic rules will be applied on all other goals." : "Re-enable automatic rule application for other goals.");
                this.putValue("SmallIcon", g.isAutomatic() ? KEY_HOLE_DISABLED_PULL_DOWN_MENU : KEY_HOLE_PULL_DOWN_MENU);
                this.enableGoals = !g.isAutomatic();
                this.setEnabled(GoalList.this.getModel().getSize() > 1);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public Iterable<Goal> getGoalList() {
            Object selectedObject = GoalList.this.getSelectedValue();
            ArrayList<Goal> selectedGoals = new ArrayList<Goal>();
            int sz = GoalList.this.getModel().getSize();
            for (int i = 0; i < sz; ++i) {
                Object o = GoalList.this.getModel().getElementAt(i);
                if (o == null || o == selectedObject) continue;
                selectedGoals.add((Goal)o);
            }
            return selectedGoals;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            GoalList.this.updateUI();
        }
    }

    private final class DisableSingleGoal
    extends DisableGoal {
        private static final long serialVersionUID = -2035187175105625072L;

        DisableSingleGoal() {
            if (GoalList.this.getSelectedValue() != null) {
                Goal g = (Goal)GoalList.this.getSelectedValue();
                this.putValue("Name", g.isAutomatic() ? "Interactive Goal" : "Automatic Goal");
                this.putValue("ShortDescription", g.isAutomatic() ? "No automatic rules will be applied when goal is set to interactive." : "Re-enable automatic rule application for this goal.");
                this.putValue("SmallIcon", g.isAutomatic() ? KEY_HOLE_DISABLED_PULL_DOWN_MENU : KEY_HOLE_PULL_DOWN_MENU);
                this.enableGoals = !g.isAutomatic();
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        @Override
        public Iterable<Goal> getGoalList() {
            Goal selectedObject = (Goal)GoalList.this.getSelectedValue();
            ArrayList<Goal> selectedGoals = new ArrayList<Goal>();
            if (selectedObject != null) {
                selectedGoals.add(selectedObject);
            }
            return selectedGoals;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            GoalList.this.updateUI();
        }
    }

    private static class GoalListModel
    extends AbstractListModel<Goal> {
        private static final long serialVersionUID = 3754243473284250930L;
        private final ProofTreeListener proofTreeListener = new GoalListProofTreeListener();
        private Proof proof;
        private List<Goal> goals = new ArrayList<Goal>(10);
        private boolean attentive;

        GoalListModel() {
        }

        private void setProof(Proof p) {
            this.clear();
            if (this.proof != null) {
                this.proof.removeProofTreeListener(this.proofTreeListener);
            }
            this.proof = p;
            if (this.proof != null) {
                this.proof.addProofTreeListener(this.proofTreeListener);
                this.add((ImmutableList<Goal>)this.proof.openGoals());
            }
            this.attentive = true;
        }

        public boolean isAttentive() {
            return this.attentive;
        }

        private void setAttentive(boolean b) {
            if (b != this.attentive && this.proof != null && !this.proof.isDisposed()) {
                if (b) {
                    this.proof.addProofTreeListener(this.proofTreeListener);
                    this.clear();
                    this.add((ImmutableList<Goal>)this.proof.openGoals());
                } else {
                    this.proof.removeProofTreeListener(this.proofTreeListener);
                }
            }
            this.attentive = b;
        }

        public void add(ImmutableList<Goal> g) {
            if (!g.isEmpty()) {
                for (Goal aG : g) {
                    this.goals.add(aG);
                }
                this.fireIntervalAdded(this, this.goals.size() - g.size(), this.goals.size() - 1);
            }
        }

        public void remove(Goal g) {
            int index = this.goals.indexOf(g);
            if (index > -1) {
                this.goals.remove(g);
                this.fireIntervalRemoved(this, index, index);
            }
        }

        public void clear() {
            int size = this.goals.size();
            if (size > 0) {
                this.goals.clear();
                this.fireIntervalRemoved(this, 0, size - 1);
            }
        }

        @Override
        public int getSize() {
            return this.goals.size();
        }

        @Override
        public Goal getElementAt(int i) {
            return this.goals.get(i);
        }

        class GoalListProofTreeListener
        implements ProofTreeListener,
        Serializable {
            private static final long serialVersionUID = 3090011700136463120L;
            private boolean pruningInProcess;

            GoalListProofTreeListener() {
            }

            public void proofExpanded(ProofTreeEvent e) {
            }

            public void proofClosed(ProofTreeEvent e) {
                GoalListModel.this.setAttentive(true);
                GoalListModel.this.clear();
            }

            public void proofIsBeingPruned(ProofTreeEvent e) {
                this.pruningInProcess = true;
            }

            public void proofPruned(ProofTreeEvent e) {
                GoalListModel.this.clear();
                GoalListModel.this.add((ImmutableList<Goal>)e.getSource().openGoals());
                this.pruningInProcess = false;
            }

            public void proofGoalRemoved(ProofTreeEvent e) {
                if (this.pruningInProcess) {
                    return;
                }
                GoalListModel.this.remove(e.getGoal());
            }

            public void proofGoalsAdded(ProofTreeEvent e) {
                if (this.pruningInProcess) {
                    return;
                }
                GoalListModel.this.add((ImmutableList<Goal>)e.getGoals());
            }

            public void proofGoalsChanged(ProofTreeEvent e) {
                if (this.pruningInProcess) {
                    return;
                }
                GoalListModel.this.clear();
                GoalListModel.this.add((ImmutableList<Goal>)e.getGoals());
            }

            public void proofStructureChanged(ProofTreeEvent e) {
                if (this.pruningInProcess) {
                    return;
                }
                GoalListModel.this.clear();
                GoalListModel.this.add((ImmutableList<Goal>)e.getSource().openGoals());
            }

            public void smtDataUpdate(ProofTreeEvent e) {
            }

            public void notesChanged(ProofTreeEvent e) {
            }
        }
    }
}

