/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;

public class HeatmapOptionsDialog
extends JDialog {
    private static final long serialVersionUID = 5731407140427140088L;
    private static final ViewSettings VS = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
    private static final int MIN_AGE = 1;
    private static final int MAX_AGE = 1000;
    private static final String INTRO_LABEL = "Heatmaps can be used to highlight the most recent changes in the sequent.";
    private static final String TEXTFIELD_LABEL = "Maximum age of highlighted terms or formulae, or number of newest terms or formulae";
    private static final String TOOLTIP_TEXT = "Please enter a number between 1 and 1000.";
    private static final String[] COMMANDS = new String[]{"default", "sf_age", "sf_newest", "terms_age", "terms_newest"};
    private static final String[] BUTTON_NAMES = new String[]{"No heatmaps", "Sequent formulae up to age", "Newest sequent formulae", "Terms up to age", "Newest terms"};
    private static final String[] DESCRIPTIONS = new String[]{"No Heatmaps are shown.", "All sequent formulae that have been added or changed in the last k steps are highlighted. More recent formulae will have a stronger highlight. It is possible that less than k formulae are highlighted, e.g. if one formula has changed multiple times.", "All formulae in the sequent are sorted by how new they are, i.e., how recently they have been added or changed. The first k formulae of the sorted list are highlighted according to their position in the list, with the most recent formula receiving the strongest highlight.", "All terms that have been added or changed in the last k steps are highlighted. More recent terms will have a stronger highlight. It is possible that less than k terms are highlighted, e.g. if one term has changed multiple times.", "All terms in the sequent are sorted by how new they are, i.e., how recently they have been added or changed. The first k terms of the sorted list are highlighted according to their position in the list, with the most recent term receiving the strongest highlight."};
    private static final int NUMRADIOBUTTONS = 5;
    private static final Icon HELPICON = IconFactory.HELP.get(20.0f);

    public HeatmapOptionsDialog() {
        super(MainWindow.getInstance(), "Heatmap Options", true);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(10, 5, 10, 5);
        JRadioButton[] radioButtons = new JRadioButton[5];
        ButtonGroup group = new ButtonGroup();
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        GuiUtilities.attachClickOnEscListener(cancelButton);
        JSpinner valueSpinner = this.setupSpinner();
        for (int i = 0; i < 5; ++i) {
            radioButtons[i] = new JRadioButton(BUTTON_NAMES[i]);
            radioButtons[i].setActionCommand(COMMANDS[i]);
            group.add(radioButtons[i]);
        }
        this.loadSettings(radioButtons);
        final boolean isShow = VS.isShowHeatmap();
        final boolean isSF = VS.isHeatmapSF();
        final boolean isNew = VS.isHeatmapNewest();
        final int age = VS.getMaxAgeForHeatmap();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VS.setHeatmapOptions(isShow, isSF, isNew, age);
                HeatmapOptionsDialog.this.dispose();
            }
        });
        this.getRootPane().registerKeyboardAction(e -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        JPanel radioBoxes = this.setupRadioPanel(radioButtons, panel.getBackground(), this);
        JPanel spPanel = this.setupSpinnerPanel(valueSpinner, panel.getBackground());
        JPanel buttonPanel = this.setupButtonPanel(okButton, cancelButton);
        c.gridy = 0;
        JTextArea l = new JTextArea(INTRO_LABEL, 5, 20);
        l.setLineWrap(true);
        l.setWrapStyleWord(true);
        l.setEditable(false);
        l.setBackground(panel.getBackground());
        panel.add((Component)l, c);
        ++c.gridy;
        panel.add((Component)radioBoxes, c);
        ++c.gridy;
        panel.add((Component)spPanel, c);
        ++c.gridy;
        panel.add((Component)buttonPanel, c);
        this.add(panel);
        this.getRootPane().setDefaultButton(okButton);
        Action action = this.setupOkAction(panel, group, valueSpinner);
        okButton.addActionListener(action);
        this.pack();
        this.setAlwaysOnTop(true);
        this.setResizable(false);
    }

    private void loadSettings(JRadioButton[] radioButtons) {
        if (VS.isShowHeatmap()) {
            if (VS.isHeatmapSF()) {
                if (VS.isHeatmapNewest()) {
                    radioButtons[2].setSelected(true);
                } else {
                    radioButtons[1].setSelected(true);
                }
            } else if (VS.isHeatmapNewest()) {
                radioButtons[4].setSelected(true);
            } else {
                radioButtons[3].setSelected(true);
            }
        } else {
            radioButtons[0].setSelected(true);
        }
    }

    private JSpinner setupSpinner() {
        final JSpinner valueSpinner = new JSpinner(new SpinnerNumberModel(5, 1, 1000, 1));
        valueSpinner.setValue(VS.getMaxAgeForHeatmap());
        valueSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VS.setHeatmapOptions(VS.isShowHeatmap(), VS.isHeatmapSF(), VS.isHeatmapNewest(), ((Integer)valueSpinner.getValue()).intValue());
            }
        });
        JFormattedTextField txt = ((JSpinner.NumberEditor)valueSpinner.getEditor()).getTextField();
        NumberFormatter nf = (NumberFormatter)txt.getFormatter();
        nf.setAllowsInvalid(false);
        nf.setValueClass(Integer.class);
        nf.setMinimum(Integer.valueOf(1));
        nf.setMaximum(Integer.valueOf(1000));
        nf.setCommitsOnValidEdit(true);
        valueSpinner.setToolTipText(TOOLTIP_TEXT);
        return valueSpinner;
    }

    private JPanel setupButtonPanel(JButton okButton, JButton cancelButton) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(okButton);
        buttonPanel.add(new JLabel("                   "));
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    private JPanel setupSpinnerPanel(JSpinner spinner, Color bg) {
        JPanel tfPanel = new JPanel();
        tfPanel.setLayout(new BorderLayout());
        JTextArea l = new JTextArea(TEXTFIELD_LABEL, 2, 20);
        l.setLineWrap(true);
        l.setWrapStyleWord(true);
        l.setEditable(false);
        l.setBackground(bg);
        tfPanel.add((Component)l, "North");
        JPanel tmp = new JPanel();
        tmp.add(new JLabel("k = "));
        tmp.add(spinner);
        tfPanel.add((Component)tmp, "Center");
        tfPanel.setBorder(BorderFactory.createBevelBorder(0));
        return tfPanel;
    }

    private JPanel setupRadioPanel(JRadioButton[] radioButtons, Color bg, final JDialog parent) {
        JPanel radioBoxes = new JPanel();
        radioBoxes.setLayout(new BoxLayout(radioBoxes, 1));
        int i = 0;
        while (i < 5) {
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            JLabel dis = new JLabel("Disable heatmaps");
            dis.setAlignmentX(0.5f);
            JLabel sf = new JLabel("Highlight sequent formulae");
            sf.setAlignmentX(0.5f);
            JLabel terms = new JLabel("Highlight terms");
            terms.setAlignmentX(0.5f);
            if (i == 0) {
                radioBoxes.add(dis);
            }
            if (i == 1) {
                radioBoxes.add(new JLabel("                   "));
                radioBoxes.add(sf);
            }
            if (i == 3) {
                radioBoxes.add(new JLabel("                   "));
                radioBoxes.add(terms);
            }
            p.add((Component)radioButtons[i], "West");
            final int j = i++;
            JButton infoButton = new JButton(new AbstractAction(){
                private static final long serialVersionUID = 6910725367740582043L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    new InfoDialog(BUTTON_NAMES[j], DESCRIPTIONS[j], parent);
                }
            });
            infoButton.setIcon(HELPICON);
            p.add((Component)infoButton, "East");
            p.setBorder(BorderFactory.createBevelBorder(0));
            radioBoxes.add(p);
        }
        return radioBoxes;
    }

    private Action setupOkAction(JPanel panel, final ButtonGroup group, final JSpinner spinner) {
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = -5840137383763071948L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String command = group.getSelection().getActionCommand();
                boolean showHm = VS.isShowHeatmap();
                boolean sf = VS.isHeatmapSF();
                boolean newest = VS.isHeatmapNewest();
                int ma = VS.getMaxAgeForHeatmap();
                if (command == COMMANDS[0]) {
                    VS.setHeatmapOptions(false, sf, newest, ma);
                    HeatmapOptionsDialog.this.dispose();
                    return;
                }
                if (command == COMMANDS[1]) {
                    showHm = true;
                    sf = true;
                    newest = false;
                } else if (command == COMMANDS[2]) {
                    showHm = true;
                    sf = true;
                    newest = true;
                } else if (command == COMMANDS[3]) {
                    showHm = true;
                    sf = false;
                    newest = false;
                } else if (command == COMMANDS[4]) {
                    showHm = true;
                    sf = false;
                    newest = true;
                }
                if (spinner.getValue() != null) {
                    VS.setHeatmapOptions(showHm, sf, newest, ((Integer)spinner.getValue()).intValue());
                    HeatmapOptionsDialog.this.dispose();
                }
            }
        };
        return action;
    }

    class InfoDialog
    extends JDialog {
        private static final long serialVersionUID = 479715116105454400L;

        public InfoDialog(String title, String s, JDialog owner) {
            super(owner);
            this.setTitle(title);
            JPanel p = new JPanel(new BorderLayout());
            JTextArea l = new JTextArea(s, 8, 20);
            l.setBorder(new EmptyBorder(3, 10, 3, 10));
            l.setLineWrap(true);
            l.setWrapStyleWord(true);
            l.setEditable(false);
            l.setBackground(owner.getBackground());
            p.add((Component)l, "North");
            this.setContentPane(p);
            this.pack();
            this.setDefaultCloseOperation(2);
            this.setLocationRelativeTo(owner);
            this.setAlwaysOnTop(true);
            this.setVisible(true);
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    InfoDialog.this.dispose();
                }
            });
            this.getRootPane().registerKeyboardAction(e -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        }
    }
}

