/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.InfoTreeNode;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.mgt.RuleJustification;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.NoPosTacletApp;
import de.uka.ilkd.key.rule.OneStepSimplifier;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.XMLResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;

public class InfoTreeModel
extends DefaultTreeModel {
    private static final long serialVersionUID = 2093787874117871875L;
    private static final String LEMMAS = "Lemmas";
    private static final String TACLET_BASE = "Taclet Base";

    public InfoTreeModel(Goal goal, XMLResources xmlResources, MainWindow mainWindow) {
        super(new InfoTreeNode());
        this.insertAsLast(new RulesNode(xmlResources.getRuleExplanations(), goal), (InfoTreeNode)this.root);
        this.insertAsLast(new TermLabelsNode(mainWindow, xmlResources.getTermLabelExplanations()), (InfoTreeNode)this.root);
        this.insertAsLast(new FunctionsNode(xmlResources.getFunctionExplanations()), (InfoTreeNode)this.root);
    }

    private void insertAsLast(InfoTreeNode ins, InfoTreeNode parent) {
        this.insertNodeInto(ins, parent, parent.getChildCount());
    }

    private class RulesNode
    extends InfoTreeNode {
        private static final long serialVersionUID = 7622830441420768861L;

        RulesNode(Properties ruleExplanations, Goal goal) {
            super("Rules", "Browse descriptions for currently available rules.");
            InfoTreeNode builtInRoot = new InfoTreeNode("Built-In", ruleExplanations);
            InfoTreeModel.this.insertAsLast(builtInRoot, this);
            InfoTreeNode axiomTacletRoot = new InfoTreeNode(InfoTreeModel.TACLET_BASE, ruleExplanations);
            InfoTreeModel.this.insertAsLast(axiomTacletRoot, this);
            InfoTreeNode proveableTacletsRoot = new InfoTreeNode(InfoTreeModel.LEMMAS, ruleExplanations);
            InfoTreeModel.this.insertAsLast(proveableTacletsRoot, this);
            if (goal != null && goal.proof() != null && goal.proof().mgt() != null) {
                for (BuiltInRule br : goal.ruleAppIndex().builtInRuleAppIndex().builtInRuleIndex().rules()) {
                    InfoTreeModel.this.insertAsLast(new InfoTreeNode(br, ruleExplanations), builtInRoot);
                }
                Set set = goal.ruleAppIndex().tacletIndex().allNoPosTacletApps();
                OneStepSimplifier simplifier = MiscTools.findOneStepSimplifier((Proof)goal.proof());
                if (simplifier != null && !simplifier.isShutdown()) {
                    set.addAll(simplifier.getCapturedTaclets());
                }
                for (NoPosTacletApp app : this.sort(set)) {
                    RuleJustification just = goal.proof().mgt().getJustification((RuleApp)app);
                    if (just == null) continue;
                    if (just.isAxiomJustification()) {
                        this.insertAndGroup(new InfoTreeNode(app.taclet()), axiomTacletRoot, ruleExplanations);
                        continue;
                    }
                    this.insertAndGroup(new InfoTreeNode(app.taclet()), proveableTacletsRoot, ruleExplanations);
                }
            }
            axiomTacletRoot.setUserObject("Taclet Base (" + this.getChildCount(axiomTacletRoot) + ")");
            proveableTacletsRoot.setUserObject("Lemmas (" + this.getChildCount(proveableTacletsRoot) + ")");
        }

        private int getChildCount(InfoTreeNode root) {
            int res = 0;
            for (int i = 0; i < root.getChildCount(); ++i) {
                InfoTreeNode child = (InfoTreeNode)root.getChildAt(i);
                int grandchildren = child.getChildCount();
                res += grandchildren == 0 ? 1 : grandchildren;
            }
            return res;
        }

        private void insertAndGroup(InfoTreeNode ins, InfoTreeNode parent, Properties ruleExplanations) {
            InfoTreeNode insNode = ins;
            if (parent.getChildCount() > 0) {
                InfoTreeNode lastNode = (InfoTreeNode)parent.getChildAt(parent.getChildCount() - 1);
                if (this.getName(insNode).equals(this.getName(lastNode))) {
                    if (lastNode.getChildCount() == 0) {
                        InfoTreeModel.this.removeNodeFromParent(lastNode);
                        InfoTreeNode oldParent = parent;
                        parent = new InfoTreeNode(this.getName(insNode), ruleExplanations);
                        insNode.setTitleToAltName();
                        lastNode.setTitleToAltName();
                        InfoTreeModel.this.insertAsLast(parent, oldParent);
                        InfoTreeModel.this.insertAsLast(lastNode, parent);
                    } else {
                        parent = lastNode;
                        insNode.setTitleToAltName();
                    }
                }
            }
            InfoTreeModel.this.insertAsLast(ins, parent);
        }

        private String getName(InfoTreeNode t1) {
            if (t1.getUserObject() instanceof Taclet) {
                return ((Taclet)t1.getUserObject()).displayName();
            }
            String title = t1.toString();
            int parenIdx = title.lastIndexOf("(");
            if (parenIdx >= 0) {
                return title.substring(0, parenIdx - 1).intern();
            }
            return title;
        }

        private List<NoPosTacletApp> sort(Set<NoPosTacletApp> set) {
            ArrayList<NoPosTacletApp> l = new ArrayList<NoPosTacletApp>(set);
            Collections.sort(l, new Comparator<NoPosTacletApp>(){

                @Override
                public int compare(NoPosTacletApp o1, NoPosTacletApp o2) {
                    Taclet t1 = o1.taclet();
                    Taclet t2 = o2.taclet();
                    return t1.displayName().compareTo(t2.displayName());
                }
            });
            return l;
        }
    }

    private class TermLabelsNode
    extends InfoTreeNode {
        private static final long serialVersionUID = 7447092361863294242L;

        TermLabelsNode(MainWindow mainWindow, Properties termLabelExplanations) {
            super("Term Labels", "Show descriptions for currently available term labels.");
            List<Name> labelNames = mainWindow.getSortedTermLabelNames();
            for (Name name : labelNames) {
                InfoTreeModel.this.insertAsLast(new InfoTreeNode(name.toString(), termLabelExplanations), this);
            }
        }
    }

    private class FunctionsNode
    extends InfoTreeNode {
        private static final long serialVersionUID = -5546552277804988834L;
        private static final String COLLECTION = "This node stands for a category of symbols; expand it to browse the symbols in the category.";
        private static final String DEFAULT_FUNCTIONS_LABEL = "Display descriptions for documented interpreted function and predicate symbols.";

        FunctionsNode(Properties functionExplanations) {
            super("Function Symbols", DEFAULT_FUNCTIONS_LABEL);
            HashMap<String, InfoTreeNode> categoryMap = new HashMap<String, InfoTreeNode>();
            ArrayList<String> sortedKeys = new ArrayList<String>(functionExplanations.stringPropertyNames());
            Collections.sort(sortedKeys);
            for (String key : sortedKeys) {
                String[] parts = key.split("/", 2);
                if (parts.length == 1) {
                    InfoTreeModel.this.insertAsLast(new InfoTreeNode(key, functionExplanations), this);
                    continue;
                }
                String category = parts[0];
                InfoTreeNode categoryNode = (InfoTreeNode)categoryMap.get(category);
                if (categoryNode == null) {
                    categoryNode = new InfoTreeNode(category, COLLECTION);
                    categoryMap.put(category, categoryNode);
                    InfoTreeModel.this.insertAsLast(categoryNode, this);
                }
                String description = functionExplanations.getProperty(key);
                InfoTreeModel.this.insertAsLast(new InfoTreeNode(parts[1], description), categoryNode);
            }
        }
    }
}

