/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.rule.BuiltInRule;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.rule.Taclet;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;

public class InfoTreeNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 4187650510339169399L;
    private final String altName;
    private String description;
    private Rule rule;

    InfoTreeNode() {
        super("root node");
        this.altName = null;
        this.description = "This is the root node of InfoTreeModel. It should not be visible.";
    }

    InfoTreeNode(String title, Properties explanations) {
        super(title);
        this.altName = null;
        String desc = explanations.getProperty(title);
        this.description = desc == null ? "No description available for " + title + "." : desc;
    }

    InfoTreeNode(Taclet taclet) {
        super(taclet.displayName());
        this.rule = taclet;
        this.altName = taclet.name().toString();
        LogicPrinter lp = new LogicPrinter(new ProgramPrinter(), new NotationInfo(), null, true);
        lp.printTaclet(taclet);
        this.description = lp.toString() + "\n\n Defined at:" + taclet.getOrigin() + "\n\n under options:" + taclet.getChoices();
    }

    InfoTreeNode(String title, String description) {
        super(title);
        this.altName = null;
        this.description = description;
    }

    public InfoTreeNode(BuiltInRule br, Properties ruleExplanations) {
        this(br.displayName(), ruleExplanations);
        this.rule = br;
        this.description = "Defined at: " + br.getOrigin();
    }

    String getTitle() {
        return (String)this.getUserObject();
    }

    void setTitleToAltName() {
        assert (this.altName != null);
        this.userObject = this.altName;
    }

    String getDescription() {
        return this.description;
    }

    public Rule getRule() {
        return this.rule;
    }
}

