/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.core.KeYSelectionModel;
import de.uka.ilkd.key.gui.InfoTree;
import de.uka.ilkd.key.gui.InfoTreeModel;
import de.uka.ilkd.key.gui.InfoTreeNode;
import de.uka.ilkd.key.gui.InfoViewContentPane;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.extension.api.DefaultContextMenuKind;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.event.ProofDisposedEvent;
import de.uka.ilkd.key.proof.event.ProofDisposedListener;
import de.uka.ilkd.key.rule.Rule;
import de.uka.ilkd.key.util.ThreadUtilities;
import de.uka.ilkd.key.util.XMLResources;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class InfoView
extends JSplitPane
implements TabPanel {
    private static final long serialVersionUID = -6944612837850368411L;
    public static final Icon INFO_ICON = IconFactory.INFO_VIEW.get(16.0f);
    private final InfoTree infoTree;
    private final InfoViewContentPane contentPane;
    private final XMLResources xmlResources;
    private final ProofDisposedListener proofDisposedListener;
    private final KeYSelectionListener selectionListener = new InfoViewSelectionListener();
    private Node lastShownGoalNode;
    private MainWindow mainWindow;
    private KeYMediator mediator;

    public InfoView() {
        super(0);
        this.xmlResources = new XMLResources();
        this.setDividerLocation(300);
        this.setResizeWeight(1.0);
        this.setName("infoViewPane");
        this.infoTree = new InfoTree();
        this.infoTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InfoTreeNode node = InfoView.this.infoTree.getLastSelectedPathComponent();
                if (node != null) {
                    InfoView.this.contentPane.setNode(node);
                } else {
                    InfoView.this.contentPane.clear();
                }
            }
        });
        this.lastShownGoalNode = null;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                Goal goal;
                if (InfoView.this.mediator.getSelectedProof() != null && (goal = InfoView.this.mediator.getSelectedGoal()) != null) {
                    InfoView.this.updateModel(InfoView.this.mediator.getSelectedGoal());
                }
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.proofDisposedListener = new ProofDisposedListener(){

            public void proofDisposing(ProofDisposedEvent e) {
            }

            public void proofDisposed(ProofDisposedEvent e) {
                InfoView.this.updateModel(null);
            }
        };
        this.infoTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            private void checkPopup(MouseEvent e) {
                Rule selected;
                JPopupMenu menu;
                if (e.isPopupTrigger() && (menu = KeYGuiExtensionFacade.createContextMenu(DefaultContextMenuKind.TACLET_INFO, selected = InfoView.this.infoTree.getLastSelectedPathComponent().getRule(), InfoView.this.mediator)).getComponentCount() > 0) {
                    menu.show(InfoView.this, e.getX(), e.getY());
                }
            }
        });
        this.contentPane = new InfoViewContentPane();
        this.setLeftComponent(new JScrollPane(this.infoTree));
        this.setRightComponent(this.contentPane);
        KeYGuiExtensionFacade.installKeyboardShortcuts(this.mediator, this, KeYGuiExtension.KeyboardShortcuts.INFO_VIEW);
    }

    public InfoView(MainWindow window, KeYMediator mediator) {
        this();
        this.setMainWindow(window);
        this.setMediator(mediator);
    }

    public void setMediator(KeYMediator m) {
        assert (m != null);
        if (this.mediator != null) {
            this.mediator.removeKeYSelectionListener(this.selectionListener);
        }
        m.addKeYSelectionListener(this.selectionListener);
        this.mediator = m;
    }

    public void setMainWindow(MainWindow w) {
        this.mainWindow = w;
    }

    @Override
    public String getTitle() {
        return "Info";
    }

    @Override
    public Icon getIcon() {
        return INFO_ICON;
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    private void updateModel(Goal g) {
        if (g == null || this.lastShownGoalNode != g.node()) {
            InfoTreeModel model;
            if (this.lastShownGoalNode != null) {
                this.lastShownGoalNode.proof().removeProofDisposedListener(this.proofDisposedListener);
            }
            if (g != null) {
                model = new InfoTreeModel(g, this.xmlResources, this.mainWindow);
                g.proof().addProofDisposedListener(this.proofDisposedListener);
                this.lastShownGoalNode = g.node();
            } else {
                model = null;
                this.lastShownGoalNode = null;
            }
            this.contentPane.clear();
            this.infoTree.setModel(model);
        }
    }

    private class InfoViewSelectionListener
    implements KeYSelectionListener {
        private InfoViewSelectionListener() {
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            KeYSelectionModel selectionModel = e.getSource();
            Runnable action = () -> {
                if (InfoView.this.isVisible()) {
                    if (selectionModel.getSelectedProof() == null) {
                        InfoView.this.updateModel(null);
                    } else if (selectionModel.getSelectedGoal() != null) {
                        InfoView.this.updateModel(selectionModel.getSelectedGoal());
                    }
                }
            };
            ThreadUtilities.invokeOnEventQueue(action);
        }
    }
}

