/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.utilities.CheckedUserInput;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.nparser.KeyIO;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.delayedcut.ApplicationCheck;
import java.util.LinkedList;
import java.util.List;

public class InspectorForDecisionPredicates
implements CheckedUserInput.CheckedUserInputInspector {
    private final Services services;
    private final Node node;
    private final int cutMode;
    private final List<ApplicationCheck> additionalChecks = new LinkedList<ApplicationCheck>();

    public InspectorForDecisionPredicates(Services services, Node node, int cutMode, List<ApplicationCheck> additionalChecks) {
        this.services = services;
        this.node = node;
        this.cutMode = cutMode;
        this.additionalChecks.addAll(additionalChecks);
    }

    @Override
    public String check(String toBeChecked) {
        if (toBeChecked.isEmpty()) {
            return " ";
        }
        Term term = InspectorForDecisionPredicates.translate(this.services, toBeChecked);
        Semisequent semisequent = this.cutMode == 0 ? this.node.sequent().antecedent() : this.node.sequent().succedent();
        String position = this.cutMode == 0 ? "antecedent" : "succedent";
        for (SequentFormula sf : semisequent) {
            if (sf.formula() != term) continue;
            return "Formula already exists in " + position + ".";
        }
        if (term == null || term.sort() != Sort.FORMULA) {
            return "Not a formula.";
        }
        for (ApplicationCheck check : this.additionalChecks) {
            String result = check.check(this.node, term);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Term translate(Services services, String toBeChecked) {
        try {
            return new KeyIO(services).parseExpression(toBeChecked);
        }
        catch (Throwable e) {
            return null;
        }
    }
}

