/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.java.PrettyPrinter;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.ldt.HeapLDT;
import de.uka.ilkd.key.logic.Named;
import de.uka.ilkd.key.logic.NamespaceSet;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.LocationVariable;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.nparser.KeyIO;
import de.uka.ilkd.key.parser.ParserException;
import de.uka.ilkd.key.pp.AbbrevMap;
import de.uka.ilkd.key.proof.io.OutputStreamProofSaver;
import de.uka.ilkd.key.rule.RuleAbortException;
import de.uka.ilkd.key.speclang.LoopSpecification;
import de.uka.ilkd.key.util.InfFlowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class InvariantConfigurator {
    private static final int INV_IDX = 0;
    private static final int MOD_IDX = 1;
    private static final int VAR_IDX = 2;
    private static final int IF_PRE_IDX = 3;
    private static final int IF_POST_IDX = 4;
    private static final int IF_OO_IDX = 5;
    private static final String DEFAULT = "Default";
    private static InvariantConfigurator configurator = null;
    private List<Map<String, String>[]> invariants = new ArrayList<Map<String, String>[]>();
    private HashMap<LoopStatement, List<Map<String, String>[]>> mapLoopsToInvariants = new LinkedHashMap<LoopStatement, List<Map<String, String>[]>>();
    private int index = 0;
    private LoopSpecification newInvariant = null;
    private boolean userPressedCancel = false;

    private InvariantConfigurator() {
    }

    public static InvariantConfigurator getInstance() {
        if (configurator == null) {
            configurator = new InvariantConfigurator();
        }
        return configurator;
    }

    public LoopSpecification getLoopInvariant(final LoopSpecification loopInv, final Services services, final boolean requiresVariant, final List<LocationVariable> heapContext) throws RuleAbortException {
        if (loopInv == null) {
            return null;
        }
        this.index = 0;
        this.userPressedCancel = false;
        class InvariantDialog
        extends JDialog {
            private final LocationVariable HEAP_LDT;
            private final Color COLOR_SUCCESS;
            private final Color COLOR_ERROR;
            private static final String INVARIANT_REQUIRED = "Invariant is required!";
            private static final String VARIANT_REQUIRED = "Variant required!";
            private static final String INVARIANTTITLE = "Invariant%s: ";
            private static final String VARIANTTITLE = "Variant%s: ";
            private static final String MODIFIESTITLE = "Modifies%s: ";
            private static final String IF_PRE_TITLE = "InfFlowPreExpressions%s: ";
            private static final String IF_POST_TITLE = "InfFlowPostExpressions%s: ";
            private static final String IF_OO_TITLE = "InfFlowNewObjects%s: ";
            private final KeyIO parser;
            private final JTabbedPane inputPane;
            private JPanel errorPanel;
            private final List<JTabbedPane> heapPanes;
            private Term variantTerm;
            private final Map<LocationVariable, Term> modifiesTerm;
            private final Map<LocationVariable, ImmutableList<InfFlowSpec>> infFlowSpecs;
            private final Map<LocationVariable, Term> invariantTerm;
            private final Map<LocationVariable, Term> freeInvariantTerm;
            private final JButton applyButton;
            private final JButton cancelButton;
            private final JButton storeButton;

            public InvariantDialog() throws RuleAbortException {
                super((Frame)MainWindow.getInstance(), true);
                this.HEAP_LDT = services.getTypeConverter().getHeapLDT().getHeap();
                this.COLOR_SUCCESS = Color.GREEN;
                this.COLOR_ERROR = Color.RED;
                this.heapPanes = new ArrayList<JTabbedPane>();
                this.variantTerm = null;
                this.modifiesTerm = new LinkedHashMap<LocationVariable, Term>();
                this.infFlowSpecs = new LinkedHashMap<LocationVariable, ImmutableList<InfFlowSpec>>();
                this.invariantTerm = new LinkedHashMap<LocationVariable, Term>();
                this.freeInvariantTerm = new LinkedHashMap<LocationVariable, Term>();
                this.applyButton = new JButton("Apply");
                this.cancelButton = new JButton("Cancel");
                this.storeButton = new JButton("Store");
                this.setTitle("Invariant Configurator");
                this.getContentPane().setLayout(new BorderLayout());
                this.initInvariants();
                this.errorPanel = this.initErrorPanel();
                this.inputPane = new JTabbedPane();
                this.initInputPane();
                this.updateActiveTabs(heapContext);
                JTextArea loopRep = this.initLoopPresentation();
                JPanel leftPanel = new JPanel();
                leftPanel.setLayout(new BorderLayout());
                leftPanel.add(new JSplitPane(0, new JScrollPane(loopRep), new JScrollPane(this.errorPanel)));
                int charXWidth = loopRep.getFontMetrics(loopRep.getFont()).charWidth('X');
                int fontHeight = loopRep.getFontMetrics(loopRep.getFont()).getHeight();
                leftPanel.setMinimumSize(new Dimension(charXWidth * 25, fontHeight * 10));
                leftPanel.setPreferredSize(new Dimension(charXWidth * 40, fontHeight * 15));
                JSplitPane split = new JSplitPane(1, true, leftPanel, this.inputPane);
                this.getContentPane().add((Component)split, "Center");
                split.setDividerLocation(0.7);
                JPanel buttonPanel = new JPanel();
                this.initButtonPanel(buttonPanel);
                this.getContentPane().add((Component)buttonPanel, "South");
                this.setDefaultCloseOperation(2);
                NamespaceSet nss = services.getNamespaces().copyWithParent();
                Term self = loopInv.getInternalSelfTerm();
                nss.programVariables().add((Named)new LocationVariable(new ProgramElementName("self"), self.sort()));
                this.parser = new KeyIO(services, nss);
                this.parser.setAbbrevMap(this.getAbbrevMap());
                this.parse();
                this.pack();
                this.setLocationRelativeTo(this.getOwner());
                this.setVisible(true);
            }

            private void initButtonPanel(JPanel buttonPanel) {
                buttonPanel.setLayout(new FlowLayout(2));
                this.applyButton.addActionListener(this::applyActionPerformed);
                this.cancelButton.addActionListener(this::cancelActionPerformed);
                this.storeButton.addActionListener(this::storeActionPerformed);
                buttonPanel.add(this.applyButton);
                buttonPanel.add(this.storeButton);
                buttonPanel.add(this.cancelButton);
            }

            private void initInputPane() {
                for (int i = 0; i < InvariantConfigurator.this.invariants.size(); ++i) {
                    this.inputPane.addTab("Inv " + i, this.createInvariantTab(i));
                    this.inputPane.validate();
                }
                this.inputPane.addChangeListener(e -> {
                    InvariantConfigurator.this.index = ((JTabbedPane)e.getSource()).getSelectedIndex();
                    this.parse();
                });
            }

            private void initInvariants() {
                ImmutableList infFlowSpecs;
                Map[] loopInvTexts = new Map[6];
                loopInvTexts[0] = new LinkedHashMap();
                Map atPres = loopInv.getInternalAtPres();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    Term invariant = loopInv.getInvariant(heap, loopInv.getInternalSelfTerm(), atPres, services);
                    if (invariant == null) {
                        loopInvTexts[0].put(heap.toString(), "true");
                        continue;
                    }
                    loopInvTexts[0].put(heap.toString(), this.printTerm(invariant, true));
                }
                loopInvTexts[1] = new LinkedHashMap();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    Term modifies = loopInv.getModifies(heap, loopInv.getInternalSelfTerm(), atPres, services);
                    if (modifies == null) {
                        loopInvTexts[1].put(heap.toString(), "allLocs");
                        continue;
                    }
                    loopInvTexts[1].put(heap.toString(), this.printTerm(modifies, false));
                }
                loopInvTexts[2] = new LinkedHashMap();
                Term variant = loopInv.getVariant(loopInv.getInternalSelfTerm(), atPres, services);
                if (variant == null) {
                    loopInvTexts[2].put(InvariantConfigurator.DEFAULT, "");
                } else {
                    loopInvTexts[2].put(InvariantConfigurator.DEFAULT, this.printTerm(variant, true));
                }
                loopInvTexts[3] = new LinkedHashMap();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    infFlowSpecs = loopInv.getInfFlowSpecs(heap, loopInv.getInternalSelfTerm(), atPres, services);
                    if (infFlowSpecs == null) {
                        loopInvTexts[3].put(heap.toString(), "true");
                        continue;
                    }
                    for (InfFlowSpec infFlowSpec : infFlowSpecs) {
                        for (Term t : infFlowSpec.preExpressions) {
                            loopInvTexts[3].put(heap.toString(), this.printTerm(t, false));
                        }
                    }
                }
                loopInvTexts[4] = new LinkedHashMap();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    infFlowSpecs = loopInv.getInfFlowSpecs(heap, loopInv.getInternalSelfTerm(), atPres, services);
                    if (infFlowSpecs == null) {
                        loopInvTexts[4].put(heap.toString(), "true");
                        continue;
                    }
                    for (InfFlowSpec infFlowSpec : infFlowSpecs) {
                        for (Term t : infFlowSpec.postExpressions) {
                            loopInvTexts[4].put(heap.toString(), this.printTerm(t, false));
                        }
                    }
                }
                loopInvTexts[5] = new LinkedHashMap();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    infFlowSpecs = loopInv.getInfFlowSpecs(heap, loopInv.getInternalSelfTerm(), atPres, services);
                    if (infFlowSpecs == null) {
                        loopInvTexts[5].put(heap.toString(), "true");
                        continue;
                    }
                    for (InfFlowSpec infFlowSpec : infFlowSpecs) {
                        for (Term t : infFlowSpec.newObjects) {
                            loopInvTexts[5].put(heap.toString(), this.printTerm(t, false));
                        }
                    }
                }
                if (!InvariantConfigurator.this.mapLoopsToInvariants.containsKey(loopInv.getLoop())) {
                    InvariantConfigurator.this.invariants = new ArrayList<Map<String, String>[]>();
                    InvariantConfigurator.this.invariants.add(loopInvTexts);
                    InvariantConfigurator.this.mapLoopsToInvariants.put(loopInv.getLoop(), InvariantConfigurator.this.invariants);
                    InvariantConfigurator.this.index = InvariantConfigurator.this.invariants.size() - 1;
                } else {
                    InvariantConfigurator.this.invariants = InvariantConfigurator.this.mapLoopsToInvariants.get(loopInv.getLoop());
                    if (!InvariantConfigurator.this.invariants.contains(loopInvTexts)) {
                        InvariantConfigurator.this.invariants.add(loopInvTexts);
                        InvariantConfigurator.this.index = InvariantConfigurator.this.invariants.size() - 1;
                    } else {
                        InvariantConfigurator.this.index = InvariantConfigurator.this.invariants.indexOf(loopInvTexts);
                    }
                }
            }

            private String printTerm(Term t, boolean pretty) {
                return OutputStreamProofSaver.printTerm((Term)t, (Services)services, (boolean)pretty).toString();
            }

            private JScrollPane createInvariantTab(int i) {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 3));
                JTabbedPane invPane = new JTabbedPane(3);
                Map<String, String> invs = InvariantConfigurator.this.invariants.get(i)[0];
                for (String k : invs.keySet()) {
                    String title = String.format(INVARIANTTITLE, k.equals(HeapLDT.BASE_HEAP_NAME.toString()) ? "" : "[" + k + "]");
                    JTextArea textArea = this.createInputTextArea(title, invs.get(k));
                    this.setInvariantListener(textArea, k, i);
                    invPane.add(k, textArea);
                }
                JTabbedPane modPane = new JTabbedPane(3);
                Map<String, String> mods = InvariantConfigurator.this.invariants.get(i)[1];
                for (String k : mods.keySet()) {
                    String title = String.format(MODIFIESTITLE, k.equals(HeapLDT.BASE_HEAP_NAME.toString()) ? "" : "[" + k + "]");
                    JTextArea textArea = this.createInputTextArea(title, mods.get(k));
                    this.setModifiesListener(textArea, k, i);
                    modPane.add(k, textArea);
                }
                JTabbedPane respPane = new JTabbedPane(3);
                Map<String, String> resps = InvariantConfigurator.this.invariants.get(i)[3];
                for (String k : resps.keySet()) {
                    String title = String.format(IF_PRE_TITLE, k.equals(HeapLDT.BASE_HEAP_NAME.toString()) ? "" : "[" + k + "]");
                    JTextArea textArea = this.createInputTextArea(title, resps.get(k));
                    this.setInfFlowPreExpsListener(textArea, k, i);
                    respPane.add(k, textArea);
                }
                JTabbedPane ifPostPane = new JTabbedPane(3);
                Map<String, String> postExps = InvariantConfigurator.this.invariants.get(i)[4];
                for (String k : postExps.keySet()) {
                    String title = String.format(IF_POST_TITLE, k.equals(HeapLDT.BASE_HEAP_NAME.toString()) ? "" : "[" + k + "]");
                    JTextArea textArea = this.createInputTextArea(title, postExps.get(k));
                    this.setInfFlowPostExpsListener(textArea, k, i);
                    ifPostPane.add(k, textArea);
                }
                JTabbedPane ifNewObjectsPane = new JTabbedPane(3);
                Map<String, String> ifNewObjects = InvariantConfigurator.this.invariants.get(i)[5];
                for (String k : ifNewObjects.keySet()) {
                    String title = String.format(IF_OO_TITLE, k.equals(HeapLDT.BASE_HEAP_NAME.toString()) ? "" : "[" + k + "]");
                    JTextArea textArea = this.createInputTextArea(title, ifNewObjects.get(k));
                    this.setInfFlowNewObsListener(textArea, k, i);
                    ifNewObjectsPane.add(k, textArea);
                }
                JTextArea vararea = this.createInputTextArea(String.format(VARIANTTITLE, ""), InvariantConfigurator.this.invariants.get(i)[2].get(InvariantConfigurator.DEFAULT));
                this.setVariantListener(vararea, InvariantConfigurator.DEFAULT, i);
                panel.add(invPane);
                panel.add(modPane);
                panel.add(vararea);
                panel.add(respPane);
                panel.add(ifPostPane);
                panel.add(ifNewObjectsPane);
                this.heapPanes.add(invPane);
                this.heapPanes.add(modPane);
                JScrollPane rightPane = new JScrollPane(panel);
                int charXWidth = vararea.getFontMetrics(vararea.getFont()).charWidth('X');
                int fontHeight = vararea.getFontMetrics(vararea.getFont()).getHeight();
                rightPane.setMinimumSize(new Dimension(charXWidth * 72, fontHeight * 15));
                rightPane.setPreferredSize(new Dimension(charXWidth * 80, fontHeight * 20));
                return rightPane;
            }

            public JTextArea createInputTextArea(String title, String text) {
                JTextArea inputTextArea = new JTextArea(text);
                inputTextArea.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.DARK_GRAY), title));
                inputTextArea.setEditable(true);
                return inputTextArea;
            }

            private void setInvariantListener(JTextArea ta, final String key, int i) {
                InvariantConfigurator.this.index = i;
                ta.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.invUpdatePerformed(e, key);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.invUpdatePerformed(e, key);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.invUpdatePerformed(e, key);
                    }
                });
            }

            private void setVariantListener(JTextArea ta, final String key, int i) {
                InvariantConfigurator.this.index = i;
                ta.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.varUpdatePerformed(e, key);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.varUpdatePerformed(e, key);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.varUpdatePerformed(e, key);
                    }
                });
            }

            private void setModifiesListener(JTextArea ta, final String key, int i) {
                InvariantConfigurator.this.index = i;
                ta.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.modUpdatePerformed(e, key);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.modUpdatePerformed(e, key);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.modUpdatePerformed(e, key);
                    }
                });
            }

            private void setInfFlowPreExpsListener(JTextArea ta, final String key, int i) {
                InvariantConfigurator.this.index = i;
                ta.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.ifPreExpsUdatePerformed(e, key);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.ifPreExpsUdatePerformed(e, key);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.ifPreExpsUdatePerformed(e, key);
                    }
                });
            }

            private void setInfFlowPostExpsListener(JTextArea ta, final String key, int i) {
                InvariantConfigurator.this.index = i;
                ta.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.ifPostExpsUdatePerformed(e, key);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.ifPostExpsUdatePerformed(e, key);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.ifPostExpsUdatePerformed(e, key);
                    }
                });
            }

            private void setInfFlowNewObsListener(JTextArea ta, final String key, int i) {
                InvariantConfigurator.this.index = i;
                ta.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.ifNewObjectsUdatePerformed(e, key);
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.ifNewObjectsUdatePerformed(e, key);
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        this.ifNewObjectsUdatePerformed(e, key);
                    }
                });
            }

            private JTextArea initLoopPresentation() {
                String source;
                JTextArea loopRep = new JTextArea();
                try {
                    StringWriter sw = new StringWriter();
                    loopInv.getLoop().prettyPrint(new PrettyPrinter((Writer)sw));
                    source = sw.toString();
                }
                catch (IOException e) {
                    source = loopInv.getLoop().toSource();
                }
                loopRep.setText(source);
                loopRep.setEditable(false);
                loopRep.setBackground(new Color(220, 220, 220));
                loopRep.setMinimumSize(loopRep.getPreferredScrollableViewportSize());
                loopRep.setLayout(new BorderLayout());
                loopRep.setBorder(BorderFactory.createTitledBorder("Loop"));
                return loopRep;
            }

            private JPanel createErrorPanel(Map<String, String> invMsgs, Map<String, Color> invColors, Map<String, String> modMsgs, Map<String, Color> modColors, Map<String, String> varMsgs, Map<String, Color> varColors) {
                JPanel panel = new JPanel();
                panel.setLayout(new BoxLayout(panel, 3));
                JTabbedPane invPane = new JTabbedPane(3);
                JTabbedPane modPane = new JTabbedPane(3);
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    String k = heap.name().toString();
                    String title = String.format("Invariant%s - Status: ", heap == this.HEAP_LDT ? "" : "[" + k + "]");
                    String errorMessage = invMsgs == null ? "OK" : invMsgs.get(k);
                    Color invColor = invColors == null ? this.COLOR_SUCCESS : invColors.get(k);
                    JTextArea textArea = this.createErrorTextField(title, errorMessage, invColor);
                    invPane.add(k, textArea);
                    title = String.format("Modifies%s - Status: ", heap == this.HEAP_LDT ? "" : "[" + k + "]");
                    String errorMessage2 = modMsgs == null ? "OK" : modMsgs.get(k);
                    Color modColor = modColors == null ? this.COLOR_SUCCESS : modColors.get(k);
                    textArea = this.createErrorTextField(title, errorMessage2, modColor);
                    modPane.add(k, textArea);
                }
                panel.add(invPane);
                panel.add(modPane);
                this.heapPanes.add(invPane);
                this.heapPanes.add(modPane);
                JTextArea varErrorArea = this.createErrorTextField("Variant - Status", varMsgs.get(InvariantConfigurator.DEFAULT), varColors.get(InvariantConfigurator.DEFAULT));
                panel.add(varErrorArea);
                int charXWidth = varErrorArea.getFontMetrics(varErrorArea.getFont()).charWidth('X');
                int fontHeight = varErrorArea.getFontMetrics(varErrorArea.getFont()).getHeight();
                varErrorArea.setMinimumSize(new Dimension(charXWidth * 80, fontHeight * 5));
                varErrorArea.setPreferredSize(new Dimension(charXWidth * 80, fontHeight * 10));
                varErrorArea.setMaximumSize(new Dimension(charXWidth * 80, fontHeight * 15));
                return panel;
            }

            private JPanel initErrorPanel() {
                LinkedHashMap<String, String> invMsgs = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> invColors = new LinkedHashMap<String, Color>();
                LinkedHashMap<String, String> modMsgs = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> modColors = new LinkedHashMap<String, Color>();
                LinkedHashMap<String, String> varMsgs = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> varColors = new LinkedHashMap<String, Color>();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    String k = heap.name().toString();
                    this.setOK(invMsgs, invColors, k);
                    this.setOK(modMsgs, modColors, k);
                }
                this.setOK(varMsgs, varColors, InvariantConfigurator.DEFAULT);
                return this.createErrorPanel(invMsgs, invColors, modMsgs, modColors, varMsgs, varColors);
            }

            private void setOK(Map<String, String> msgMap, Map<String, Color> colors, String setOn) {
                msgMap.put(setOn, "OK");
                colors.put(setOn, this.COLOR_SUCCESS);
            }

            private void setError(Map<String, String> msgMap, Map<String, Color> colors, String setOn, String errorMsg) {
                msgMap.put(setOn, errorMsg);
                colors.put(setOn, this.COLOR_ERROR);
            }

            private JTextArea createErrorTextField(String title, String errorMessage, Color color) {
                JTextArea errorTextfield = new JTextArea();
                errorTextfield.setPreferredSize(errorTextfield.getMinimumSize());
                errorTextfield.setBorder(BorderFactory.createTitledBorder(title));
                errorTextfield.setText(errorMessage);
                errorTextfield.setForeground(color);
                errorTextfield.setEditable(false);
                errorTextfield.setMinimumSize(errorTextfield.getPreferredScrollableViewportSize());
                return errorTextfield;
            }

            public void cancelActionPerformed(ActionEvent e) {
                InvariantConfigurator.this.userPressedCancel = true;
                InvariantConfigurator.this.newInvariant = null;
                this.dispose();
            }

            public void storeActionPerformed(ActionEvent aE) {
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map[] invs = (Map[])InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index).clone();
                InvariantConfigurator.this.invariants.add(invs);
                InvariantConfigurator.this.index = InvariantConfigurator.this.invariants.size() - 1;
                this.inputPane.addTab("Inv " + (InvariantConfigurator.this.invariants.size() - 1), this.createInvariantTab(InvariantConfigurator.this.index));
                this.validate();
            }

            public void applyActionPerformed(ActionEvent ae) {
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                this.parse();
                if (this.buildInvariant()) {
                    this.dispose();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void invUpdatePerformed(DocumentEvent d, String key) {
                Document doc = d.getDocument();
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map<String, String>[] inv = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index);
                try {
                    inv[0].put(key, doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    this.parse();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void modUpdatePerformed(DocumentEvent d, String key) {
                Document doc = d.getDocument();
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map<String, String>[] inv = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index);
                try {
                    inv[1].put(key, doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    this.parse();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ifPreExpsUdatePerformed(DocumentEvent d, String key) {
                Document doc = d.getDocument();
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map<String, String>[] inv = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index);
                try {
                    inv[3].put(key, doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    this.parse();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ifPostExpsUdatePerformed(DocumentEvent d, String key) {
                Document doc = d.getDocument();
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map<String, String>[] inv = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index);
                try {
                    inv[4].put(key, doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    this.parse();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void ifNewObjectsUdatePerformed(DocumentEvent d, String key) {
                Document doc = d.getDocument();
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map<String, String>[] inv = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index);
                try {
                    inv[5].put(key, doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    this.parse();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void varUpdatePerformed(DocumentEvent d, String key) {
                if (!key.equals(InvariantConfigurator.DEFAULT)) {
                    throw new IllegalStateException();
                }
                Document doc = d.getDocument();
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Map<String, String>[] inv = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index);
                try {
                    inv[2].put(key, doc.getText(0, doc.getLength()));
                }
                catch (BadLocationException badLocationException) {
                }
                finally {
                    this.parse();
                }
            }

            private boolean buildInvariant() {
                boolean requirementsAreMet = true;
                if (requiresVariant && this.variantTerm == null) {
                    LinkedHashMap<String, String> varErrors = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, Color> varColors = new LinkedHashMap<String, Color>();
                    this.setError(varErrors, varColors, InvariantConfigurator.DEFAULT, VARIANT_REQUIRED);
                    this.updateErrorPanel(null, null, null, null, varErrors, varColors);
                    requirementsAreMet = false;
                }
                if (this.invariantTerm == null) {
                    requirementsAreMet = false;
                    LinkedHashMap<String, String> invErrors = new LinkedHashMap<String, String>();
                    LinkedHashMap<String, Color> invColors = new LinkedHashMap<String, Color>();
                    this.setError(invErrors, invColors, InvariantConfigurator.DEFAULT, INVARIANT_REQUIRED);
                    this.updateErrorPanel(invErrors, invColors, null, null, null, null);
                }
                if (requirementsAreMet) {
                    InvariantConfigurator.this.newInvariant = loopInv.configurate(this.invariantTerm, this.freeInvariantTerm, this.modifiesTerm, this.infFlowSpecs, this.variantTerm);
                    return true;
                }
                return false;
            }

            private void parse() {
                LinkedHashMap<String, String> invErrors = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> invCols = new LinkedHashMap<String, Color>();
                LinkedHashMap<String, String> modErrors = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> modCols = new LinkedHashMap<String, Color>();
                LinkedHashMap<String, String> respErrors = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> respCols = new LinkedHashMap<String, Color>();
                for (LocationVariable heap : services.getTypeConverter().getHeapLDT().getAllHeaps()) {
                    try {
                        this.invariantTerm.put(heap, this.parseInvariant(heap));
                        this.setOK(invErrors, invCols, heap.toString());
                    }
                    catch (Exception e) {
                        this.setError(invErrors, invCols, heap.toString(), e.getMessage());
                    }
                    try {
                        this.modifiesTerm.put(heap, this.parseModifies(heap));
                        this.setOK(modErrors, modCols, heap.toString());
                    }
                    catch (Exception e) {
                        this.setError(modErrors, modCols, heap.toString(), e.getMessage());
                    }
                }
                LocationVariable baseHeap = this.HEAP_LDT;
                try {
                    this.infFlowSpecs.put(baseHeap, this.parseInfFlowSpec(baseHeap));
                    this.setOK(respErrors, respCols, baseHeap.toString());
                }
                catch (Exception e) {
                    this.setError(respErrors, respCols, baseHeap.toString(), e.getMessage());
                }
                LinkedHashMap<String, String> varErrors = new LinkedHashMap<String, String>();
                LinkedHashMap<String, Color> varCols = new LinkedHashMap<String, Color>();
                try {
                    int i = this.inputPane.getSelectedIndex();
                    if (InvariantConfigurator.this.invariants.get(i)[2].get(InvariantConfigurator.DEFAULT).equals("")) {
                        this.variantTerm = null;
                        if (requiresVariant) {
                            throw new ParserException(VARIANT_REQUIRED, null);
                        }
                    } else {
                        this.variantTerm = this.parseVariant();
                        this.setOK(varErrors, varCols, InvariantConfigurator.DEFAULT);
                    }
                }
                catch (Exception e) {
                    this.setError(varErrors, varCols, InvariantConfigurator.DEFAULT, e.getMessage());
                }
                this.updateErrorPanel(invErrors, invCols, modErrors, modCols, varErrors, varCols);
            }

            private void updateActiveTabs(List<LocationVariable> heapContext2) {
                for (JTabbedPane p : this.heapPanes) {
                    for (int j = 0; j < p.getTabCount(); ++j) {
                        p.setEnabledAt(j, false);
                    }
                    for (LocationVariable lv : heapContext2) {
                        p.setEnabledAt(p.indexOfTab(lv.name().toString()), true);
                    }
                }
            }

            private void updateErrorPanel(Map<String, String> invErrors, Map<String, Color> invCols, Map<String, String> modErrors, Map<String, Color> modCols, Map<String, String> varErrors, Map<String, Color> varCols) {
                JTextArea jta;
                JTabbedPane p;
                String k;
                boolean reeinit = true;
                boolean errorFound = false;
                if (invErrors != null) {
                    for (Map.Entry<String, String> entry : invErrors.entrySet()) {
                        k = entry.getKey();
                        String invError = entry.getValue();
                        Color invCol = invCols.get(k);
                        p = (JTabbedPane)this.errorPanel.getComponent(0);
                        jta = (JTextArea)p.getComponent(p.indexOfTab(k));
                        jta.setForeground(invCol);
                        jta.setText(invError);
                        if (invCol != this.COLOR_ERROR) continue;
                        errorFound = true;
                    }
                    reeinit = false;
                }
                if (modErrors != null) {
                    for (Map.Entry<String, String> entry : modErrors.entrySet()) {
                        k = entry.getKey();
                        String modError = entry.getValue();
                        Color modCol = modCols.get(k);
                        p = (JTabbedPane)this.errorPanel.getComponent(1);
                        jta = (JTextArea)p.getComponent(p.indexOfTab(k));
                        jta.setForeground(modCol);
                        jta.setText(modError);
                        if (modCol != this.COLOR_ERROR) continue;
                        errorFound = true;
                    }
                    reeinit = false;
                }
                if (varErrors != null) {
                    String varError = varErrors.get(InvariantConfigurator.DEFAULT);
                    Color varCol = varCols.get(InvariantConfigurator.DEFAULT);
                    JTextArea jta2 = (JTextArea)this.errorPanel.getComponent(2);
                    jta2.setForeground(varCol);
                    jta2.setText(varError);
                    if (varCol == this.COLOR_ERROR) {
                        errorFound = true;
                    }
                    reeinit = false;
                }
                this.applyButton.setEnabled(!errorFound);
                this.storeButton.setEnabled(!errorFound);
                if (!reeinit) {
                    Container con = this.errorPanel.getParent();
                    con.remove(this.errorPanel);
                    Dimension d = this.errorPanel.getPreferredSize();
                    this.errorPanel = this.createErrorPanel(invErrors, invCols, modErrors, modCols, varErrors, varCols);
                    this.updateActiveTabs(heapContext);
                    this.errorPanel.setPreferredSize(d);
                    con.add((Component)this.errorPanel, "South");
                }
            }

            protected Term parseInvariant(LocationVariable heap) {
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Term result = this.parser.parseExpression(InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index)[0].get(heap.toString()));
                if (result.sort() != Sort.FORMULA) {
                    throw InvariantConfigurator.newUnexpectedTypeException(Sort.FORMULA, result.sort());
                }
                return result;
            }

            private AbbrevMap getAbbrevMap() {
                return MainWindow.getInstance().getMediator().getNotationInfo().getAbbrevMap();
            }

            protected Term parseModifies(LocationVariable heap) {
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Sort locSetSort = services.getTypeConverter().getLocSetLDT().targetSort();
                String string = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index)[1].get(heap.toString());
                if (string.trim().equals("\\strictly_nothing")) {
                    return services.getTermBuilder().strictlyNothing();
                }
                Term result = this.parser.parseExpression(string);
                if (result.sort() != locSetSort) {
                    throw InvariantConfigurator.newUnexpectedTypeException(locSetSort, result.sort());
                }
                return result;
            }

            protected ImmutableList<InfFlowSpec> parseInfFlowSpec(LocationVariable heap) {
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                String preExpsAsString = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index)[3].get(heap.toString());
                String postExpsAsString = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index)[4].get(heap.toString());
                String newObjectsAsString = InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index)[5].get(heap.toString());
                Term preExps = this.parser.parseExpression(preExpsAsString);
                Term postExps = this.parser.parseExpression(postExpsAsString);
                Term newObjects = this.parser.parseExpression(newObjectsAsString);
                return ImmutableSLList.nil().append((Object)new InfFlowSpec(ImmutableSLList.nil().append((Object)preExps), ImmutableSLList.nil().append((Object)postExps), ImmutableSLList.nil().append((Object)newObjects)));
            }

            protected Term parseVariant() {
                InvariantConfigurator.this.index = this.inputPane.getSelectedIndex();
                Sort intSort = services.getTypeConverter().getIntegerLDT().targetSort();
                Term result = this.parser.parseExpression(InvariantConfigurator.this.invariants.get(InvariantConfigurator.this.index)[2].get(InvariantConfigurator.DEFAULT));
                if (result.sort() != intSort) {
                    throw InvariantConfigurator.newUnexpectedTypeException(intSort, result.sort());
                }
                return result;
            }
        }
        InvariantDialog dia = new InvariantDialog();
        dia.dispose();
        if (this.userPressedCancel) {
            throw new RuleAbortException("Interactive invariant configuration canceled by user.");
        }
        return this.newInvariant;
    }

    private static RuntimeException newUnexpectedTypeException(Sort expected, Sort actual) {
        return new IllegalStateException(String.format("Entered formula is expected of type %s but got %s.", expected, actual));
    }
}

