/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.actions.EditSourceFileAction;
import de.uka.ilkd.key.gui.actions.SendFeedbackAction;
import de.uka.ilkd.key.gui.sourceview.JavaDocument;
import de.uka.ilkd.key.gui.sourceview.TextLineNumber;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.gui.utilities.SquigglyUnderlinePainter;
import de.uka.ilkd.key.java.Position;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.speclang.PositionedString;
import de.uka.ilkd.key.speclang.SLEnvInput;
import de.uka.ilkd.key.util.ExceptionTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import org.key_project.util.collection.ImmutableSet;
import org.key_project.util.java.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IssueDialog
extends JDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssueDialog.class);
    private static final Pattern HTTP_REGEX = Pattern.compile("https?://[^\\s]+");
    private static final Set<PositionedString> ignoredWarnings = new HashSet<PositionedString>();
    private final Throwable throwable;
    private final List<PositionedIssueString> warnings;
    private final Map<String, String> fileContentsCache = new HashMap<String, String>();
    private final JTextField fTextField = new JTextField();
    private final JTextField lTextField = new JTextField();
    private final JTextField cTextField = new JTextField();
    private final JTextPane txtSource = new JTextPane();
    private final JTextArea txtStacktrace = new JTextArea();
    private final JList<PositionedIssueString> listWarnings;
    private final JButton btnEditFile = new JButton();
    private final JCheckBox chkIgnoreWarnings = new JCheckBox("Ignore these warnings for the current session");
    private final JCheckBox chkDetails = new JCheckBox("Show Details");
    private final JSplitPane splitCenter = new JSplitPane(0, true);
    private final JSplitPane splitBottom = new JSplitPane(0, true);
    private final JPanel stacktracePanel = new JPanel(new BorderLayout());
    private final boolean critical;
    private final transient ItemListener detailsBoxListener = e -> {
        int width = this.getWidth();
        int height = this.getHeight();
        if (e.getStateChange() == 1) {
            int stPrefHeight = Math.min(this.stacktracePanel.getPreferredSize().height, 300);
            this.setSize(new Dimension(width, height + stPrefHeight));
            int centerHeight = this.splitCenter.getHeight();
            this.validate();
            this.splitBottom.setDividerLocation(centerHeight + 1);
            this.splitBottom.setResizeWeight(0.66);
        } else {
            this.splitBottom.setDividerLocation(1.0);
            this.splitBottom.setResizeWeight(1.0);
            if (this.stacktracePanel.isShowing()) {
                int stHeight = this.stacktracePanel.getHeight();
                this.setSize(new Dimension(width, height - stHeight));
            }
        }
    };

    private IssueDialog(Window owner, String title, Set<PositionedIssueString> issues, boolean critical) {
        this(owner, title, issues, critical, null);
    }

    private static List<PositionedIssueString> decorateHTML(Set<PositionedIssueString> warnings) {
        return warnings.stream().map(pis -> {
            Matcher m = HTTP_REGEX.matcher(pis.text);
            StringBuilder sb = new StringBuilder();
            int start = 0;
            while (m.find()) {
                String notMatched = pis.text.substring(start, m.start());
                String escaped = LogicPrinter.escapeHTML((String)notMatched, (boolean)true);
                String repl = "<a href=\"" + m.group() + "\">" + m.group() + "</a>";
                sb.append(escaped);
                sb.append(repl);
                start = m.end();
            }
            String tail = pis.text.substring(start);
            String escapedTail = LogicPrinter.escapeHTML((String)tail, (boolean)true);
            sb.append(escapedTail);
            return new PositionedIssueString(sb.toString(), pis.fileName, pis.pos, pis.additionalInfo);
        }).collect(Collectors.toList());
    }

    private IssueDialog(Window owner, String title, Set<PositionedIssueString> warnings, boolean critical, Throwable throwable) {
        super(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.throwable = throwable;
        this.critical = critical;
        this.setDefaultCloseOperation(2);
        this.warnings = IssueDialog.decorateHTML(warnings);
        this.warnings.sort(Comparator.comparing(o -> o.fileName));
        this.setLayout(new BorderLayout());
        String head = critical ? "The following exception occurred:" : String.format("The following non-fatal problems occurred when translating your %s specifications:", SLEnvInput.getLanguage());
        JLabel label = new JLabel(head);
        label.setBorder(BorderFactory.createEmptyBorder(5, 5, 2, 5));
        this.add((Component)label, "North");
        Font font = UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW");
        if (font == null) {
            font = new Font("Monospaced", 0, 12);
        }
        this.listWarnings = new JList<PositionedIssueString>(this.warnings.toArray(new PositionedIssueString[0]));
        JScrollPane scrWarnings = this.createWarningsPane(font);
        this.splitCenter.setTopComponent(scrWarnings);
        JPanel sourcePanel = this.createSourcePanel(font);
        this.splitCenter.setBottomComponent(sourcePanel);
        this.splitCenter.setDividerLocation(-1);
        this.splitCenter.setResizeWeight(0.5);
        this.splitCenter.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.splitBottom.setTopComponent(this.splitCenter);
        this.configureStacktracePanel(font);
        this.splitBottom.setBottomComponent(this.stacktracePanel);
        this.splitBottom.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)this.splitBottom, "Center");
        this.splitBottom.addPropertyChangeListener("dividerLocation", e -> {
            this.chkDetails.removeItemListener(this.detailsBoxListener);
            int newLoc = (Integer)e.getNewValue();
            this.chkDetails.setSelected(newLoc < this.splitBottom.getMaximumDividerLocation());
            this.chkDetails.addItemListener(this.detailsBoxListener);
        });
        this.setMinimumSize(new Dimension(630, 300));
        this.splitBottom.setDividerLocation(1.0);
        this.splitBottom.setResizeWeight(1.0);
        this.stacktracePanel.setMinimumSize(new Dimension(0, 0));
        Dimension pref = this.getPreferredSize();
        Dimension minPref = new Dimension(Math.min(pref.width, 900), Math.min(pref.height, 800));
        this.setPreferredSize(minPref);
        this.pack();
        this.pack();
        this.chkDetails.setSelected(false);
        this.setLocationRelativeTo(owner);
    }

    private void configureStacktracePanel(Font font) {
        this.txtStacktrace.setFont(font);
        this.txtStacktrace.setEditable(false);
        this.txtStacktrace.setTabSize(4);
        this.txtStacktrace.setLineWrap(false);
        this.stacktracePanel.setBorder(BorderFactory.createTitledBorder("Stack Trace"));
        JScrollPane scrStacktrace = new JScrollPane(this.txtStacktrace);
        this.stacktracePanel.add(scrStacktrace);
    }

    private JScrollPane createWarningsPane(Font font) {
        JScrollPane scrWarnings;
        this.listWarnings.addListSelectionListener(e -> this.updatePreview(this.listWarnings.getSelectedValue()));
        this.listWarnings.addListSelectionListener(e -> this.updateStackTrace(this.listWarnings.getSelectedValue()));
        this.listWarnings.addListSelectionListener(e -> this.btnEditFile.setEnabled(this.listWarnings.getSelectedValue().hasFilename()));
        this.listWarnings.addListSelectionListener(e -> {
            if (this.listWarnings.getSelectedValue().additionalInfo.isEmpty()) {
                this.chkDetails.setSelected(false);
                this.chkDetails.setEnabled(false);
                this.splitBottom.setDividerSize(0);
                this.stacktracePanel.setVisible(false);
            } else {
                this.splitBottom.setDividerSize(this.splitCenter.getDividerSize());
                this.stacktracePanel.setVisible(true);
                this.chkDetails.setEnabled(true);
            }
            this.repaint();
        });
        this.listWarnings.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AttributeSet set;
                String href;
                Object attribute;
                int row = IssueDialog.this.listWarnings.locationToIndex(e.getPoint());
                ListCellRenderer<PositionedIssueString> renderer = IssueDialog.this.listWarnings.getCellRenderer();
                PositionedIssueString value = IssueDialog.this.listWarnings.getModel().getElementAt(row);
                JTextPane textPane = (JTextPane)renderer.getListCellRendererComponent(IssueDialog.this.listWarnings, value, row, false, false);
                textPane.setBounds(IssueDialog.this.listWarnings.getCellBounds(row, row));
                Rectangle cellRect = IssueDialog.this.listWarnings.getCellBounds(row, row);
                int x = e.getX() - cellRect.x;
                int y = e.getY() - cellRect.y;
                MouseEvent translated = new MouseEvent(textPane, e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), false);
                Element elem = IssueDialog.getHyperlinkElement(translated);
                if (elem != null && (attribute = elem.getAttributes().getAttribute(HTML.Tag.A)) instanceof AttributeSet && (href = (String)(set = (AttributeSet)attribute).getAttribute(HTML.Attribute.HREF)) != null) {
                    try {
                        textPane.fireHyperlinkUpdate(new HyperlinkEvent(textPane, HyperlinkEvent.EventType.ACTIVATED, new URL(href)));
                    }
                    catch (MalformedURLException exc) {
                        exc.printStackTrace();
                    }
                }
            }
        });
        this.listWarnings.addMouseMotionListener(new MouseMotionAdapter(){
            boolean entered = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                int row = IssueDialog.this.listWarnings.locationToIndex(e.getPoint());
                ListCellRenderer<PositionedIssueString> renderer = IssueDialog.this.listWarnings.getCellRenderer();
                PositionedIssueString value = IssueDialog.this.listWarnings.getModel().getElementAt(row);
                JTextPane textPane = (JTextPane)renderer.getListCellRendererComponent(IssueDialog.this.listWarnings, value, row, false, false);
                textPane.setBounds(IssueDialog.this.listWarnings.getCellBounds(row, row));
                Rectangle cellRect = IssueDialog.this.listWarnings.getCellBounds(row, row);
                int x = e.getX() - cellRect.x;
                int y = e.getY() - cellRect.y;
                MouseEvent translated = new MouseEvent(textPane, e.getID(), e.getWhen(), e.getModifiersEx(), x, y, e.getClickCount(), false);
                Element elem = IssueDialog.getHyperlinkElement(translated);
                if (elem != null) {
                    AttributeSet set;
                    String href;
                    Object attribute = elem.getAttributes().getAttribute(HTML.Tag.A);
                    if (attribute instanceof AttributeSet && (href = (String)(set = (AttributeSet)attribute).getAttribute(HTML.Attribute.HREF)) != null && !this.entered) {
                        this.entered = true;
                        IssueDialog.this.listWarnings.setCursor(Cursor.getPredefinedCursor(12));
                    }
                } else if (this.entered) {
                    this.entered = false;
                    IssueDialog.this.listWarnings.setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        this.listWarnings.setSelectionMode(0);
        this.listWarnings.setCellRenderer(new PositionedStringListRenderer());
        this.listWarnings.setSelectedIndex(0);
        this.listWarnings.setEnabled(true);
        this.listWarnings.setFocusable(true);
        this.listWarnings.setFont(font);
        if (this.warnings.size() == 1) {
            JTextPane issueTextPane = new JTextPane();
            issueTextPane.setEditable(false);
            issueTextPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            issueTextPane.setFont(font);
            issueTextPane.setContentType("text/html");
            issueTextPane.addHyperlinkListener(hle -> {
                if (hle.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(hle.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            PositionedString value = this.warnings.get(0);
            issueTextPane.setText(value.text);
            scrWarnings = new JScrollPane(issueTextPane);
            issueTextPane.setCaretPosition(0);
        } else {
            scrWarnings = new JScrollPane(this.listWarnings);
        }
        return scrWarnings;
    }

    private static Element getHyperlinkElement(MouseEvent event) {
        HTMLDocument hdoc;
        Element elem;
        JEditorPane editor = (JEditorPane)event.getSource();
        int pos = editor.getUI().viewToModel(editor, event.getPoint());
        if (pos >= 0 && editor.getDocument() instanceof HTMLDocument && (elem = (hdoc = (HTMLDocument)editor.getDocument()).getCharacterElement(pos)).getAttributes().getAttribute(HTML.Tag.A) != null) {
            return elem;
        }
        return null;
    }

    private JPanel createSourcePanel(Font font) {
        this.txtSource.setEditable(false);
        this.txtSource.setFont(font);
        JPanel nowrap = new JPanel(new BorderLayout());
        nowrap.add(this.txtSource);
        JScrollPane scrPreview = new JScrollPane();
        scrPreview.setViewportView(nowrap);
        scrPreview.getVerticalScrollBar().setUnitIncrement(30);
        scrPreview.getHorizontalScrollBar().setUnitIncrement(30);
        TextLineNumber lineNumbers = new TextLineNumber(this.txtSource, 2);
        scrPreview.setRowHeaderView(lineNumbers);
        JButton btnOK = new JButton("OK");
        btnOK.addActionListener(e -> this.accept());
        Dimension buttonDim = new Dimension(100, 29);
        btnOK.setPreferredSize(buttonDim);
        btnOK.setMinimumSize(buttonDim);
        JButton btnSendFeedback = new JButton(new SendFeedbackAction(this, this.throwable));
        Dimension feedbackBtnDim = new Dimension(btnSendFeedback.getPreferredSize().width, buttonDim.height);
        btnSendFeedback.setMinimumSize(feedbackBtnDim);
        btnSendFeedback.setPreferredSize(feedbackBtnDim);
        Box pSouth = new Box(1);
        JPanel pButtons = new JPanel(new FlowLayout(1));
        pButtons.add(btnOK);
        pButtons.add(this.btnEditFile);
        pButtons.add(btnSendFeedback);
        pButtons.add(this.chkDetails);
        this.chkDetails.addItemListener(this.detailsBoxListener);
        EditSourceFileAction action = new EditSourceFileAction(this, this.throwable);
        this.btnEditFile.setAction(action);
        GuiUtilities.attachClickOnEscListener(btnOK);
        this.chkIgnoreWarnings.setSelected(false);
        if (!this.critical) {
            pSouth.add(this.chkIgnoreWarnings);
        }
        pSouth.add(pButtons);
        this.getRootPane().setDefaultButton(btnOK);
        JPanel sourcePanel = new JPanel(new BorderLayout());
        JPanel locPanel = new JPanel();
        this.fTextField.setEditable(false);
        this.lTextField.setEditable(false);
        this.cTextField.setEditable(false);
        locPanel.add(this.fTextField);
        locPanel.add(this.lTextField);
        locPanel.add(this.cTextField);
        sourcePanel.add((Component)locPanel, "North");
        sourcePanel.add(scrPreview);
        sourcePanel.add((Component)pSouth, "South");
        return sourcePanel;
    }

    public static void showExceptionDialog(Window parent, Throwable exception) {
        Set<PositionedIssueString> msg = Collections.singleton(IssueDialog.extractMessage(exception));
        IssueDialog dlg = new IssueDialog(parent, "Parser Error", msg, true, exception);
        dlg.setVisible(true);
        dlg.dispose();
    }

    public static void showWarningsIfNecessary(Window parent, ImmutableSet<PositionedString> warnings) {
        Set warn = warnings.toSet();
        warn.removeAll(ignoredWarnings);
        if (!warn.isEmpty()) {
            Set<PositionedIssueString> issues = warnings.stream().map(o -> o instanceof PositionedIssueString ? (PositionedIssueString)((Object)o) : new PositionedIssueString((PositionedString)o, "")).collect(Collectors.toSet());
            IssueDialog dialog = new IssueDialog(parent, SLEnvInput.getLanguage() + " warning(s)", issues, false);
            dialog.setVisible(true);
            dialog.dispose();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static PositionedIssueString extractMessage(Throwable exception) {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                exception.printStackTrace(pw);
                String message = exception.getMessage();
                String info = sw.toString();
                if (exception.getCause() != null) {
                    String causeMessage = exception.getCause().getMessage();
                    message = message == null ? causeMessage : String.format("%s%n%nCaused by: %s", message, exception.getCause().toString());
                }
                String resourceLocation = "";
                Position pos = Position.UNDEFINED;
                Location location = ExceptionTools.getLocation((Throwable)exception);
                if (Location.isValidLocation((Location)location)) {
                    resourceLocation = location.getFileURL().toString();
                    pos = new Position(location.getLine(), location.getColumn());
                }
                PositionedIssueString positionedIssueString = new PositionedIssueString(message == null ? exception.toString() : message, resourceLocation, pos, info);
                pw.close();
                return positionedIssueString;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Creating a Location failed for {}", (Object)exception, (Object)e);
            return new PositionedIssueString("Constructing the error message failed!");
        }
    }

    private void accept() {
        if (!this.critical && this.chkIgnoreWarnings.isSelected()) {
            ignoredWarnings.addAll(this.warnings);
        }
        this.setVisible(false);
    }

    private void updatePreview(PositionedIssueString issue) {
        if (!issue.fileName.isEmpty()) {
            this.fTextField.setText("URL: " + issue.fileName);
        } else {
            this.fTextField.setText("");
        }
        this.cTextField.setText("Column: " + issue.pos.getColumn());
        this.lTextField.setText("Line: " + issue.pos.getLine());
        this.btnEditFile.setEnabled(issue.pos != Position.UNDEFINED);
        try {
            String source = this.fileContentsCache.computeIfAbsent(issue.fileName, fn -> {
                String string;
                block8: {
                    InputStream stream = IOUtil.openStream((String)issue.fileName);
                    try {
                        string = IOUtil.readFrom((InputStream)stream);
                        if (stream == null) break block8;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            LOGGER.debug("Unknown IOException!", (Throwable)e);
                            return "[SOURCE COULD NOT BE LOADED]\n" + e.getMessage();
                        }
                    }
                    stream.close();
                }
                return string;
            });
            if (this.isJava(issue.fileName)) {
                this.showJavaSourceCode(source);
            } else {
                this.txtSource.setText(source);
            }
            DefaultHighlighter dh = new DefaultHighlighter();
            this.txtSource.setHighlighter(dh);
            this.addHighlights(dh, issue.fileName);
            int offset = issue.pos.isNegative() ? 0 : IssueDialog.getOffsetFromLineColumn(source, issue.pos);
            this.txtSource.setCaretPosition(offset);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.validate();
    }

    private void updateStackTrace(PositionedIssueString issue) {
        this.txtStacktrace.setText(issue.additionalInfo);
    }

    private void showJavaSourceCode(String source) {
        try {
            JavaDocument doc = new JavaDocument();
            this.txtSource.setDocument(doc);
            doc.insertString(0, source, new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void addHighlights(DefaultHighlighter dh, String fileName) {
        this.warnings.stream().filter(ps -> fileName.equals(ps.fileName)).forEach(ps -> this.addHighlights(dh, (PositionedString)ps));
    }

    private void addHighlights(DefaultHighlighter dh, PositionedString ps) {
        int offset;
        int end;
        if (ps.pos.isNegative()) {
            return;
        }
        String source = this.txtSource.getText();
        for (end = offset = IssueDialog.getOffsetFromLineColumn(source, ps.pos); end < source.length() && !Character.isWhitespace(source.charAt(end)); ++end) {
        }
        try {
            if (this.critical) {
                dh.addHighlight(offset, end, new SquigglyUnderlinePainter(Color.RED, 2, 1.0f));
            } else {
                dh.addHighlight(offset, end, new SquigglyUnderlinePainter(Color.ORANGE, 2, 1.0f));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private boolean isJava(String fileName) {
        return fileName.endsWith(".java");
    }

    public static int getOffsetFromLineColumn(String source, Position pos) {
        return IssueDialog.getOffsetFromLineColumn(source, pos.getLine() - 1, pos.getColumn() - 1);
    }

    private static int getOffsetFromLineColumn(String source, int line, int column) {
        int pos;
        if (line < 0) {
            throw new IllegalArgumentException();
        }
        if (column < 0) {
            throw new IllegalArgumentException();
        }
        char[] c = source.toCharArray();
        for (pos = 0; pos < c.length && line > 0; ++pos) {
            if (c[pos] != '\n') continue;
            --line;
        }
        if (line == 0) {
            return pos + column;
        }
        throw new ArrayIndexOutOfBoundsException("Given position is out of bounds.");
    }

    private static class PositionedStringListRenderer
    implements ListCellRenderer<PositionedString> {
        private final JTextPane textPane = new JTextPane();

        PositionedStringListRenderer() {
            this.textPane.addHyperlinkListener(hle -> {
                if (hle.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(hle.getURL().toURI());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends PositionedString> list, PositionedString value, int index, boolean isSelected, boolean cellHasFocus) {
            this.textPane.setContentType("text/html");
            this.textPane.setText(value.text);
            this.textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.LIGHT_GRAY), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            if (isSelected) {
                this.textPane.setBackground(list.getSelectionBackground());
                this.textPane.setForeground(list.getSelectionForeground());
            } else {
                this.textPane.setBackground(list.getBackground());
                this.textPane.setForeground(list.getForeground());
            }
            this.textPane.setEnabled(true);
            this.textPane.setEditable(false);
            this.textPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.textPane.setFont(list.getFont());
            return this.textPane;
        }
    }

    private static class PositionedIssueString
    extends PositionedString {
        @Nonnull
        private final String additionalInfo;

        public PositionedIssueString(@Nonnull String text, @Nullable String fileName, @Nullable Position pos, @Nonnull String additionalInfo) {
            super(text, fileName, pos);
            this.additionalInfo = additionalInfo;
        }

        public PositionedIssueString(@Nonnull String text) {
            this(text, null, null, "");
        }

        public PositionedIssueString(@Nonnull PositionedString o, @Nonnull String additionalInfo) {
            this(o.text, o.fileName, o.pos, additionalInfo);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PositionedIssueString that = (PositionedIssueString)((Object)o);
            return this.additionalInfo.equals(that.additionalInfo);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.additionalInfo);
        }
    }
}

