/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.KeYFileChooserBookmarkPanel;
import java.awt.Component;
import java.io.File;
import java.util.Locale;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.key_project.util.java.IOUtil;

public final class KeYFileChooser
extends JFileChooser {
    public static final FileFilter DEFAULT_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            String s = f.toString().toLowerCase(Locale.ROOT);
            return f.isDirectory() || s.endsWith(".java") || s.endsWith(".key") || s.endsWith(".proof") || s.endsWith(".proof.gz") || s.endsWith(".zproof");
        }

        @Override
        public String getDescription() {
            return "Java files, (compressed) KeY files, proof bundles, and source directories";
        }
    };
    public static final FileFilter KEY_FILTER = new FileNameExtensionFilter("KeY files", "key");
    public static final FileFilter STATISTICS_FILTER = new FileNameExtensionFilter("proof statistics files (.csv, .html)", "csv", "html");
    public static final FileFilter JAVA_FILTER = new FileNameExtensionFilter("Java source files (.java)", "java");
    public static final FileFilter COMPRESSED_FILTER = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.toString().toLowerCase(Locale.ROOT).endsWith(".proof.gz");
        }

        @Override
        public String getDescription() {
            return "compressed proof files (.proof.gz)";
        }
    };
    public static final FileFilter INTERACTION_LOG_FILTER = new FileNameExtensionFilter("interaction logs (.xml)", "xml");
    public static final FileFilter ZIP_FILTER = new FileNameExtensionFilter("ZIP archives (.zip)", "zip");
    public static final FileFilter PROOF_BUNDLE_FILTER = new FileNameExtensionFilter("proof bundles (.zproof)", "zproof");
    private static final File HOME_DIR = IOUtil.getHomeDirectory();
    private static KeYFileChooser INSTANCE;
    private static final long serialVersionUID = -7598570660247063980L;
    private boolean saveDialog;
    private File resetFile = null;

    private KeYFileChooser(File initDir) {
        super(initDir);
        this.addChoosableFileFilter(DEFAULT_FILTER);
        this.addChoosableFileFilter(STATISTICS_FILTER);
        this.addChoosableFileFilter(JAVA_FILTER);
        this.addChoosableFileFilter(COMPRESSED_FILTER);
        this.addChoosableFileFilter(INTERACTION_LOG_FILTER);
        this.addChoosableFileFilter(ZIP_FILTER);
        this.addChoosableFileFilter(PROOF_BUNDLE_FILTER);
        this.setFileFilter(DEFAULT_FILTER);
    }

    public boolean useCompression() {
        return this.getSelectedFile().getName().endsWith(".proof.gz");
    }

    @Override
    public void approveSelection() {
        File file = this.getSelectedFile();
        if (this.saveDialog && file.exists() && this.showOverwriteDialog(file) != 0) {
            return;
        }
        super.approveSelection();
    }

    public void prepare() {
        File selFile = this.getSelectedFile();
        if (selFile == null) {
            if (this.getCurrentDirectory() == null) {
                this.setCurrentDirectory(HOME_DIR);
            }
        } else if (selFile.isFile()) {
            String filename = selFile.getAbsolutePath();
            if (!filename.endsWith(".proof")) {
                this.setSelectedFile(new File(filename + ".proof"));
            }
        } else if (selFile.isDirectory()) {
            this.setCurrentDirectory(selFile);
        }
    }

    @Override
    public void setDialogTitle(String title) {
        if (title != null) {
            super.setDialogTitle(title);
        } else {
            super.setDialogTitle("Select file to load");
        }
    }

    private void setSaveDialog(boolean b) {
        this.saveDialog = b;
        this.setFileSelectionMode(b ? 0 : 2);
    }

    @Override
    public int showSaveDialog(Component parent) {
        return this.showSaveDialog(parent, null, null);
    }

    public int showSaveDialog(Component parent, File originalFile, String extension) {
        File selectedFile;
        if (originalFile == null) {
            selectedFile = this.getCurrentDirectory();
        } else {
            selectedFile = originalFile.getAbsoluteFile();
            if (selectedFile.isFile() || !selectedFile.exists() && selectedFile.getName().contains(".")) {
                selectedFile = selectedFile.getParentFile();
            }
        }
        if (extension != null) {
            File dirForExtension;
            if (extension.endsWith(".key")) {
                for (dirForExtension = selectedFile; dirForExtension != null && !"src".equals(dirForExtension.getName()); dirForExtension = dirForExtension.getParentFile()) {
                }
            }
            this.resetFile = "src".equals(dirForExtension.getName()) && dirForExtension.getParentFile() != null ? dirForExtension.getParentFile() : selectedFile;
            selectedFile = new File(this.resetFile, extension);
        } else {
            this.resetFile = selectedFile;
        }
        this.setSelectedFile(this.resetFile);
        this.setSaveDialog(true);
        return this.showSaveDialog(parent, selectedFile);
    }

    public int showSaveDialog(Component parent, File selectedFile) {
        if (selectedFile != null) {
            if (selectedFile.isDirectory()) {
                this.setSelectedFile(null);
                this.setCurrentDirectory(selectedFile);
            } else {
                this.setSelectedFile(selectedFile);
                this.updateUI();
            }
        }
        if (this.resetFile == null) {
            this.resetFile = this.getCurrentDirectory();
        }
        this.setSaveDialog(true);
        int result = super.showSaveDialog(parent);
        if (result != 0) {
            this.resetPath();
        }
        return result;
    }

    private void resetPath() {
        assert (this.resetFile != null);
        if (this.resetFile.isDirectory()) {
            this.setSelectedFile(null);
            this.setCurrentDirectory(this.resetFile);
        } else {
            this.setSelectedFile(this.resetFile);
        }
        this.updateUI();
        this.resetFile = null;
    }

    @Override
    public int showOpenDialog(Component component) {
        File file;
        this.setSaveDialog(false);
        this.resetFile = file = this.getSelectedFile() != null ? this.getSelectedFile() : this.getCurrentDirectory();
        if (file.isDirectory()) {
            this.setSelectedFile(null);
            this.setCurrentDirectory(file);
        } else {
            this.setSelectedFile(file);
        }
        this.updateUI();
        int result = super.showOpenDialog(component);
        if (result != 0) {
            this.resetPath();
        } else {
            this.resetFile = null;
        }
        return result;
    }

    private int showOverwriteDialog(File file) {
        return JOptionPane.showOptionDialog(this, "File " + file.getAbsolutePath() + " already exists. Overwrite?", "Save warning", 0, 2, null, null, null);
    }

    public static KeYFileChooser getFileChooser(String title) {
        if (INSTANCE == null) {
            File initDir = Main.getWorkingDir();
            INSTANCE = new KeYFileChooser(initDir);
            new KeYFileChooserBookmarkPanel(INSTANCE);
        }
        INSTANCE.setDialogTitle(title);
        INSTANCE.prepare();
        return INSTANCE;
    }
}

