/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.filechooser.FileFilter;

public class KeYFileChooserBookmarkPanel
extends JPanel {
    private static final long serialVersionUID = -6498548666886815605L;
    @Nonnull
    private final JFileChooser chooser;
    private final ViewSettings viewSettings = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
    private final DefaultListModel<File> bookmarks = new DefaultListModel();
    private final JList<File> listBookmarks = new JList<File>(this.bookmarks);
    private final KeyAction actionAddBookmark = new AddBookmarkAction();
    private final KeyAction actionRemoveBookmark = new RemoveBookmarkAction();
    private final KeyAction actionExternalAddBookmark = new AddExternalBookmarkAction();

    public KeYFileChooserBookmarkPanel(@Nonnull JFileChooser chooser) {
        this.chooser = chooser;
        chooser.setAccessory(this);
        chooser.addPropertyChangeListener("directoryChanged", e -> {
            File selected = chooser.getCurrentDirectory();
            this.listBookmarks.setSelectedValue(selected, true);
        });
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder("Bookmarks:"));
        this.createPane();
        this.loadBookmarks();
    }

    private void createPane() {
        JScrollPane scrollPane = new JScrollPane(this.listBookmarks);
        scrollPane.setPreferredSize(new Dimension(250, 250));
        this.add(scrollPane);
        this.listBookmarks.setCellRenderer(new BookmarkRenderer());
        this.listBookmarks.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    KeYFileChooserBookmarkPanel.this.setBookmark();
                }
            }
        });
        this.listBookmarks.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    KeYFileChooserBookmarkPanel.this.setBookmark();
                }
            }
        });
        JPanel pSouth = new JPanel();
        pSouth.add(new JButton(this.actionAddBookmark));
        pSouth.add(new JButton(this.actionExternalAddBookmark));
        pSouth.add(new JButton(this.actionRemoveBookmark));
        this.add((Component)pSouth, "South");
    }

    private void setBookmark() {
        if (this.listBookmarks.getSelectedValue() != null) {
            this.chooser.setCurrentDirectory(this.listBookmarks.getSelectedValue());
        }
    }

    private void loadBookmarks() {
        this.viewSettings.getFolderBookmarks().forEach(it -> this.bookmarks.addElement(new File((String)it)));
    }

    private void saveBookmarks() {
        ArrayList<String> newMarks = new ArrayList<String>();
        Enumeration<File> iter = this.bookmarks.elements();
        while (iter.hasMoreElements()) {
            newMarks.add(iter.nextElement().getAbsolutePath());
        }
        this.viewSettings.setFolderBookmarks(newMarks);
    }

    private class RemoveBookmarkAction
    extends KeyAction {
        private static final long serialVersionUID = -728674460657577694L;

        RemoveBookmarkAction() {
            this.setName("");
            this.setIcon(IconFactory.minus(16));
            this.setTooltip("Removes the current selected bookmark from the list.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selected = KeYFileChooserBookmarkPanel.this.listBookmarks.getSelectedIndex();
            if (selected >= 0) {
                KeYFileChooserBookmarkPanel.this.bookmarks.removeElementAt(selected);
                KeYFileChooserBookmarkPanel.this.saveBookmarks();
            }
        }
    }

    private class AddExternalBookmarkAction
    extends KeyAction {
        private static final long serialVersionUID = 6594623530260257684L;

        AddExternalBookmarkAction() {
            this.setIcon(IconFactory.PLUS_SQUARED.get(16.0f));
            this.setTooltip("Opens a new file selection dialog to select a new bookmark.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser(KeYFileChooserBookmarkPanel.this.chooser.getCurrentDirectory());
            FileFilter ff = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "A directory to add to the bookmarks";
                }
            };
            fc.setFileFilter(ff);
            fc.setFileSelectionMode(1);
            int res = fc.showOpenDialog(null);
            if (res == 0) {
                File toAdd = fc.getSelectedFile();
                int index = KeYFileChooserBookmarkPanel.this.bookmarks.indexOf(toAdd);
                if (index >= 0) {
                    return;
                }
                KeYFileChooserBookmarkPanel.this.bookmarks.addElement(toAdd);
                KeYFileChooserBookmarkPanel.this.saveBookmarks();
            }
        }
    }

    private class AddBookmarkAction
    extends KeyAction {
        private static final long serialVersionUID = 3800814610168973715L;

        AddBookmarkAction() {
            this.setIcon(IconFactory.plus(16));
            this.setTooltip("Adds the current directory to the bookmarks.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File toAdd = KeYFileChooserBookmarkPanel.this.chooser.getCurrentDirectory();
            if (toAdd != null) {
                int index = KeYFileChooserBookmarkPanel.this.bookmarks.indexOf(toAdd);
                if (index >= 0) {
                    return;
                }
                KeYFileChooserBookmarkPanel.this.bookmarks.addElement(toAdd);
                KeYFileChooserBookmarkPanel.this.saveBookmarks();
            }
        }
    }

    private static class BookmarkRenderer
    implements ListCellRenderer<File> {
        private static final int LIMIT = 25;
        private final DefaultListCellRenderer renderer = new DefaultListCellRenderer();

        private BookmarkRenderer() {
        }

        private String toString(File file) {
            StringBuilder sb = new StringBuilder();
            do {
                sb.insert(0, file.getName());
                file = file.getParentFile();
                if (file == null) continue;
                sb.insert(0, '/');
            } while (file != null && sb.length() < 25);
            if (file != null) {
                sb.insert(0, '\u2026');
            }
            return sb.toString();
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends File> list, File value, int index, boolean isSelected, boolean cellHasFocus) {
            String val = value.getAbsolutePath().length() <= 25 ? value.getAbsolutePath() : this.toString(value);
            return this.renderer.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
        }
    }
}

