/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.rule.RuleApp;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class KeyboardTacletModel {
    public static final String PROP_CURRENT_PREFIX = "currentPrefix";
    public static final String PROP_CURRENT_POS = "currentPos";
    private final Map<String, List<RuleApp>> taclets;
    private final Map<String, String> prefixTable;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String currentPrefix;
    private int currentPos;

    KeyboardTacletModel(List<RuleApp> taclets) {
        this.reset();
        this.taclets = new HashMap<String, List<RuleApp>>();
        ArrayList<String> seq = new ArrayList<String>(taclets.size());
        for (RuleApp t : taclets) {
            String n = t.rule().name().toString();
            seq.add(n);
            List appSeq = this.taclets.computeIfAbsent(n, it -> new ArrayList(5));
            appSeq.add(t);
        }
        this.prefixTable = KeyboardTacletModel.buildPrefixTable(seq);
    }

    static int getClashFreePrefix(String unique, Collection<String> strings) {
        return strings.stream().filter(it -> !it.equals(unique)).mapToInt(c -> KeyboardTacletModel.getPrefixLength(unique, c)).max().orElse(0);
    }

    static int getPrefixLength(String a, String b) {
        int i;
        for (i = 0; !(i >= Math.min(a.length(), b.length()) || a.charAt(i) != b.charAt(i) && KeyboardTacletModel.charValid(a.charAt(i)) && KeyboardTacletModel.charValid(b.charAt(i))); ++i) {
        }
        return i;
    }

    static Map<String, String> buildPrefixTable(List<String> seq) {
        HashMap<String, String> table = new HashMap<String, String>();
        for (String name : seq) {
            int prefixL = KeyboardTacletModel.getClashFreePrefix(name, seq);
            table.put(name.substring(0, Math.min(prefixL + 1, name.length())), name);
        }
        return table;
    }

    static boolean charValid(char c) {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void processChar(char c) {
        switch (c) {
            case '\u001b': {
                this.reset();
                break;
            }
            case '\b': {
                if (this.currentPrefix.length() <= 1) {
                    this.setCurrentPrefix("");
                    break;
                }
                this.setCurrentPrefix(this.currentPrefix.substring(0, this.currentPrefix.length() - 1));
                break;
            }
            default: {
                if ('0' <= c && c <= '9') {
                    this.setCurrentPos(c - 48);
                }
                if (!KeyboardTacletModel.charValid(c)) break;
                this.setCurrentPrefix(this.currentPrefix + c);
            }
        }
    }

    public int getCurrentPos() {
        return this.currentPos;
    }

    public void setCurrentPos(int currentPos) {
        int old = this.currentPos;
        this.currentPos = currentPos;
        this.propertyChangeSupport.firePropertyChange(PROP_CURRENT_POS, old, currentPos);
    }

    private void reset() {
        this.setCurrentPrefix("");
        this.setCurrentPos(-1);
    }

    public Optional<RuleApp> getSelectedTacletsApp() {
        List<RuleApp> t = this.taclets.get(this.prefixTable.get(this.currentPrefix));
        if (t != null && t.size() == 1 || this.currentPos >= 0 && this.currentPos <= this.taclets.size()) {
            assert (t != null);
            return Optional.of(t.get(Math.max(0, this.currentPos)));
        }
        return Optional.empty();
    }

    public Optional<RuleApp> getFirstMatchingTacletApp() {
        for (String prefix : this.getPrefixTable().keySet()) {
            if (!prefix.startsWith(this.currentPrefix)) continue;
            String tacletName = this.prefixTable.get(prefix);
            List<RuleApp> apps = this.taclets.get(tacletName);
            return Optional.of(apps.get(0));
        }
        return Optional.empty();
    }

    public Map<String, String> getPrefixTable() {
        return this.prefixTable;
    }

    public String getCurrentPrefix() {
        return this.currentPrefix;
    }

    public void setCurrentPrefix(String currentPrefix) {
        String old = this.currentPrefix;
        this.currentPrefix = currentPrefix;
        this.propertyChangeSupport.firePropertyChange(PROP_CURRENT_PREFIX, old, currentPrefix);
    }

    public Collection<String> getTacletNames() {
        return this.prefixTable.values().stream().sorted().collect(Collectors.toList());
    }

    public Map<String, List<RuleApp>> getTaclets() {
        return this.taclets;
    }
}

