/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import bibliothek.gui.dock.common.action.CAction;
import bibliothek.gui.dock.common.action.CDropDownButton;
import de.uka.ilkd.key.gui.KeyboardTacletModel;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.docking.DockingHelper;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontSwing;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.TermServices;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.rulefilter.TacletFilter;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.ui.MediatorProofControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyboardTacletPanel
extends JPanel
implements TabPanel {
    private static final String PROP_MODEL = "taclets";
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyboardTacletPanel.class);
    private final Services services;
    private final JTextField txtInput = new JTextField();
    private final ActivateAction actionActivate = new ActivateAction();
    private final FilterMouseAction actionFilterUsingMouse = new FilterMouseAction();
    private final DirectModeAction actionDirectMode = new DirectModeAction();
    private final OnlyCompleteTacletsAction actionOnlyCompleteTaclets = new OnlyCompleteTacletsAction();
    private final MainWindow mainWindow;
    @Nullable
    private KeyboardTacletModel model;
    private Box pCenter = new Box(1);
    @Nullable
    private Goal lastGoal;
    private PropertyChangeListener updateListener = f -> {
        this.updateCurrentPrefix();
        this.relayout();
    };

    public KeyboardTacletPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.services = mainWindow.getMediator().getServices();
        this.setLayout(new BorderLayout());
        JPanel pNorth = new JPanel((LayoutManager)new MigLayout("fillX"));
        this.add((Component)pNorth, "North");
        JLabel lblInput = new JLabel("Input:");
        lblInput.setLabelFor(this.txtInput);
        pNorth.add(lblInput);
        pNorth.add((Component)this.txtInput, new CC().growX(1000.0f));
        this.txtInput.addActionListener(e -> this.applyCurrentTaclet());
        this.txtInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                KeyboardTacletPanel.this.checkForApplicability();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                KeyboardTacletPanel.this.checkForApplicability();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                KeyboardTacletPanel.this.checkForApplicability();
            }
        });
        mainWindow.currentGoalView.addPropertyChangeListener("lastMousePosition", e -> {
            if (this.actionFilterUsingMouse.isSelected()) {
                this.buildModel();
            }
        });
        this.pCenter.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(new JScrollPane(this.pCenter));
        this.addPropertyChangeListener(PROP_MODEL, e -> {
            if (e.getOldValue() != null) {
                ((KeyboardTacletModel)e.getOldValue()).removePropertyChangeListener(this.updateListener);
            }
            ((KeyboardTacletModel)e.getNewValue()).addPropertyChangeListener(this.updateListener);
            this.updateListener.propertyChange(e);
        });
    }

    private void checkForApplicability() {
        if (this.model != null) {
            this.model.setCurrentPrefix(this.txtInput.getText());
            if (this.isDirectMode()) {
                Optional<RuleApp> app = this.model.getSelectedTacletsApp();
                app.ifPresent(this::applyRule);
            }
        }
    }

    private void applyCurrentTaclet() {
        if (this.model != null) {
            Optional<RuleApp> app = this.model.getFirstMatchingTacletApp();
            app.ifPresent(this::applyRule);
            LOGGER.debug("selected taclet applied");
        }
    }

    private void applyRule(RuleApp ruleApp) {
        MediatorProofControl pc = this.mainWindow.getMediator().getUI().getProofControl();
        if (!ruleApp.complete()) {
            try {
                TacletApp tacletApp = (TacletApp)ruleApp;
                ImmutableSet seq = ImmutableSet.singleton((Object)tacletApp);
                pc.selectedTaclet(seq, this.lastGoal);
            }
            catch (ClassCastException classCastException) {}
        } else {
            pc.applyInteractive(ruleApp, this.lastGoal);
        }
        this.mainWindow.setStatusLine("Taclet applied!");
        SwingUtilities.invokeLater(() -> this.txtInput.setText(""));
    }

    @Override
    public Collection<CAction> getTitleCActions() {
        CDropDownButton btnOptions = new CDropDownButton("Options", IconFontSwing.buildIcon(FontAwesomeSolid.COGS, 12.0f));
        btnOptions.add(DockingHelper.translateAction(this.actionActivate));
        btnOptions.addSeparator();
        btnOptions.add(DockingHelper.translateAction(this.actionDirectMode));
        btnOptions.add(DockingHelper.translateAction(this.actionFilterUsingMouse));
        btnOptions.add(DockingHelper.translateAction(this.actionOnlyCompleteTaclets));
        return Collections.singleton(btnOptions);
    }

    private void updateCurrentPrefix() {
    }

    private void relayout() {
        this.pCenter.removeAll();
        if (this.model == null || !this.actionActivate.isSelected()) {
            return;
        }
        Set<String> names = this.model.getPrefixTable().keySet();
        for (String prefix : names) {
            if (!prefix.startsWith(this.model.getCurrentPrefix())) continue;
            Box box = new Box(0);
            String name = this.model.getPrefixTable().get(prefix);
            int pLength = prefix.length();
            JLabel lblName = new JLabel(String.format("<html><u>%s</u>%s</html>", prefix, name.substring(pLength)));
            box.add(lblName);
            int i = 0;
            for (RuleApp tacletApp : this.model.getTaclets().get(name)) {
                box.add(new JLabel("" + ++i));
            }
            this.pCenter.add(box);
        }
        this.pCenter.invalidate();
        this.pCenter.invalidate();
        this.pCenter.repaint();
        this.pCenter.repaint();
        this.pCenter.repaint();
    }

    public KeyboardTacletModel getModel() {
        return this.model;
    }

    public void setModel(KeyboardTacletModel model) {
        KeyboardTacletModel old = this.model;
        this.model = model;
        this.firePropertyChange(PROP_MODEL, old, model);
    }

    @Override
    public String getTitle() {
        return "Active Taclets";
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void setGoal(Goal selectedGoal) {
        if (this.lastGoal != selectedGoal) {
            this.lastGoal = selectedGoal;
            this.buildModel();
        }
    }

    private void buildModel() {
        if (!this.isActive()) {
            this.pCenter.removeAll();
            this.pCenter.add(new JLabel("Not activated."));
            return;
        }
        if (this.lastGoal == null) {
            this.pCenter.removeAll();
            this.pCenter.add(new JLabel("Could not get the current goal"));
            this.pCenter.add(new JLabel("Is a proof loaded?"));
            return;
        }
        long time = System.currentTimeMillis();
        List<Object> taclets = new LinkedList();
        PosInSequent pos = this.mainWindow.currentGoalView.getLastPosInSequent();
        if (this.actionFilterUsingMouse.isSelected() && pos == null) {
            this.pCenter.add(new JLabel("<html><b>Warning:</b> No last mouse position found in the sequent."));
        }
        if (this.actionFilterUsingMouse.isSelected() && pos != null) {
            TacletFilter filter = new TacletFilter(){

                protected boolean filter(Taclet taclet) {
                    return true;
                }
            };
            try {
                ImmutableList t = this.lastGoal.ruleAppIndex().getFindTaclet(filter, pos.getPosInOccurrence(), (TermServices)this.services);
                t.forEach(taclets::add);
            }
            catch (NullPointerException e) {
                LOGGER.debug("NPE", (Throwable)e);
            }
        } else {
            taclets = this.lastGoal.getAllBuiltInRuleApps();
            taclets.addAll(this.lastGoal.getAllTacletApps(this.services));
        }
        LOGGER.debug("Found {} taclets\n", (Object)taclets.size());
        if (this.actionOnlyCompleteTaclets.isSelected()) {
            taclets = taclets.stream().filter(RuleApp::complete).collect(Collectors.toList());
        }
        KeyboardTacletModel newModel = new KeyboardTacletModel(taclets);
        this.setModel(newModel);
        LOGGER.debug("Took: {} ms", (Object)(System.currentTimeMillis() - time));
    }

    public boolean isActive() {
        return this.actionActivate.isSelected();
    }

    public boolean isDirectMode() {
        return this.actionDirectMode.isSelected();
    }

    private class OnlyCompleteTacletsAction
    extends KeyAction {
        public OnlyCompleteTacletsAction() {
            this.setName("Show only completed taclets");
            this.setSelected(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardTacletPanel.this.buildModel();
        }
    }

    private class DirectModeAction
    extends KeyAction {
        public DirectModeAction() {
            this.setName("Apply directly on unique match.");
            this.setSelected(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class FilterMouseAction
    extends KeyAction {
        public FilterMouseAction() {
            this.setSelected(true);
            this.setName("Filter taclets by mouse position");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardTacletPanel.this.buildModel();
        }
    }

    private class ActivateAction
    extends KeyAction {
        public ActivateAction() {
            this.setName("Active");
            this.setSelected(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KeyboardTacletPanel.this.buildModel();
        }
    }
}

