/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.Log;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeYGuiExtension.Info(experimental=false, name="Log View")
public class LogView
implements KeYGuiExtension,
KeYGuiExtension.StatusLine {
    public static final IconFontProvider BOOK_DEAD = new IconFontProvider(FontAwesomeSolid.BOOK_DEAD);
    private static final KeyAction actShowLog = new ShowLogAction();
    private static final Action actOpenExternal = new OpenLogExternalAction();

    @Override
    public List<JComponent> getStatusLineComponents() {
        JButton btnShowLog = new JButton(actShowLog);
        return Collections.singletonList(btnShowLog);
    }

    static class OpenLogExternalAction
    extends KeyAction {
        private static final Logger LOGGER = LoggerFactory.getLogger(OpenLogExternalAction.class);

        public OpenLogExternalAction() {
            this.setName("Open log externally");
            this.lookupAcceleratorKey();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File file = Log.getCurrentLogFile().toFile();
            try {
                Desktop.getDesktop().edit(file);
            }
            catch (IOException ex) {
                LOGGER.error("Could not open editor.", (Throwable)ex);
            }
            catch (UnsupportedOperationException ex) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (IOException exc) {
                    LOGGER.error("Could not open editor via Desktop#open.", (Throwable)ex);
                }
            }
        }
    }

    static class LogViewPane
    extends JPanel {
        private static final SimpleAttributeSet ATTRIB_TIME = new SimpleAttributeSet();
        private static final AttributeSet ATTRIB_EMPTY = SimpleAttributeSet.EMPTY;
        private static final SimpleAttributeSet ATTRIB_LEVEL = new SimpleAttributeSet();
        private static final SimpleAttributeSet ATTRIB_THREAD = new SimpleAttributeSet();
        private static final SimpleAttributeSet ATTRIB_CLASS = new SimpleAttributeSet();
        private static final SimpleAttributeSet ATTRIB_FILE = new SimpleAttributeSet();
        private static final SimpleAttributeSet ATTRIB_MSG = new SimpleAttributeSet();
        private static final SimpleAttributeSet ATTRIB_EX = new SimpleAttributeSet();
        private static final AttributeSet[] STYLES = new AttributeSet[]{ATTRIB_TIME, ATTRIB_LEVEL, ATTRIB_THREAD, ATTRIB_CLASS, ATTRIB_FILE, ATTRIB_MSG, ATTRIB_EX};
        private final JTextPane txtView = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                Container parent = this.getParent();
                TextUI ui = this.getUI();
                return parent != null ? ui.getPreferredSize((JComponent)this).width <= parent.getSize().width : true;
            }
        };
        private final JCheckBox chkInfo = new JCheckBox("INFO", true);
        private final JCheckBox chkWarn = new JCheckBox("WARN", true);
        private final JCheckBox chkDebug = new JCheckBox("DEBUG", false);
        private final JCheckBox chkTrace = new JCheckBox("TRACE", false);
        private final JCheckBox chkError = new JCheckBox("ERROR", true);
        private final Thread fileWatcherServiceThread;
        private final JTextField txtMessageSearch = new JTextField();
        private final JTextField txtPackageSearch = new JTextField();
        private boolean pause = false;
        private final Path logFile = Log.getCurrentLogFile();

        public LogViewPane() {
            this.setLayout(new BorderLayout());
            this.txtView.setEditable(false);
            this.txtView.setFont(new Font("Monospaced", 0, 12));
            JPanel pFilter = new JPanel();
            pFilter.setLayout((LayoutManager)new MigLayout());
            pFilter.setBorder(BorderFactory.createTitledBorder("Filter"));
            pFilter.add(new JLabel("Level:"));
            pFilter.add(this.chkError);
            pFilter.add(this.chkWarn);
            pFilter.add(this.chkInfo);
            pFilter.add(this.chkDebug);
            pFilter.add((Component)this.chkTrace, new CC().wrap());
            pFilter.add(new JLabel("Text:"));
            pFilter.add((Component)this.txtMessageSearch, new CC().span(new int[]{5}).growX().wrap());
            pFilter.add(new JLabel("Package (Prefix):"));
            pFilter.add((Component)this.txtPackageSearch, new CC().span(new int[]{5}).growX());
            JPanel pActions = new JPanel();
            pActions.add(new JButton(actOpenExternal));
            this.add((Component)pFilter, "North");
            this.add((Component)pActions, "South");
            JScrollPane scrPane = new JScrollPane(22, 32);
            scrPane.setAutoscrolls(false);
            scrPane.setViewportView(this.txtView);
            this.add((Component)scrPane, "Center");
            FileWatcherService fileWatcherService = new FileWatcherService(this.logFile.getParent(), this::refresh);
            this.fileWatcherServiceThread = new Thread(fileWatcherService);
            this.refresh();
            ActionListener update = e -> this.refresh();
            this.chkTrace.addActionListener(update);
            this.chkDebug.addActionListener(update);
            this.chkInfo.addActionListener(update);
            this.chkWarn.addActionListener(update);
            this.chkError.addActionListener(update);
            this.txtMessageSearch.addActionListener(update);
            this.txtPackageSearch.addActionListener(update);
        }

        public void refresh() {
            if (this.pause) {
                return;
            }
            this.txtView.setText("");
            String pkgFilter = this.txtPackageSearch.getText().trim();
            boolean pkgFilterApply = pkgFilter.isEmpty();
            String msgFilter = this.txtMessageSearch.getText().trim();
            boolean msgFilterApply = msgFilter.isEmpty();
            boolean levelError = this.chkError.isSelected();
            boolean levelInfo = this.chkInfo.isSelected();
            boolean levelWarn = this.chkWarn.isSelected();
            boolean levelDebug = this.chkDebug.isSelected();
            boolean levelTrace = this.chkTrace.isSelected();
            try (BufferedReader reader = Files.newBufferedReader(this.logFile);){
                String line;
                while ((line = reader.readLine()) != null) {
                    boolean skipTraceLevel;
                    if (line.charAt(0) == '#') continue;
                    String[] fields = line.split("[|]");
                    boolean skipByMsgFilter = msgFilterApply && !fields[5].contains(msgFilter);
                    boolean skipByPkgFilter = pkgFilterApply && !fields[4].startsWith(pkgFilter);
                    boolean skipErrorLevel = !levelError && "ERROR".equals(fields[1]);
                    boolean skipWarnLevel = !levelWarn && "WARN".equals(fields[1]);
                    boolean skipInfoLevel = !levelInfo && "INFO".equals(fields[1]);
                    boolean skipDebugLevel = !levelDebug && "DEBUG".equals(fields[1]);
                    boolean bl = skipTraceLevel = !levelTrace && "TRACE".equals(fields[1]);
                    if (skipErrorLevel || skipDebugLevel || skipTraceLevel || skipInfoLevel || skipWarnLevel || skipByMsgFilter || skipByPkgFilter) continue;
                    this.appendLine(fields);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void appendLine(String[] fields) {
            for (int i = 0; i < fields.length; ++i) {
                this.appendField(fields[i], STYLES[i]);
                if (i == fields.length - 1) {
                    this.appendField("\n", ATTRIB_EMPTY);
                    continue;
                }
                this.appendField("    ", ATTRIB_EMPTY);
            }
        }

        private void appendField(String txt, AttributeSet set) {
            int pos = this.txtView.getDocument().getEndPosition().getOffset() - 1;
            try {
                this.txtView.getDocument().insertString(pos, txt, set);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }

        public void onShow() {
            this.fileWatcherServiceThread.start();
        }

        public void dispose() {
            this.fileWatcherServiceThread.interrupt();
        }

        public void setPause(boolean flag) {
            this.pause = flag;
            flag = !flag;
            this.txtView.setEnabled(flag);
            this.chkDebug.setEnabled(flag);
            this.chkTrace.setEnabled(flag);
            this.chkError.setEnabled(flag);
            this.chkWarn.setEnabled(flag);
            this.chkInfo.setEnabled(flag);
            this.txtMessageSearch.setEnabled(flag);
        }

        static {
            StyleConstants.setForeground(ATTRIB_TIME, Color.gray);
            StyleConstants.setBold(ATTRIB_LEVEL, true);
            StyleConstants.setForeground(ATTRIB_LEVEL, Color.white);
            StyleConstants.setBackground(ATTRIB_LEVEL, Color.black);
            StyleConstants.setForeground(ATTRIB_THREAD, Color.gray);
            StyleConstants.setForeground(ATTRIB_CLASS, Color.gray);
        }
    }

    private static class ShowLogAction
    extends KeyAction {
        public ShowLogAction() {
            this.setName("Show log");
            this.setIcon(BOOK_DEAD.get(16.0f));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JDialog dialog = new JDialog((Frame)MainWindow.getInstance(), "Log View");
            dialog.setModal(false);
            final LogViewPane ui = new LogViewPane();
            dialog.setDefaultCloseOperation(2);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    ui.onShow();
                }

                @Override
                public void windowClosed(WindowEvent e) {
                    ui.dispose();
                }

                @Override
                public void windowIconified(WindowEvent e) {
                    ui.setPause(true);
                }

                @Override
                public void windowDeiconified(WindowEvent e) {
                    ui.setPause(true);
                }
            });
            dialog.setContentPane(ui);
            dialog.setSize(800, 600);
            dialog.setVisible(true);
        }
    }

    public static class FileWatcherService
    implements Runnable {
        private static final Logger LOGGER = LoggerFactory.getLogger(FileWatcherService.class);
        private final Path file;
        private final Runnable callback;

        public FileWatcherService(Path fileToWatch, Runnable callback) {
            this.file = fileToWatch;
            this.callback = callback;
        }

        @Override
        public void run() {
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                WatchKey watchKey = this.file.getParent().register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                while (!Thread.interrupted()) {
                    WatchKey wk = watchService.take();
                    for (WatchEvent<?> event : wk.pollEvents()) {
                        if (wk != watchKey) continue;
                        this.callback.run();
                    }
                    wk.reset();
                }
            }
            catch (IOException e) {
                LOGGER.error("IO exception during listening for events", (Throwable)e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

