/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.InteractiveRuleApplicationCompletion;
import de.uka.ilkd.key.gui.InvariantConfigurator;
import de.uka.ilkd.key.java.JavaTools;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.statement.LoopStatement;
import de.uka.ilkd.key.java.statement.MethodFrame;
import de.uka.ilkd.key.java.statement.While;
import de.uka.ilkd.key.logic.JavaBlock;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.LoopInvariantBuiltInRuleApp;
import de.uka.ilkd.key.rule.LoopScopeInvariantRule;
import de.uka.ilkd.key.rule.RuleAbortException;
import de.uka.ilkd.key.rule.WhileInvariantRule;
import de.uka.ilkd.key.speclang.LoopSpecImpl;
import de.uka.ilkd.key.speclang.LoopSpecification;
import de.uka.ilkd.key.util.MiscTools;

public class LoopInvariantRuleCompletion
implements InteractiveRuleApplicationCompletion {
    @Override
    public IBuiltInRuleApp complete(IBuiltInRuleApp app, Goal goal, boolean forced) {
        boolean requiresVariant;
        Services services = goal.proof().getServices();
        services = services.getOverlay(goal.getLocalNamespaces());
        LoopInvariantBuiltInRuleApp loopApp = ((LoopInvariantBuiltInRuleApp)app).tryToInstantiate(goal);
        Term progPost = loopApp.programTerm();
        While loop = loopApp.getLoopStatement();
        LoopSpecification inv = loopApp.getSpec();
        if (inv == null) {
            MethodFrame mf = JavaTools.getInnermostMethodFrame((JavaBlock)progPost.javaBlock(), (Services)services);
            inv = new LoopSpecImpl((LoopStatement)loop, mf == null ? null : mf.getProgramMethod(), mf == null || mf.getProgramMethod() == null ? null : mf.getProgramMethod().getContainerType(), mf == null ? null : MiscTools.getSelfTerm((MethodFrame)JavaTools.getInnermostMethodFrame((JavaBlock)progPost.javaBlock(), (Services)services), (Services)services), null);
            try {
                inv = InvariantConfigurator.getInstance().getLoopInvariant(inv, services, false, loopApp.getHeapContext());
            }
            catch (RuleAbortException e) {
                return null;
            }
        }
        boolean bl = requiresVariant = loopApp.variantRequired() && !loopApp.variantAvailable();
        if (!forced || !loopApp.invariantAvailable() || requiresVariant) {
            try {
                inv = InvariantConfigurator.getInstance().getLoopInvariant(inv, services, requiresVariant, loopApp.getHeapContext());
            }
            catch (RuleAbortException e) {
                return null;
            }
        }
        if (inv != null && forced) {
            services.getSpecificationRepository().addLoopInvariant(inv);
        }
        return inv == null ? null : loopApp.setLoopInvariant(inv);
    }

    @Override
    public boolean canComplete(IBuiltInRuleApp app) {
        return LoopInvariantRuleCompletion.checkCanComplete(app);
    }

    public static boolean checkCanComplete(IBuiltInRuleApp app) {
        return app.rule() instanceof WhileInvariantRule || app.rule() instanceof LoopScopeInvariantRule;
    }
}

