/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;

class MainStatusLine
extends JPanel {
    private static final long serialVersionUID = 2278249652314818379L;
    private final JLabel lblStatusText = new JLabel();
    private final JProgressBar progressBar = new JProgressBar();

    MainStatusLine(String initialText, Font font) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new BevelBorder(1));
        this.setBackground(Color.gray);
        this.setFont(font);
        this.setOpaque(false);
        this.lblStatusText.setText(initialText);
        this.lblStatusText.setIcon(IconFactory.keyLogo(35, 20));
        this.lblStatusText.setBorder(BorderFactory.createCompoundBorder(this.lblStatusText.getBorder(), BorderFactory.createEmptyBorder(0, 10, 0, 0)));
        this.add(this.lblStatusText);
        this.add(Box.createHorizontalStrut(50));
        this.progressBar.setValue(0);
        this.progressBar.setStringPainted(true);
        this.progressBar.setMaximumSize(new Dimension(100, Short.MAX_VALUE));
        this.progressBar.setEnabled(true);
        this.progressBar.setVisible(false);
        this.add(this.progressBar);
        this.add(Box.createHorizontalGlue());
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setRollover(false);
        bar.setBorderPainted(false);
        this.add(bar);
        KeYGuiExtensionFacade.getStatusLineComponents().forEach(bar::add);
    }

    public void reset() {
        this.setProgressPanelVisible(false);
    }

    public void setProgressBarMaximum(int value) {
        this.progressBar.setMaximum(value);
    }

    public void setProgress(int value) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(value));
    }

    public void setProgressPanelVisible(boolean visible) {
        this.progressBar.setVisible(visible);
        if (visible) {
            this.setProgress(0);
        }
    }

    public void setStatusText(String s) {
        this.lblStatusText.setText(s);
    }
}

