/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.control.TermLabelVisibilityManager;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.ApplyTacletDialog;
import de.uka.ilkd.key.gui.GUIListener;
import de.uka.ilkd.key.gui.GoalList;
import de.uka.ilkd.key.gui.InfoView;
import de.uka.ilkd.key.gui.MainStatusLine;
import de.uka.ilkd.key.gui.RecentFileMenu;
import de.uka.ilkd.key.gui.StrategySelectionView;
import de.uka.ilkd.key.gui.TaskTree;
import de.uka.ilkd.key.gui.WindowUserInterfaceControl;
import de.uka.ilkd.key.gui.actions.AbandonTaskAction;
import de.uka.ilkd.key.gui.actions.AboutAction;
import de.uka.ilkd.key.gui.actions.AutoModeAction;
import de.uka.ilkd.key.gui.actions.AutoSave;
import de.uka.ilkd.key.gui.actions.DecreaseFontSizeAction;
import de.uka.ilkd.key.gui.actions.EditMostRecentFileAction;
import de.uka.ilkd.key.gui.actions.EnsureSourceConsistencyToggleAction;
import de.uka.ilkd.key.gui.actions.ExitMainAction;
import de.uka.ilkd.key.gui.actions.GoalBackAction;
import de.uka.ilkd.key.gui.actions.GoalSelectAboveAction;
import de.uka.ilkd.key.gui.actions.GoalSelectBelowAction;
import de.uka.ilkd.key.gui.actions.HidePackagePrefixToggleAction;
import de.uka.ilkd.key.gui.actions.IncreaseFontSizeAction;
import de.uka.ilkd.key.gui.actions.KeYProjectHomepageAction;
import de.uka.ilkd.key.gui.actions.LemmaGenerationAction;
import de.uka.ilkd.key.gui.actions.LemmaGenerationBatchModeAction;
import de.uka.ilkd.key.gui.actions.LicenseAction;
import de.uka.ilkd.key.gui.actions.MacroKeyBinding;
import de.uka.ilkd.key.gui.actions.MenuSendFeedackAction;
import de.uka.ilkd.key.gui.actions.MinimizeInteraction;
import de.uka.ilkd.key.gui.actions.OpenExampleAction;
import de.uka.ilkd.key.gui.actions.OpenFileAction;
import de.uka.ilkd.key.gui.actions.OpenMostRecentFileAction;
import de.uka.ilkd.key.gui.actions.OpenSingleJavaFileAction;
import de.uka.ilkd.key.gui.actions.PrettyPrintToggleAction;
import de.uka.ilkd.key.gui.actions.ProofManagementAction;
import de.uka.ilkd.key.gui.actions.PruneProofAction;
import de.uka.ilkd.key.gui.actions.QuickLoadAction;
import de.uka.ilkd.key.gui.actions.QuickSaveAction;
import de.uka.ilkd.key.gui.actions.RightMouseClickToggleAction;
import de.uka.ilkd.key.gui.actions.RunAllProofsAction;
import de.uka.ilkd.key.gui.actions.SMTInvokeAction;
import de.uka.ilkd.key.gui.actions.SMTOptionsAction;
import de.uka.ilkd.key.gui.actions.SaveBundleAction;
import de.uka.ilkd.key.gui.actions.SaveFileAction;
import de.uka.ilkd.key.gui.actions.SearchInProofTreeAction;
import de.uka.ilkd.key.gui.actions.SearchInSequentAction;
import de.uka.ilkd.key.gui.actions.SearchModeChangeAction;
import de.uka.ilkd.key.gui.actions.SearchNextAction;
import de.uka.ilkd.key.gui.actions.SearchPreviousAction;
import de.uka.ilkd.key.gui.actions.ShowActiveSettingsAction;
import de.uka.ilkd.key.gui.actions.ShowActiveTactletOptionsAction;
import de.uka.ilkd.key.gui.actions.ShowKnownTypesAction;
import de.uka.ilkd.key.gui.actions.ShowProofStatistics;
import de.uka.ilkd.key.gui.actions.ShowUsedContractsAction;
import de.uka.ilkd.key.gui.actions.SyntaxHighlightingToggleAction;
import de.uka.ilkd.key.gui.actions.TacletOptionsAction;
import de.uka.ilkd.key.gui.actions.TermLabelMenu;
import de.uka.ilkd.key.gui.actions.ToggleConfirmExitAction;
import de.uka.ilkd.key.gui.actions.ToggleSequentViewTooltipAction;
import de.uka.ilkd.key.gui.actions.ToggleSourceViewTooltipAction;
import de.uka.ilkd.key.gui.actions.ToolTipOptionsAction;
import de.uka.ilkd.key.gui.actions.UnicodeToggleAction;
import de.uka.ilkd.key.gui.configuration.Config;
import de.uka.ilkd.key.gui.docking.DockingHelper;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.help.HelpFacade;
import de.uka.ilkd.key.gui.help.HelpInfo;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalView;
import de.uka.ilkd.key.gui.nodeviews.EmptySequent;
import de.uka.ilkd.key.gui.nodeviews.InnerNodeView;
import de.uka.ilkd.key.gui.nodeviews.MainFrame;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.gui.nodeviews.SequentViewSearchBar;
import de.uka.ilkd.key.gui.notification.NotificationManager;
import de.uka.ilkd.key.gui.notification.events.ExitKeYEvent;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.gui.proofdiff.ProofDiffFrame;
import de.uka.ilkd.key.gui.prooftree.ProofTreeView;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.smt.DropdownSelectionButton;
import de.uka.ilkd.key.gui.sourceview.SourceViewFrame;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.settings.GeneralSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import de.uka.ilkd.key.settings.ViewSettings;
import de.uka.ilkd.key.smt.SolverTypeCollection;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import de.uka.ilkd.key.util.Debug;
import de.uka.ilkd.key.util.KeYResourceManager;
import de.uka.ilkd.key.util.PreferenceSaver;
import de.uka.ilkd.key.util.ThreadUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.MouseInputAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HelpInfo
public final class MainWindow
extends JFrame {
    public static final int TOOLBAR_ICON_SIZE = 16;
    public static final String AUTO_MODE_TEXT = "Start/stop automated proof search";
    private static final long serialVersionUID = 5853419918923902636L;
    private static final String PARA = "<p style=\"font-family: lucida;font-size: 12pt;font-weight: bold\">";
    private static final Logger LOGGER = LoggerFactory.getLogger(MainWindow.class);
    private static MainWindow instance = null;
    public final SequentViewSearchBar sequentViewSearchBar;
    public final CurrentGoalView currentGoalView;
    public final JMenu smtOptions = new JMenu("SMT Solvers...");
    private final GoalList openGoalsView;
    private final ProofTreeView proofTreeView;
    private final InfoView infoView;
    private final StrategySelectionView strategySelectionView;
    private final MainFrame mainFrame;
    private final SourceViewFrame sourceViewFrame;
    private final EmptySequent emptySequent;
    private final JScrollPane proofListView;
    private final TaskTree proofList;
    private final KeYMediator mediator;
    private final WindowUserInterfaceControl userInterface;
    private final MainProofListener proofListener;
    private final RecentFileMenu recentFileMenu;
    private final AutoModeAction autoModeAction;
    private final NotificationManager notificationManager;
    private final PreferenceSaver prefSaver = new PreferenceSaver(Preferences.userNodeForPackage(MainWindow.class));
    private final HidePackagePrefixToggleAction hidePackagePrefixToggleAction = new HidePackagePrefixToggleAction(this);
    private final ToggleSequentViewTooltipAction toggleSequentViewTooltipAction = new ToggleSequentViewTooltipAction(this);
    private final ToggleSourceViewTooltipAction toggleSourceViewTooltipAction = new ToggleSourceViewTooltipAction(this);
    private final TermLabelMenu termLabelMenu;
    public boolean frozen = false;
    private final CControl dockControl = new CControl((JFrame)this);
    private JToolBar controlToolBar;
    private JToolBar fileOpToolBar;
    private MainStatusLine statusLine;
    private OpenFileAction openFileAction;
    private OpenSingleJavaFileAction openSingleJavaFileAction;
    private OpenExampleAction openExampleAction;
    private OpenMostRecentFileAction openMostRecentFileAction;
    private EditMostRecentFileAction editMostRecentFileAction;
    private SaveFileAction saveFileAction;
    private SaveBundleAction saveBundleAction;
    private QuickSaveAction quickSaveAction;
    private QuickLoadAction quickLoadAction;
    private ProofManagementAction proofManagementAction;
    private LemmaGenerationAction loadUserDefinedTacletsAction;
    private LemmaGenerationAction loadUserDefinedTacletsForProvingAction;
    private LemmaGenerationAction loadKeYTaclets;
    private LemmaGenerationBatchModeAction lemmaGenerationBatchModeAction;
    private GoalSelectAboveAction goalSelectAboveAction;
    private GoalSelectBelowAction goalSelectBelowAction;
    private DropdownSelectionButton smtComponent;
    private DropdownSelectionButton.EmptyAction noSolverSelected;
    private ChangeListener selectAllListener;
    private JCheckBoxMenuItem selectAll;
    private JSeparator separator;
    private ExitMainAction exitMainAction;
    private ShowActiveSettingsAction showActiveSettingsAction;
    private UnicodeToggleAction unicodeToggleAction;
    private SingleCDockable dockProofListView;
    private SingleCDockable dockSourceView;
    private SingleCDockable dockSequent;
    private final Function<Action[], Action> collapseChoice = a -> {
        HashSet types = new HashSet();
        StringBuilder builder = new StringBuilder();
        for (Action action : a) {
            if (!(action instanceof SMTInvokeAction)) continue;
            types.addAll(((SMTInvokeAction)action).getSolverUnion().getTypes());
        }
        if (types.isEmpty() || ((Action[])a).length == 0) {
            return this.noSolverSelected;
        }
        for (SolverType type : types) {
            builder.append(type.getName() + ", ");
        }
        builder.delete(builder.length() - 2, builder.length());
        SolverTypeCollection chosenSolvers = new SolverTypeCollection(builder.toString(), types.size(), types);
        return new SMTInvokeAction(chosenSolvers, this);
    };
    private boolean disableCurrentGoalView = false;

    private MainWindow() {
        this.getRootPane().getInputMap().put(HelpFacade.ACTION_OPEN_HELP.getAcceleratorKey(), HelpFacade.ACTION_OPEN_HELP);
        this.getRootPane().getActionMap().put(HelpFacade.ACTION_OPEN_HELP, HelpFacade.ACTION_OPEN_HELP);
        this.setTitle(KeYResourceManager.getManager().getUserInterfaceTitle());
        this.setLocationByPlatform(true);
        this.applyGnomeWorkaround();
        if (!this.applyTaskbarIcon()) {
            this.applyMacOsWorkaround();
        }
        this.setLaF();
        this.setIconImages(IconFactory.applicationLogos());
        this.setDefaultCloseOperation(0);
        this.proofListener = new MainProofListener();
        this.userInterface = new WindowUserInterfaceControl(this);
        this.mediator = this.getMainWindowMediator(this.userInterface);
        this.termLabelMenu = new TermLabelMenu(this);
        this.currentGoalView = new CurrentGoalView(this);
        this.emptySequent = new EmptySequent(this);
        this.sequentViewSearchBar = new SequentViewSearchBar(this.emptySequent);
        this.proofListView = new JScrollPane();
        this.autoModeAction = new AutoModeAction(this);
        this.mainFrame = new MainFrame(this, this.emptySequent);
        this.sourceViewFrame = new SourceViewFrame(this);
        this.proofList = new TaskTree(this.mediator);
        this.notificationManager = new NotificationManager(this.mediator, this);
        this.recentFileMenu = new RecentFileMenu(this.mediator);
        this.proofTreeView = new ProofTreeView(this.mediator);
        this.infoView = new InfoView(this, this.mediator);
        this.strategySelectionView = new StrategySelectionView(this, this.mediator);
        this.openGoalsView = new GoalList(this.mediator);
        this.layoutMain();
        SwingUtilities.updateComponentTreeUI(this);
        ToolTipManager.sharedInstance().setDismissDelay(30000);
        this.addWindowListener(this.exitMainAction.windowListener);
        MacroKeyBinding.registerMacroKeyBindings(this.mediator, this.currentGoalView, this.getRootPane());
        KeYGuiExtensionFacade.installKeyboardShortcuts(this.mediator, (JComponent)this.getContentPane(), KeYGuiExtension.KeyboardShortcuts.MAIN_WINDOW);
        KeYGuiExtensionFacade.getStartupExtensions().forEach(it -> it.init(this, this.mediator));
    }

    private boolean applyTaskbarIcon() {
        try {
            Image image = IconFactory.keyLogo();
            Class<?> appClass = Class.forName("java.awt.Taskbar");
            Method getTaskbar = appClass.getMethod("getTaskbar", new Class[0]);
            Method setIconImage = appClass.getMethod("setIconImage", Image.class);
            Object taskbar = getTaskbar.invoke(null, new Object[0]);
            setIconImage.invoke(taskbar, image);
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private boolean applyMacOsWorkaround() {
        try {
            Class<?> appClass = Class.forName("com.apple.eawt.Application");
            Class[] params = new Class[]{Image.class};
            Method getApplication = appClass.getMethod("getApplication", new Class[0]);
            Object application = getApplication.invoke(appClass, new Object[0]);
            Method setDockIconImage = appClass.getMethod("setDockIconImage", params);
            setDockIconImage.invoke(application, IconFactory.keyLogo());
            return true;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ignored) {
            return false;
        }
    }

    public static MainWindow getInstance() {
        return MainWindow.getInstance(true);
    }

    public static MainWindow getInstance(boolean ensureIsVisible) {
        if (GraphicsEnvironment.isHeadless()) {
            LOGGER.error("Error: KeY started in graphical mode, but no graphical environment present.");
            LOGGER.error("Please use the --auto option to start KeY in batch mode.");
            LOGGER.error("Use the --help option for more command line options.");
            System.exit(-1);
        }
        if (instance == null) {
            instance = new MainWindow();
            if (ensureIsVisible) {
                instance.setVisible(true);
            }
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public TermLabelVisibilityManager getVisibleTermLabels() {
        return this.termLabelMenu.getVisibleTermLabels();
    }

    private void applyGnomeWorkaround() {
        Toolkit xToolkit = Toolkit.getDefaultToolkit();
        try {
            Field awtAppClassNameField = xToolkit.getClass().getDeclaredField("awtAppClassName");
            awtAppClassNameField.setAccessible(true);
            awtAppClassNameField.set(xToolkit, "KeY");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setLaF() {
        try {
            if (ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().useSystemLaF()) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                UIManager.put("Slider.paintValue", Boolean.FALSE);
                UIManager.put("Menu.background", Color.GRAY);
                SwingUtilities.updateComponentTreeUI(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private KeYMediator getMainWindowMediator(AbstractMediatorUserInterfaceControl userInterface) {
        KeYMediator result = new KeYMediator(userInterface);
        result.addKeYSelectionListener(this.proofListener);
        result.getUI().getProofControl().addAutoModeListener(this.proofListener);
        result.addGUIListener(new MainGUIListener());
        return result;
    }

    public CControl getDockControl() {
        return this.dockControl;
    }

    public KeYMediator getMediator() {
        if (this.mediator == null) {
            throw new NullPointerException("KeYMediator is not set.");
        }
        return this.mediator;
    }

    private void layoutMain() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1000, 750));
        boolean stupidMode = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().tacletFilter();
        this.userInterface.getProofControl().setMinimizeInteraction(stupidMode);
        this.openFileAction = new OpenFileAction(this);
        this.openSingleJavaFileAction = new OpenSingleJavaFileAction(this);
        this.openExampleAction = new OpenExampleAction(this);
        this.openMostRecentFileAction = new OpenMostRecentFileAction(this);
        this.editMostRecentFileAction = new EditMostRecentFileAction(this);
        this.saveFileAction = new SaveFileAction(this);
        this.saveBundleAction = new SaveBundleAction(this);
        this.quickSaveAction = new QuickSaveAction(this);
        this.quickLoadAction = new QuickLoadAction(this);
        this.proofManagementAction = new ProofManagementAction(this);
        this.exitMainAction = new ExitMainAction(this);
        this.showActiveSettingsAction = new ShowActiveSettingsAction(this);
        this.loadUserDefinedTacletsAction = new LemmaGenerationAction.ProveAndAddTaclets(this);
        this.loadUserDefinedTacletsForProvingAction = new LemmaGenerationAction.ProveUserDefinedTaclets(this);
        this.loadKeYTaclets = new LemmaGenerationAction.ProveKeYTaclets(this);
        this.lemmaGenerationBatchModeAction = new LemmaGenerationBatchModeAction(this);
        this.unicodeToggleAction = new UnicodeToggleAction(this);
        this.goalSelectAboveAction = new GoalSelectAboveAction(this);
        this.goalSelectBelowAction = new GoalSelectBelowAction(this);
        Config.DEFAULT.setDefaultFonts();
        JMenuBar bar = this.createMenuBar();
        this.setJMenuBar(bar);
        this.controlToolBar = this.createProofControlToolBar();
        this.fileOpToolBar = this.createFileOpsToolBar();
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new FlowLayout(3));
        toolBarPanel.add(this.controlToolBar);
        toolBarPanel.add(this.fileOpToolBar);
        KeYGuiExtensionFacade.createToolbars(this).forEach(toolBarPanel::add);
        this.getContentPane().add((Component)toolBarPanel, "First");
        this.proofListView.setPreferredSize(new Dimension(350, 100));
        GuiUtilities.paintEmptyViewComponent(this.proofListView, "Proofs");
        this.mainFrame.add((Component)this.sequentViewSearchBar, "South");
        this.dockControl.putProperty(StackDockStation.TAB_PLACEMENT, (Object)TabPlacement.TOP_OF_DOCKABLE);
        this.getContentPane().add((Component)this.dockControl.getContentArea());
        this.dockProofListView = DockingHelper.createSingleDock("Loaded Proofs", this.proofListView, TaskTree.class.getName());
        this.dockSequent = DockingHelper.createSingleDock("Sequent", this.mainFrame);
        this.dockSourceView = DockingHelper.createSingleDock("Source", this.sourceViewFrame);
        Stream<TabPanel> extensionPanels = KeYGuiExtensionFacade.getAllPanels(this);
        Stream<TabPanel> defaultPanels = Stream.of(this.proofTreeView, this.infoView, this.strategySelectionView, this.openGoalsView);
        Stream.concat(defaultPanels, extensionPanels).map(DockingHelper::createSingleDock).forEach(it -> this.dockControl.addDockable(it));
        this.dockControl.addDockable(this.dockProofListView);
        this.dockControl.addDockable(this.dockSequent);
        this.dockControl.addDockable(this.dockSourceView);
        this.dockProofListView.setVisible(true);
        this.dockSequent.setVisible(true);
        this.dockSourceView.setVisible(true);
        DockingHelper.restoreFactoryDefault(this);
        this.statusLine = new MainStatusLine("<html><p style=\"font-family: lucida;font-size: 12pt;font-weight: bold\">\u00a9 Copyright 2001\u20132021 Karlsruhe Institute of Technology, Chalmers University of Technology, and Technische Universit\u00e4t Darmstadt<p style=\"font-family: lucida;font-size: 12pt;font-weight: bold\">KeY is free software and comes with ABSOLUTELY NO WARRANTY. See About | License.", this.getFont());
        this.getContentPane().add((Component)this.statusLine, "South");
        this.setName("mainWindow");
        this.setSize(1000, 600);
        this.loadPreferences(this);
    }

    private JToolBar createFileOpsToolBar() {
        JToolBar fileOperations = new JToolBar("File Operations");
        fileOperations.add(this.openFileAction);
        fileOperations.add(this.openMostRecentFileAction);
        fileOperations.add(this.editMostRecentFileAction);
        fileOperations.add(this.saveFileAction);
        fileOperations.add(this.saveBundleAction);
        fileOperations.addSeparator();
        fileOperations.add(this.proofManagementAction);
        return fileOperations;
    }

    private JToolBar createProofControlToolBar() {
        JToolBar toolBar = new JToolBar("Proof Control");
        toolBar.setFloatable(true);
        toolBar.setRollover(true);
        toolBar.add(this.createWiderAutoModeButton());
        toolBar.addSeparator();
        toolBar.addSeparator();
        toolBar.addSeparator();
        DropdownSelectionButton comp = this.createSMTComponent();
        toolBar.add(comp.getActionComponent());
        toolBar.add(comp.getSelectionComponent());
        toolBar.addSeparator();
        toolBar.add(new GoalBackAction(this, false));
        toolBar.add(new PruneProofAction(this));
        toolBar.addSeparator();
        return toolBar;
    }

    private DropdownSelectionButton createSMTComponent() {
        this.smtComponent = new DropdownSelectionButton(16);
        this.noSolverSelected = new DropdownSelectionButton.EmptyAction(true);
        this.noSolverSelected.setText("SMT");
        this.noSolverSelected.setToolTip("Choose at least one SMT solver to run");
        String noneAvailableText = "No solver available";
        String noneAvailableTip = "<html>No SMT solver is applicable for KeY.<br><br>If a solver is installed on your system,<br>please configure the KeY-System accordingly:" + System.lineSeparator() + "<br>Options | SMT Solvers</html>";
        this.smtComponent.setEmptyItem(noneAvailableText, noneAvailableTip);
        this.smtComponent.setPrefix("Run ");
        this.smtComponent.addListener(e -> {
            DropdownSelectionButton but = (DropdownSelectionButton)e.getSource();
            if (but.getAction() instanceof SMTInvokeAction) {
                SMTInvokeAction action = (SMTInvokeAction)but.getAction();
                ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().setActiveSolverUnion(action.getSolverUnion());
            }
        });
        this.smtComponent.addListener(c -> {
            if (this.smtComponent.getAction() == this.noSolverSelected) {
                this.noSolverSelected.putValue("Name", this.noSolverSelected.toString());
                this.noSolverSelected.putValue("ShortDescription", this.noSolverSelected.getToolTip());
                boolean selectionEnabled = this.smtComponent.getSelectionComponent().isEnabled();
                this.smtComponent.setEnabled(false);
                this.smtComponent.getSelectionComponent().setEnabled(selectionEnabled);
            }
        });
        this.selectAll = new JCheckBoxMenuItem("Select All");
        this.selectAll.setFocusPainted(false);
        this.selectAll.setEnabled(true);
        this.separator = new JSeparator();
        this.updateSMTSelectMenu();
        this.mediator.addKeYSelectionListener(new DPEnableControl());
        return this.smtComponent;
    }

    private JComponent createWiderAutoModeButton() {
        JButton b = new JButton(this.autoModeAction);
        b.putClientProperty("hideActionText", Boolean.TRUE);
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        p.add(b);
        return p;
    }

    protected MainStatusLine getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(String status) {
        ThreadUtilities.invokeOnEventQueue(() -> this.statusLine.setStatusText(status));
    }

    private void setStandardStatusLineImmediately() {
        this.statusLine.reset();
    }

    public void setStandardStatusLine() {
        ThreadUtilities.invokeOnEventQueue(new Runnable(){

            @Override
            public void run() {
                MainWindow.this.setStandardStatusLineImmediately();
            }
        });
    }

    private void setStatusLineImmediately(String str, int max) {
        this.statusLine.setStatusText(str);
        if (max > 0) {
            this.getStatusLine().setProgressBarMaximum(max);
            this.statusLine.setProgressPanelVisible(true);
        } else {
            this.statusLine.setProgressPanelVisible(false);
        }
        this.statusLine.validate();
        this.statusLine.paintImmediately(0, 0, this.statusLine.getWidth(), this.statusLine.getHeight());
    }

    public void setStatusLine(String str, int max) {
        ThreadUtilities.invokeOnEventQueue(() -> this.setStatusLineImmediately(str, max));
    }

    @Deprecated
    public void selectFirstTab() {
    }

    public void freezeExceptAutoModeButton() {
        if (!this.frozen) {
            this.frozen = true;
            BlockingGlassPane glassPane = new BlockingGlassPane(this.getContentPane());
            this.setGlassPane(glassPane);
            ((Component)glassPane).setVisible(true);
        }
    }

    public void unfreezeExceptAutoModeButton() {
        if (this.frozen) {
            this.getGlassPane().setVisible(false);
            this.frozen = false;
        }
    }

    public void makePrettyView() {
        if (this.getMediator().ensureProofLoaded()) {
            this.getMediator().getNotationInfo().refresh(this.mediator.getServices());
            this.getMediator().getSelectedProof().fireProofGoalsChanged();
        }
    }

    private void addToProofList(ProofAggregate plist) {
        this.proofList.addProof(plist);
        this.proofList.setSize(this.proofList.getPreferredSize());
        this.proofListView.setViewportView(this.proofList);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createViewMenu());
        menuBar.add(this.createProofMenu());
        menuBar.add(this.createOptionsMenu());
        KeYGuiExtensionFacade.addExtensionsToMainMenu(this, menuBar);
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(this.createHelpMenu());
        return menuBar;
    }

    private JMenu createFileMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(this.openExampleAction);
        fileMenu.add(this.openFileAction);
        fileMenu.add(this.openMostRecentFileAction);
        fileMenu.add(this.editMostRecentFileAction);
        fileMenu.add(this.saveFileAction);
        fileMenu.add(this.saveBundleAction);
        fileMenu.add(this.quickSaveAction);
        fileMenu.add(this.quickLoadAction);
        fileMenu.addSeparator();
        fileMenu.add(this.proofManagementAction);
        fileMenu.add(this.loadUserDefinedTacletsAction);
        JMenu submenu = new JMenu("Prove");
        fileMenu.add(submenu);
        submenu.add(this.loadUserDefinedTacletsForProvingAction);
        submenu.add(this.loadKeYTaclets);
        submenu.add(this.lemmaGenerationBatchModeAction);
        if (Main.isExperimentalMode()) {
            RunAllProofsAction runAllProofsAction = new RunAllProofsAction(this);
            submenu.add(runAllProofsAction);
        }
        fileMenu.addSeparator();
        fileMenu.add(this.recentFileMenu.getMenu());
        fileMenu.addSeparator();
        fileMenu.add(this.exitMainAction);
        return fileMenu;
    }

    private JMenu createViewMenu() {
        JMenu view = new JMenu("View");
        view.setMnemonic(86);
        JCheckBoxMenuItem laf = new JCheckBoxMenuItem("Use system look and feel (experimental)");
        laf.setToolTipText("If checked KeY tries to appear in the look and feel of your window manager, if not in the default Java LaF (aka Metal).");
        final ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        laf.setSelected(vs.useSystemLaF());
        laf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                vs.setUseSystemLaF(((JCheckBoxMenuItem)e.getSource()).isSelected());
                LOGGER.warn("Info: Look and feel changed for next start of KeY.");
            }
        });
        view.add(new JCheckBoxMenuItem(new PrettyPrintToggleAction(this)));
        view.add(new JCheckBoxMenuItem(this.unicodeToggleAction));
        view.add(new JCheckBoxMenuItem(new SyntaxHighlightingToggleAction(this)));
        view.add(this.termLabelMenu);
        view.add(new JCheckBoxMenuItem(this.hidePackagePrefixToggleAction));
        view.add(new JCheckBoxMenuItem(this.toggleSequentViewTooltipAction));
        view.add(new JCheckBoxMenuItem(this.toggleSourceViewTooltipAction));
        view.addSeparator();
        JMenu fontSize = new JMenu("Font Size");
        fontSize.add(new DecreaseFontSizeAction(this));
        fontSize.add(new IncreaseFontSizeAction(this));
        view.add(fontSize);
        view.add(new ToolTipOptionsAction(this));
        view.add(new ProofDiffFrame.Action(this));
        view.addSeparator();
        view.add(this.createSelectionMenu());
        return view;
    }

    private JMenu createSelectionMenu() {
        JMenu goalSelection = new JMenu("Select Goal");
        goalSelection.add(this.goalSelectAboveAction);
        goalSelection.add(this.goalSelectBelowAction);
        return goalSelection;
    }

    private JMenu createProofMenu() {
        JMenu proof = new JMenu("Proof");
        proof.setMnemonic(80);
        proof.add(this.autoModeAction);
        final GoalBackAction goalBack = new GoalBackAction(this, true);
        proof.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                goalBack.updateName();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        proof.add(goalBack);
        proof.add(new PruneProofAction(this));
        proof.add(new AbandonTaskAction(this));
        proof.addSeparator();
        proof.add(new SearchInProofTreeAction(this));
        proof.add(new SearchInSequentAction(this));
        proof.add(new SearchNextAction(this));
        proof.add(new SearchPreviousAction(this));
        JMenu searchModeMenu = new JMenu("Search Mode");
        for (SequentViewSearchBar.SearchMode mode : SequentViewSearchBar.SearchMode.values()) {
            searchModeMenu.add(new SearchModeChangeAction(this, mode));
        }
        proof.add(searchModeMenu);
        proof.addSeparator();
        proof.add(new ShowUsedContractsAction(this));
        proof.add(new ShowActiveTactletOptionsAction(this));
        proof.add(this.showActiveSettingsAction);
        proof.add(new ShowProofStatistics(this));
        proof.add(new ShowKnownTypesAction(this));
        return proof;
    }

    private JMenu createOptionsMenu() {
        JMenu options = new JMenu("Options");
        options.setMnemonic(79);
        options.add(SettingsManager.getInstance().getActionShowSettings(this));
        options.add(new TacletOptionsAction(this));
        options.add(new SMTOptionsAction(this));
        options.addSeparator();
        options.add(new JCheckBoxMenuItem(new ToggleConfirmExitAction(this)));
        options.add(new JCheckBoxMenuItem(new AutoSave(this)));
        options.add(new MinimizeInteraction(this));
        options.add(new JCheckBoxMenuItem(new RightMouseClickToggleAction(this)));
        options.add(new JCheckBoxMenuItem(new EnsureSourceConsistencyToggleAction(this)));
        return options;
    }

    private JMenu createHelpMenu() {
        JMenu help = new JMenu("About");
        help.setMnemonic(65);
        help.add(new AboutAction(this));
        help.add(new KeYProjectHomepageAction(this));
        help.add(new MenuSendFeedackAction(this));
        help.add(new LicenseAction(this));
        return help;
    }

    public void updateSMTSelectMenu() {
        Collection solverUnions = ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings().getUsableSolverUnions(Main.isExperimentalMode());
        if (solverUnions == null || solverUnions.isEmpty()) {
            this.updateDPSelectionMenu();
        } else {
            this.updateDPSelectionMenu(solverUnions);
        }
    }

    private void updateDPSelectionMenu() {
        this.smtComponent.setItems(null, actions -> null, 0);
    }

    private void updateDPSelectionMenu(Collection<SolverTypeCollection> unions) {
        int size = unions.size();
        Action[] actions = new SMTInvokeAction[size];
        int i = 0;
        for (SolverTypeCollection union : unions) {
            SMTInvokeAction action = new SMTInvokeAction(union, this);
            actions[i] = action;
            ++i;
        }
        this.smtComponent.setItems(actions, this.collapseChoice, actions.length);
        if (actions.length > 1) {
            if (this.selectAllListener != null) {
                this.smtComponent.removeListener(this.selectAllListener);
            }
            this.smtComponent.addComponent(this.separator);
            this.smtComponent.addComponent(this.selectAll);
            this.selectAll.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MainWindow.this.selectAll.isSelected()) {
                        MainWindow.this.smtComponent.selectMaxNumber();
                    } else {
                        MainWindow.this.smtComponent.deselectAll();
                    }
                }
            });
            this.selectAll.setText("Select All");
            this.selectAll.setToolTipText("(De)select all menu items by (un)checking this");
            this.selectAll.putClientProperty("CheckBoxMenuItem.doNotCloseOnMouseClick", Boolean.TRUE);
            this.selectAllListener = new ChangeListener((SMTInvokeAction[])actions){
                final /* synthetic */ SMTInvokeAction[] val$actions;
                {
                    this.val$actions = sMTInvokeActionArray;
                }

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (MainWindow.this.smtComponent.getSelectedItems().length == this.val$actions.length && !MainWindow.this.selectAll.isSelected()) {
                        MainWindow.this.selectAll.setSelected(true);
                    } else if (MainWindow.this.smtComponent.getSelectedItems().length == 0 && MainWindow.this.selectAll.isSelected()) {
                        MainWindow.this.selectAll.setSelected(false);
                    }
                }
            };
            this.smtComponent.addListener(this.selectAllListener);
        } else {
            this.smtComponent.removeComponent(this.selectAll);
            this.smtComponent.removeComponent(this.separator);
        }
    }

    private JMenuItem setupSpeclangMenu() {
        JMenu result = new JMenu("Specification Parser");
        ButtonGroup group = new ButtonGroup();
        GeneralSettings gs = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings();
        JRadioButtonMenuItem jmlButton = new JRadioButtonMenuItem("Source File Comments Are JML", gs.useJML());
        result.add(jmlButton);
        group.add(jmlButton);
        jmlButton.setIcon(IconFactory.jmlLogo(15));
        jmlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralSettings gs = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings();
                gs.setUseJML(true);
            }
        });
        JRadioButtonMenuItem noneButton = new JRadioButtonMenuItem("Source File Comments Are Ignored", !gs.useJML());
        result.add(noneButton);
        group.add(noneButton);
        noneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralSettings gs = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings();
                gs.setUseJML(false);
            }
        });
        return result;
    }

    public ProofTreeView getProofTreeView() {
        return this.proofTreeView;
    }

    public CurrentGoalView getGoalView() {
        return this.currentGoalView;
    }

    public void addProblem(final ProofAggregate plist) {
        Runnable guiUpdater = new Runnable(){

            @Override
            public void run() {
                MainWindow.this.disableCurrentGoalView = true;
                MainWindow.this.addToProofList(plist);
                MainWindow.this.setUpNewProof(plist.getFirstProof());
                MainWindow.this.disableCurrentGoalView = false;
                MainWindow.this.updateSequentView();
            }
        };
        ThreadUtilities.invokeOnEventQueue(guiUpdater);
    }

    private Proof setUpNewProof(Proof proof) {
        this.getMediator().setProof(proof);
        return proof;
    }

    private synchronized void updateSequentView() {
        SequentView newSequentView;
        if (this.disableCurrentGoalView) {
            return;
        }
        boolean isPrintRunImmediately = SwingUtilities.isEventDispatchThread();
        if (this.getMediator().getSelectedProof() == null) {
            newSequentView = this.emptySequent;
        } else {
            Goal goal = this.getMediator().getSelectedGoal();
            if (goal != null && !goal.node().isClosed()) {
                this.currentGoalView.setPrinter(goal);
                if (!isPrintRunImmediately) {
                    this.currentGoalView.printSequent();
                }
                newSequentView = this.currentGoalView;
            } else {
                newSequentView = new InnerNodeView(this.getMediator().getSelectedNode(), this);
                if (!isPrintRunImmediately) {
                    newSequentView.printSequent();
                }
            }
        }
        Runnable sequentUpdater = new Runnable(){

            @Override
            public void run() {
                MainWindow.this.mainFrame.setContent(newSequentView);
                MainWindow.this.sequentViewSearchBar.setSequentView(newSequentView);
            }
        };
        if (isPrintRunImmediately) {
            try {
                sequentUpdater.run();
            }
            catch (RuntimeException ex) {
                ex.printStackTrace();
            }
        } else {
            SwingUtilities.invokeLater(sequentUpdater);
        }
    }

    void displayResults(String message) {
        this.setStatusLine(message);
    }

    public void notify(NotificationEvent event) {
        if (this.notificationManager != null) {
            this.notificationManager.handleNotificationEvent(event);
        }
    }

    public void popupInformationMessage(Object message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public void popupWarning(Object message, String title) {
        JOptionPane.showMessageDialog(this, message, title, 2);
    }

    public TaskTree getProofList() {
        return this.proofList;
    }

    public RecentFileMenu getRecentFiles() {
        return this.recentFileMenu;
    }

    public WindowUserInterfaceControl getUserInterface() {
        return this.userInterface;
    }

    public Action getOpenMostRecentFileAction() {
        return this.openMostRecentFileAction;
    }

    public Action getUnicodeToggleAction() {
        return this.unicodeToggleAction;
    }

    public Action getHidePackagePrefixToggleAction() {
        return this.hidePackagePrefixToggleAction;
    }

    public void savePreferences(Component component) {
        this.prefSaver.save(component);
    }

    public final void loadPreferences(Component component) {
        this.prefSaver.load(component);
    }

    public final void syncPreferences() {
        try {
            this.prefSaver.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }

    public ExitMainAction getExitMainAction() {
        return this.exitMainAction;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void addRecentFile(@Nonnull String absolutePath) {
        this.recentFileMenu.addRecentFile(absolutePath);
    }

    public void openExamples() {
        this.openExampleAction.actionPerformed(null);
    }

    public void loadProblem(File file) {
        this.getUserInterface().loadProblem(file);
    }

    public void loadProblem(File file, List<File> classPath, File bootClassPath, List<File> includes) {
        this.getUserInterface().loadProblem(file, classPath, bootClassPath, includes);
    }

    public void loadProofFromBundle(File proofBundle, File proofPath) {
        this.getUserInterface().loadProofFromBundle(proofBundle, proofPath);
    }

    public List<Name> getSortedTermLabelNames() {
        return TermLabelVisibilityManager.getSortedTermLabelNames((Profile)this.getMediator().getProfile());
    }

    public JToolBar getControlToolBar() {
        return this.controlToolBar;
    }

    public void setShowTacletInfo(boolean show) {
        this.proofTreeView.tacletInfoToggle.setSelected(show);
    }

    public AutoModeAction getAutoModeAction() {
        return this.autoModeAction;
    }

    public CDockable getDockProofListView() {
        return this.dockProofListView;
    }

    public SingleCDockable getDockSourceView() {
        return this.dockSourceView;
    }

    public SingleCDockable getDockSequent() {
        return this.dockSequent;
    }

    public SourceViewFrame getSourceViewFrame() {
        return this.sourceViewFrame;
    }

    private final class DPEnableControl
    implements KeYSelectionListener {
        private DPEnableControl() {
        }

        private void enable(boolean b) {
            MainWindow.this.smtComponent.setEnabled(b);
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            if (e.getSource().getSelectedProof() != null) {
                this.enable(!e.getSource().getSelectedProof().closed());
            } else {
                this.enable(false);
            }
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
            this.selectedProofChanged(e);
        }
    }

    class MainProofListener
    implements AutoModeListener,
    KeYSelectionListener,
    SettingsListener {
        Proof proof = null;

        MainProofListener() {
        }

        @Override
        public synchronized void selectedNodeChanged(KeYSelectionEvent e) {
            if (MainWindow.this.getMediator().isInAutoMode()) {
                return;
            }
            MainWindow.this.updateSequentView();
        }

        @Override
        public synchronized void selectedProofChanged(KeYSelectionEvent e) {
            LOGGER.debug("Main: initialize with new proof");
            if (this.proof != null && !this.proof.isDisposed()) {
                this.proof.getSettings().getStrategySettings().removeSettingsListener((SettingsListener)this);
            }
            this.proof = e.getSource().getSelectedProof();
            if (this.proof != null) {
                this.proof.getSettings().getStrategySettings().addSettingsListener((SettingsListener)this);
            }
            MainWindow.this.disableCurrentGoalView = false;
            MainWindow.this.updateSequentView();
            MainWindow.this.makePrettyView();
        }

        public synchronized void autoModeStarted(ProofEvent e) {
            LOGGER.info("Automode started");
            MainWindow.this.disableCurrentGoalView = true;
            MainWindow.this.getMediator().removeKeYSelectionListener(MainWindow.this.proofListener);
            MainWindow.this.freezeExceptAutoModeButton();
        }

        public synchronized void autoModeStopped(ProofEvent e) {
            if (Debug.ENABLE_DEBUG) {
                LOGGER.info("Automode stopped");
            }
            MainWindow.this.unfreezeExceptAutoModeButton();
            MainWindow.this.disableCurrentGoalView = false;
            MainWindow.this.updateSequentView();
            MainWindow.this.getMediator().addKeYSelectionListenerChecked(MainWindow.this.proofListener);
        }

        public synchronized void settingsChanged(EventObject e) {
            if (this.proof.getSettings().getStrategySettings() == e.getSource()) {
                // empty if block
            }
        }
    }

    class MainGUIListener
    implements GUIListener {
        private Set<Component> doNotReenable;

        MainGUIListener() {
        }

        private void enableMenuBar(JMenuBar m, boolean b) {
            for (int i = 0; i < m.getMenuCount(); ++i) {
                JMenu menu = m.getMenu(i);
                if (menu == null) continue;
                menu.setEnabled(b);
            }
        }

        private void setToolBarDisabled() {
            int i;
            assert (EventQueue.isDispatchThread()) : "toolbar disabled from wrong thread";
            this.doNotReenable = new LinkedHashSet<Component>();
            Component[] cs = MainWindow.this.controlToolBar.getComponents();
            for (i = 0; i < cs.length; ++i) {
                if (!cs[i].isEnabled()) {
                    this.doNotReenable.add(cs[i]);
                }
                cs[i].setEnabled(false);
            }
            cs = MainWindow.this.fileOpToolBar.getComponents();
            for (i = 0; i < cs.length; ++i) {
                if (!cs[i].isEnabled()) {
                    this.doNotReenable.add(cs[i]);
                }
                cs[i].setEnabled(false);
            }
        }

        private void setToolBarEnabled() {
            int i;
            assert (EventQueue.isDispatchThread()) : "toolbar enabled from wrong thread";
            if (this.doNotReenable == null) {
                LOGGER.debug("toolbar enabled w/o prior disable");
                return;
            }
            Component[] cs = MainWindow.this.controlToolBar.getComponents();
            for (i = 0; i < cs.length; ++i) {
                if (this.doNotReenable.contains(cs[i])) continue;
                cs[i].setEnabled(true);
            }
            cs = MainWindow.this.fileOpToolBar.getComponents();
            for (i = 0; i < cs.length; ++i) {
                if (this.doNotReenable.contains(cs[i])) continue;
                cs[i].setEnabled(true);
            }
            this.doNotReenable = null;
        }

        @Override
        public void modalDialogOpened(EventObject e) {
            if (e.getSource() instanceof ApplyTacletDialog) {
                this.enableMenuBar(MainWindow.this.getJMenuBar(), false);
                MainWindow.this.mainFrame.setEnabled(false);
                this.setToolBarDisabled();
            } else {
                MainWindow.this.setEnabled(false);
            }
        }

        @Override
        public void modalDialogClosed(EventObject e) {
            if (e.getSource() instanceof ApplyTacletDialog) {
                this.enableMenuBar(MainWindow.this.getJMenuBar(), true);
                MainWindow.this.mainFrame.setEnabled(true);
                this.setToolBarEnabled();
            } else {
                MainWindow.this.setEnabled(true);
            }
        }

        @Override
        public void shutDown(EventObject e) {
            MainWindow.this.notify(new ExitKeYEvent());
            MainWindow.this.setVisible(false);
        }
    }

    private static class GlassPaneListener
    extends MouseInputAdapter {
        Component currentComponent = null;
        Component glassPane;
        Container contentPane;

        public GlassPaneListener(Component glassPane, Container contentPane) {
            this.glassPane = glassPane;
            this.contentPane = contentPane;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.redispatchMouseEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.redispatchMouseEvent(e);
            this.currentComponent = null;
        }

        private void redispatchMouseEvent(MouseEvent e) {
            if (this.currentComponent != null) {
                this.dispatchForCurrentComponent(e);
            } else {
                int eventID = e.getID();
                Point glassPanePoint = e.getPoint();
                Point containerPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.contentPane);
                Component component = SwingUtilities.getDeepestComponentAt(this.contentPane, containerPoint.x, containerPoint.y);
                if (eventID == 501 && this.isLiveComponent(component)) {
                    this.currentComponent = component;
                    this.dispatchForCurrentComponent(e);
                }
            }
        }

        private boolean isLiveComponent(Component c) {
            while (c != null) {
                if (c instanceof JComponent && MainWindow.AUTO_MODE_TEXT.equals(((JComponent)c).getToolTipText())) {
                    return true;
                }
                c = c.getParent();
            }
            return false;
        }

        private void dispatchForCurrentComponent(MouseEvent e) {
            Point glassPanePoint = e.getPoint();
            Point componentPoint = SwingUtilities.convertPoint(this.glassPane, glassPanePoint, this.currentComponent);
            this.currentComponent.dispatchEvent(new MouseEvent(this.currentComponent, e.getID(), e.getWhen(), e.getModifiers(), componentPoint.x, componentPoint.y, e.getClickCount(), e.isPopupTrigger()));
        }
    }

    private static class BlockingGlassPane
    extends JComponent {
        private static final long serialVersionUID = 1218022319090988424L;
        private final GlassPaneListener listener;

        public BlockingGlassPane(Container contentPane) {
            this.setCursor(new Cursor(3));
            this.listener = new GlassPaneListener(this, contentPane);
            this.addMouseListener(this.listener);
            this.addMouseMotionListener(this.listener);
            this.addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent e) {
                    e.consume();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    e.consume();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    e.consume();
                }
            });
        }
    }
}

