/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MaxRuleAppSlider
extends JSlider {
    private static final long serialVersionUID = 5810499328583797609L;
    private static final int MAX_RULE_APPS_LOG10 = 6;
    private static LinkedList<MaxRuleAppSlider> allInstances = new LinkedList();
    private final String text;
    private KeYMediator mediator;

    public MaxRuleAppSlider(KeYMediator mediator, String text) {
        super(0, 0, 54, 0);
        this.text = text;
        this.mediator = mediator;
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        for (int n = 0; n <= 6; ++n) {
            int val = (int)Math.pow(10.0, n);
            String sval = "" + (Serializable)(val >= 10000 ? (val >= 1000000 ? val / 1000000 + "M" : val / 1000 + "k") : Integer.valueOf(val));
            JLabel l = new JLabel(sval);
            l.setFont(l.getFont().deriveFont(9.0f));
            labelTable.put(n * 9, l);
        }
        this.setLabelTable(labelTable);
        this.setPaintLabels(true);
        this.setMajorTickSpacing(9);
        this.setMinorTickSpacing(1);
        this.setPaintTicks(true);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int val = MaxRuleAppSlider.this.getPos();
                MaxRuleAppSlider.this.mediator.setMaxAutomaticSteps(val);
                MaxRuleAppSlider.this.setTitle(val);
                MaxRuleAppSlider.this.updateAllSliders();
            }
        });
        this.setTitle(0);
        allInstances.add(this);
    }

    public int getPos() {
        int n = this.getValue();
        int major = n / 9;
        int minor = n % 9;
        int val = (minor + 1) * (int)Math.pow(10.0, major);
        return val;
    }

    public void setPos(int maxRuleApps) {
        if (maxRuleApps > 0) {
            int major = (int)(Math.log(maxRuleApps) / Math.log(10.0));
            int minor = maxRuleApps / (int)Math.pow(10.0, major) - 1;
            int initPos = Math.max(0, Math.min(54, major * 9 + minor));
            this.setValue(initPos);
        }
    }

    private void setTitle(int maxRuleApps) {
        this.setBorder(BorderFactory.createTitledBorder(this.text + ": " + maxRuleApps));
    }

    public void refresh() {
        if (this.mediator != null) {
            int steps = this.mediator.getMaxAutomaticSteps();
            this.setPos(steps);
            this.setTitle(steps);
        }
    }

    private void updateAllSliders() {
        for (MaxRuleAppSlider allInstance : allInstances) {
            allInstance.refresh();
        }
    }

    public void setMediator(KeYMediator mediator) {
        this.mediator = mediator;
    }
}

