/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.NodeInfoVisualizerListener;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JComponent;

public abstract class NodeInfoVisualizer
extends JComponent
implements Comparable<NodeInfoVisualizer> {
    private static final long serialVersionUID = 4205276651552216532L;
    private static Map<Name, Map<Integer, SortedSet<NodeInfoVisualizer>>> instances = new HashMap<Name, Map<Integer, SortedSet<NodeInfoVisualizer>>>();
    private static Set<NodeInfoVisualizerListener> listeners = new HashSet<NodeInfoVisualizerListener>();
    private Node node;
    private String longName;
    private String shortName;

    public NodeInfoVisualizer(Node node, String longName, String shortName) {
        this.node = node;
        this.longName = longName;
        this.shortName = shortName;
        NodeInfoVisualizer.register(this);
    }

    public static boolean hasInstances(Node node) {
        return !NodeInfoVisualizer.getInstances(node).isEmpty();
    }

    public static SortedSet<NodeInfoVisualizer> getInstances(Node node) {
        return Collections.unmodifiableSortedSet(instances.getOrDefault(node.proof().name(), Collections.emptyMap()).getOrDefault(node.serialNr(), Collections.emptySortedSet()));
    }

    public static void addListener(NodeInfoVisualizerListener listener) {
        listeners.add(listener);
    }

    public static void removeListener(NodeInfoVisualizerListener listener) {
        listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void unregister(NodeInfoVisualizer vis) {
        Node node = vis.getNode();
        if (instances.get(node.proof().name()).get(node.serialNr()).remove(vis)) {
            Set<NodeInfoVisualizerListener> set = listeners;
            synchronized (set) {
                for (NodeInfoVisualizerListener listener : listeners) {
                    listener.visualizerUnregistered(vis);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void register(NodeInfoVisualizer vis) {
        Node node = vis.getNode();
        int nodeNr = node.serialNr();
        Proof proof = node.proof();
        Name proofName = proof.name();
        instances.putIfAbsent(proofName, new TreeMap());
        Map<Integer, SortedSet<NodeInfoVisualizer>> map = instances.get(proofName);
        map.putIfAbsent(nodeNr, new TreeSet());
        map.get(nodeNr).add(vis);
        Set<NodeInfoVisualizerListener> set = listeners;
        synchronized (set) {
            for (NodeInfoVisualizerListener listener : listeners) {
                listener.visualizerRegistered(vis);
            }
        }
    }

    public void dispose() {
        NodeInfoVisualizer.unregister(this);
        this.node = null;
    }

    @Override
    public int compareTo(NodeInfoVisualizer other) {
        return this.longName.compareTo(other.longName);
    }

    public final Node getNode() {
        return this.node;
    }

    @Override
    public final String toString() {
        return this.longName;
    }

    @Override
    public String getName() {
        return this.shortName;
    }

    public final String getLongName() {
        return this.longName;
    }

    public final String getShortName() {
        return this.shortName;
    }
}

