/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.actions.ProofScriptFromFileAction;
import de.uka.ilkd.key.gui.actions.ProofScriptInputAction;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeManager;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.proof.Node;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.key_project.util.reflection.ClassLoaderUtil;

public class ProofMacroMenu
extends JMenu {
    private static final long serialVersionUID = -5946657022043894399L;
    public static final Iterable<ProofMacro> REGISTERED_MACROS = ClassLoaderUtil.loadServices(ProofMacro.class);
    private final int numberOfMacros;

    public ProofMacroMenu(KeYMediator mediator, PosInOccurrence posInOcc) {
        super("Strategy Macros");
        HashMap<String, ProofMacroMenu> submenus = new HashMap<String, ProofMacroMenu>();
        int count = 0;
        Node node = mediator.getSelectedNode();
        for (ProofMacro macro : REGISTERED_MACROS) {
            boolean applicable = node != null && macro.canApplyTo(node, posInOcc);
            if (!applicable) continue;
            JMenuItem menuItem = this.createMenuItem(macro, mediator, posInOcc);
            String category = macro.getCategory();
            JMenu submenu = this;
            if (category != null && (submenu = (JMenu)submenus.get(category)) == null) {
                submenu = new JMenu(category);
                submenus.put(category, (ProofMacroMenu)submenu);
                this.add(submenu);
            }
            submenu.add(menuItem);
            ++count;
        }
        if (Main.isExperimentalMode()) {
            this.add(new JMenuItem(new ProofScriptFromFileAction(mediator)));
            this.add(new JMenuItem(new ProofScriptInputAction(mediator)));
        }
        mediator.enableWhenProofLoaded(this);
        this.numberOfMacros = count;
    }

    public ProofMacroMenu(KeYMediator mediator) {
        this(mediator, null);
    }

    private JMenuItem createMenuItem(final ProofMacro macro, final KeYMediator mediator, final PosInOccurrence posInOcc) {
        JMenuItem menuItem = new JMenuItem(macro.getName());
        menuItem.setToolTipText(macro.getDescription());
        KeyStroke macroKey = KeyStrokeManager.get(macro);
        if (macroKey != null && posInOcc == null) {
            menuItem.setAccelerator(macroKey);
        }
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (mediator.isInAutoMode()) {
                    return;
                }
                mediator.getUI().getProofControl().runMacro(mediator.getSelectedNode(), macro, posInOcc);
            }
        });
        return menuItem;
    }

    public boolean isEmpty() {
        return this.numberOfMacros == 0;
    }
}

