/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.InteractionListener;
import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.core.InterruptListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.ProofMacroFinishedInfo;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.prover.ProverTaskListener;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.DefaultTaskStartedInfo;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofMacroWorker
extends SwingWorker<ProofMacroFinishedInfo, Void>
implements InterruptListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProofMacroWorker.class);
    private static final boolean SELECT_GOAL_AFTER_MACRO = Boolean.parseBoolean(System.getProperty("key.macro.selectGoalAfter", "true"));
    private final Node node;
    private final ProofMacro macro;
    private final KeYMediator mediator;
    private final PosInOccurrence posInOcc;
    private ProofMacroFinishedInfo info;
    private Exception exception;
    private List<InteractionListener> interactionListeners = new ArrayList<InteractionListener>();

    public ProofMacroWorker(Node node, ProofMacro macro, KeYMediator mediator, PosInOccurrence posInOcc) {
        assert (macro != null);
        assert (mediator != null);
        this.node = node;
        this.macro = macro;
        this.mediator = mediator;
        this.posInOcc = posInOcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ProofMacroFinishedInfo doInBackground() {
        AbstractMediatorUserInterfaceControl ptl = this.mediator.getUI();
        Proof selectedProof = this.node.proof();
        this.info = ProofMacroFinishedInfo.getDefaultInfo((ProofMacro)this.macro, (Proof)selectedProof);
        ptl.taskStarted((TaskStartedInfo)new DefaultTaskStartedInfo(TaskStartedInfo.TaskKind.Macro, this.macro.getName(), 0));
        try {
            ProofMacro proofMacro = this.macro;
            synchronized (proofMacro) {
                this.info = this.macro.applyTo((UserInterfaceControl)this.mediator.getUI(), this.node, this.posInOcc, (ProverTaskListener)ptl);
            }
        }
        catch (InterruptedException exception) {
            LOGGER.debug("Proof macro has been interrupted:", (Throwable)exception);
            this.info = new ProofMacroFinishedInfo(this.macro, selectedProof, true);
            this.exception = exception;
        }
        catch (Exception exception) {
            this.exception = exception;
        }
        return this.info;
    }

    @Override
    public void interruptionPerformed() {
        this.cancel(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        ProofMacro proofMacro = this.macro;
        synchronized (proofMacro) {
            this.mediator.removeInterruptedListener(this);
            if (!this.isCancelled() && this.exception != null) {
                IssueDialog.showExceptionDialog(MainWindow.getInstance(), this.exception);
            }
            this.mediator.getUI().taskFinished((TaskFinishedInfo)this.info);
            if (SELECT_GOAL_AFTER_MACRO) {
                this.selectOpenGoalBelow();
            }
            this.mediator.setInteractive(true);
            this.mediator.startInterface(true);
            this.emitProofMacroFinished(this.node, this.macro, this.posInOcc, this.info);
        }
    }

    protected void emitProofMacroFinished(Node node, ProofMacro macro, PosInOccurrence posInOcc, ProofMacroFinishedInfo info) {
        this.interactionListeners.forEach(l -> l.runMacro(node, macro, posInOcc, info));
    }

    public void addInteractionListener(InteractionListener listener) {
        this.interactionListeners.add(listener);
    }

    public void removeInteractionListener(InteractionListener listener) {
        this.interactionListeners.remove(listener);
    }

    private void selectOpenGoalBelow() {
        Node selectedNode = this.mediator.getSelectedNode();
        for (Goal g : selectedNode.proof().openEnabledGoals()) {
            for (Node n = g.node(); n != null; n = n.parent()) {
                if (n != selectedNode) continue;
                this.mediator.getSelectionModel().setSelectedGoal(g);
                return;
            }
        }
    }
}

