/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ClassTree;
import de.uka.ilkd.key.gui.ContractSelectionPanel;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.java.abstraction.KeYJavaType;
import de.uka.ilkd.key.java.declaration.InterfaceDeclaration;
import de.uka.ilkd.key.java.declaration.TypeDeclaration;
import de.uka.ilkd.key.logic.Name;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.op.IObserverFunction;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.init.ContractPO;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.ProblemInitializer;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.ProofStatus;
import de.uka.ilkd.key.proof.mgt.SpecificationRepository;
import de.uka.ilkd.key.speclang.Contract;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.ProgressMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.key_project.util.collection.DefaultImmutableSet;
import org.key_project.util.collection.ImmutableSet;

public final class ProofManagementDialog
extends JDialog {
    private static final long serialVersionUID = 3543411893273433386L;
    @Nullable
    private static ContractId previouslySelectedContracts;
    private static final ImageIcon keyIcon;
    private static final ImageIcon keyAlmostClosedIcon;
    private static final Icon keyClosedIcon;
    private boolean startedProof;
    private JTabbedPane tabbedPane;
    private Map<Pair<KeYJavaType, IObserverFunction>, Icon> targetIcons;
    private ClassTree classTree;
    private JList<ProofWrapper> proofList;
    private ContractSelectionPanel contractPanelByMethod;
    private ContractSelectionPanel contractPanelByProof;
    private JButton startButton;
    private JButton cancelButton;
    private KeYMediator mediator;
    private final InitConfig initConfig;
    private ProofEnvironment env;

    private ProofManagementDialog(MainWindow mainWindow, final InitConfig initConfig) {
        super(mainWindow, "Proof Management", true);
        this.mediator = mainWindow.getMediator();
        this.initConfig = initConfig;
        this.targetIcons = new LinkedHashMap<Pair<KeYJavaType, IObserverFunction>, Icon>();
        this.classTree = new ClassTree(true, true, initConfig.getServices(), this.targetIcons);
        this.classTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ClassTree.Entry entry = ProofManagementDialog.this.classTree.getSelectedEntry();
                    if (entry.kjt != null && entry.target != null) {
                        ImmutableSet contracts = initConfig.getServices().getSpecificationRepository().getContracts(entry.kjt, entry.target);
                        Contract c = (Contract)contracts.iterator().next();
                        if (contracts.size() == 1 && c == ProofManagementDialog.this.contractPanelByMethod.getContract()) {
                            ProofManagementDialog.this.startButton.doClick();
                        }
                    }
                }
            }
        });
        this.classTree.addTreeSelectionListener(e -> this.updateContractPanel());
        this.proofList = new JList();
        this.proofList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -7810888250050777877L;

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component result = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (result instanceof JLabel) {
                    ProofStatus ps = ((ProofWrapper)value).proof.mgt().getStatus();
                    JLabel label = (JLabel)result;
                    if (ps.getProofClosed()) {
                        label.setIcon(keyClosedIcon);
                    } else if (ps.getProofClosedButLemmasLeft()) {
                        label.setIcon(keyAlmostClosedIcon);
                    } else {
                        assert (ps.getProofOpen());
                        label.setIcon(keyIcon);
                    }
                }
                return result;
            }
        });
        this.proofList.addListSelectionListener(e -> this.updateContractPanel());
        JPanel listPanelByMethod = new JPanel();
        listPanelByMethod.setLayout(new BoxLayout(listPanelByMethod, 0));
        JScrollPane classScrollPane = new JScrollPane(this.classTree);
        classScrollPane.setBorder(new TitledBorder("Contract Targets"));
        Dimension classScrollPaneDim = new Dimension(250, 400);
        classScrollPane.setPreferredSize(classScrollPaneDim);
        classScrollPane.setMinimumSize(classScrollPaneDim);
        listPanelByMethod.add(classScrollPane);
        JPanel listPanelByProof = new JPanel();
        listPanelByProof.setLayout(new BoxLayout(listPanelByProof, 0));
        JScrollPane proofScrollPane = new JScrollPane(this.proofList);
        proofScrollPane.setBorder(new TitledBorder("Proofs"));
        proofScrollPane.setPreferredSize(classScrollPaneDim);
        proofScrollPane.setMinimumSize(classScrollPaneDim);
        listPanelByProof.add(proofScrollPane);
        this.contractPanelByMethod = new ContractSelectionPanel(initConfig.getServices(), false);
        this.contractPanelByMethod.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ProofManagementDialog.this.startButton.doClick();
                }
            }
        });
        this.contractPanelByMethod.addListSelectionListener(e -> this.updateStartButton());
        listPanelByMethod.add(this.contractPanelByMethod);
        this.contractPanelByProof = new ContractSelectionPanel(initConfig.getServices(), false);
        this.contractPanelByProof.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProofManagementDialog.this.updateStartButton();
                if (e.getClickCount() == 2) {
                    ProofManagementDialog.this.startButton.doClick();
                }
            }
        });
        this.contractPanelByProof.addListSelectionListener(e -> this.updateStartButton());
        listPanelByProof.add(this.contractPanelByProof);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("By Target", listPanelByMethod);
        this.tabbedPane.addTab("By Proof", listPanelByProof);
        this.tabbedPane.addChangeListener(e -> {
            this.updateStartButton();
            if (this.proofList.getSelectedIndex() == -1 && this.proofList.getModel().getSize() > 0) {
                this.proofList.setSelectedIndex(0);
            }
        });
        this.getContentPane().add(this.tabbedPane);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        Dimension buttonDim = new Dimension(140, 27);
        buttonPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, (int)buttonDim.getHeight() + 10));
        this.getContentPane().add(buttonPanel);
        this.startButton = new JButton("Start Proof");
        this.startButton.setPreferredSize(buttonDim);
        this.startButton.setMinimumSize(buttonDim);
        this.startButton.setEnabled(false);
        this.startButton.addActionListener(e -> {
            Contract contract = this.getSelectedContract();
            if (contract != null) {
                this.setVisible(false);
                this.findOrStartProof(contract);
            }
        });
        buttonPanel.add(this.startButton);
        this.getRootPane().setDefaultButton(this.startButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setPreferredSize(buttonDim);
        this.cancelButton.setMinimumSize(buttonDim);
        this.cancelButton.addActionListener(e -> this.setVisible(false));
        buttonPanel.add(this.cancelButton);
        GuiUtilities.attachClickOnEscListener(this.cancelButton);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.pack();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.tabbedPane = null;
        this.proofList = null;
        this.targetIcons = null;
        this.classTree = null;
        this.contractPanelByMethod = null;
        this.contractPanelByProof = null;
        this.startButton = null;
        this.cancelButton = null;
    }

    private void selectKJTandTarget() {
        Services servicesLocal = this.initConfig.getServices();
        List allJavaTypes = servicesLocal.getJavaInfo().getAllKeYJavaTypes().stream().sorted(Comparator.comparing(KeYJavaType::getFullName)).filter(kjtTmp -> !(kjtTmp.getJavaType() instanceof TypeDeclaration) || !((TypeDeclaration)kjtTmp.getJavaType()).isLibraryClass()).collect(Collectors.toList());
        Comparator compareFunction = (o1, o2) -> {
            if (o1 instanceof IProgramMethod && !(o2 instanceof IProgramMethod)) {
                return -1;
            }
            if (!(o1 instanceof IProgramMethod) && o2 instanceof IProgramMethod) {
                return 1;
            }
            String s1 = o1.name() instanceof ProgramElementName ? ((ProgramElementName)o1.name()).getProgramName() : o1.name().toString();
            String s2 = o2.name() instanceof ProgramElementName ? ((ProgramElementName)o2.name()).getProgramName() : o2.name().toString();
            return s1.compareTo(s2);
        };
        for (KeYJavaType javaType : allJavaTypes) {
            Stream<IObserverFunction> targets = servicesLocal.getSpecificationRepository().getContractTargets(javaType).stream().sorted(compareFunction).filter(targetTmp -> !servicesLocal.getSpecificationRepository().getContracts(javaType, targetTmp).isEmpty());
            Optional<IObserverFunction> t = targets.findFirst();
            if (!t.isPresent()) continue;
            this.select(javaType, t.get());
            break;
        }
    }

    public static void showInstance(InitConfig initConfig, Proof selectedProof) {
        ProofManagementDialog.showInstance(initConfig, null, null, selectedProof);
    }

    public static void showInstance(InitConfig initConfig, KeYJavaType selectedKJT, IObserverFunction selectedTarget) {
        ProofManagementDialog.showInstance(initConfig, selectedKJT, selectedTarget, null);
    }

    public static boolean showInstance(InitConfig initConfig) {
        return ProofManagementDialog.showInstance(initConfig, null, null, null);
    }

    private static boolean showInstance(InitConfig initConfig, KeYJavaType selectedKJT, IObserverFunction selectedTarget, Proof selectedProof) {
        MainWindow mainWindow = MainWindow.getInstance();
        ProofManagementDialog dialog = new ProofManagementDialog(mainWindow, initConfig);
        dialog.selectKJTandTarget();
        if (previouslySelectedContracts != null) {
            dialog.select(previouslySelectedContracts);
        }
        dialog.updateGlobalStatus();
        if (selectedKJT != null && selectedTarget != null) {
            dialog.select(selectedKJT, selectedTarget);
        }
        if (selectedProof != null) {
            dialog.select(selectedProof);
            dialog.env = selectedProof.getEnv();
        }
        dialog.setLocationRelativeTo(mainWindow);
        dialog.setVisible(true);
        if (dialog.getSelectedContract() != null) {
            Contract c = dialog.getSelectedContract();
            String kjtName = c.getKJT().getFullName();
            String contractName = c.getName();
            String methodName = c.getTarget().name().toString();
            previouslySelectedContracts = new ContractId(kjtName, methodName, contractName);
        }
        return dialog.startedProof;
    }

    private void select(@Nonnull ContractId cid) {
        Services servicesLocal = this.initConfig.getServices();
        String keyJavaTypeName = cid.keyJavaTypeName;
        Optional<KeYJavaType> allJavaTypes = servicesLocal.getJavaInfo().getAllKeYJavaTypes().stream().filter(kjtTmp -> !(kjtTmp.getJavaType() instanceof TypeDeclaration) || !((TypeDeclaration)kjtTmp.getJavaType()).isLibraryClass()).filter(it -> it.getFullName().equals(keyJavaTypeName)).findAny();
        if (!allJavaTypes.isPresent()) {
            return;
        }
        KeYJavaType javaType = allJavaTypes.get();
        Name methodName = new Name(cid.methodName);
        Optional<IObserverFunction> target = servicesLocal.getSpecificationRepository().getContractTargets(javaType).stream().filter(targetTmp -> !servicesLocal.getSpecificationRepository().getContracts(javaType, targetTmp).isEmpty()).filter(it -> it.name().equals((Object)methodName)).findAny();
        if (!target.isPresent()) {
            return;
        }
        IObserverFunction method = target.get();
        this.select(javaType, method);
        if (!this.isInstanceMethodOfAbstractClass(javaType, method)) {
            Optional<Contract> contract = this.initConfig.getServices().getSpecificationRepository().getContracts(javaType, method).stream().filter(it -> it.getName().equals(cid.contractName)).findAny();
            contract.ifPresent(value -> this.contractPanelByMethod.selectContract((Contract)value));
        }
    }

    private ContractSelectionPanel getActiveContractPanel() {
        return this.tabbedPane.getSelectedIndex() == 0 ? this.contractPanelByMethod : this.contractPanelByProof;
    }

    private void select(KeYJavaType kjt, IObserverFunction target) {
        this.tabbedPane.setSelectedIndex(0);
        if (this.classTree != null) {
            this.classTree.select(kjt, target);
        }
    }

    private void select(Proof p) {
        int n = this.proofList.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            if (!this.proofList.getModel().getElementAt((int)i).proof.equals(p)) continue;
            this.tabbedPane.setSelectedIndex(1);
            this.proofList.setSelectedIndex(i);
            break;
        }
    }

    private Contract getSelectedContract() {
        return this.getActiveContractPanel().getContract();
    }

    @Nullable
    private Proof findPreferablyClosedProof(@Nonnull Contract contract) {
        ImmutableSet proofs = this.initConfig.getServices().getSpecificationRepository().getProofs(contract);
        if (proofs.isEmpty()) {
            return null;
        }
        Proof fallback = null;
        for (Proof proof : proofs) {
            ProofStatus status = proof.mgt().getStatus();
            if (status.getProofClosed()) {
                return proof;
            }
            if (fallback != null && !status.getProofClosedButLemmasLeft()) continue;
            fallback = proof;
        }
        return fallback;
    }

    private void findOrStartProof(@Nonnull Contract contract) {
        block5: {
            Proof proof = this.findPreferablyClosedProof(contract);
            if (proof == null) {
                AbstractMediatorUserInterfaceControl ui = this.mediator.getUI();
                ProblemInitializer pi = new ProblemInitializer((ProgressMonitor)ui, this.initConfig.getServices(), (ProblemInitializer.ProblemInitializerListener)ui);
                pi.setFileRepo(this.initConfig.getFileRepo());
                try {
                    ContractPO po = contract.createProofObl(this.initConfig.copyWithServices(this.initConfig.getServices()));
                    ProofAggregate pl = pi.startProver(this.initConfig, (ProofOblInput)po);
                    if (this.env == null) {
                        this.env = ui.createProofEnvironmentAndRegisterProof((ProofOblInput)po, pl, this.initConfig);
                        break block5;
                    }
                    this.env.registerProof((ProofOblInput)po, pl);
                }
                catch (ProofInputException exc) {
                    IssueDialog.showExceptionDialog(MainWindow.getInstance(), exc);
                }
            } else {
                this.mediator.setProof(proof);
            }
        }
        this.startedProof = true;
    }

    private void updateStartButton() {
        Contract contract = this.getSelectedContract();
        if (contract == null) {
            this.startButton.setText("No Contract");
            this.startButton.setIcon(null);
            this.startButton.setEnabled(false);
        } else {
            Proof proof = this.findPreferablyClosedProof(contract);
            if (proof == null) {
                this.startButton.setText("Start Proof");
                this.startButton.setIcon(null);
            } else {
                ProofStatus status = proof.mgt().getStatus();
                this.startButton.setText("Go to Proof");
                if (status.getProofOpen()) {
                    this.startButton.setIcon(keyIcon);
                } else if (status.getProofClosedButLemmasLeft()) {
                    this.startButton.setIcon(keyAlmostClosedIcon);
                } else {
                    assert (status.getProofClosed());
                    this.startButton.setIcon(keyClosedIcon);
                }
            }
            this.startButton.setEnabled(true);
        }
        this.validate();
    }

    private boolean isInstanceMethodOfAbstractClass(KeYJavaType p_class, IObserverFunction obs) {
        return p_class.getJavaType() instanceof InterfaceDeclaration || p_class.getSort().isAbstract() && !obs.isStatic();
    }

    private void updateContractPanel() {
        ContractSelectionPanel pan = this.getActiveContractPanel();
        if (pan == this.contractPanelByMethod) {
            ClassTree.Entry entry = this.classTree.getSelectedEntry();
            if (entry != null && entry.target != null && !this.isInstanceMethodOfAbstractClass(entry.kjt, entry.target)) {
                ImmutableSet contracts = this.initConfig.getServices().getSpecificationRepository().getContracts(entry.kjt, entry.target);
                pan.setContracts((ImmutableSet<Contract>)contracts, "Contracts");
                pan.setGrayOutAuxiliaryContracts(Objects.equals(this.targetIcons.get(new Pair((Object)entry.kjt, (Object)entry.target)), keyClosedIcon));
            } else {
                pan.setContracts((ImmutableSet<Contract>)DefaultImmutableSet.nil(), "Contracts");
            }
        } else if (pan == this.contractPanelByProof) {
            if (this.proofList.getSelectedValue() != null) {
                Proof p = this.proofList.getSelectedValue().proof;
                ImmutableSet usedContracts = p.mgt().getUsedContracts();
                pan.setContracts((ImmutableSet<Contract>)usedContracts, "Contracts used in proof \"" + p.name() + "\"");
            } else {
                pan.setContracts((ImmutableSet<Contract>)DefaultImmutableSet.nil(), "Contracts");
            }
        }
        this.updateStartButton();
    }

    private void updateGlobalStatus() {
        boolean changed;
        Services services = this.initConfig.getServices();
        SpecificationRepository specRepos = services.getSpecificationRepository();
        Set kjts = services.getJavaInfo().getAllKeYJavaTypes();
        for (Object kjt : kjts) {
            if (kjt.getJavaType() instanceof TypeDeclaration && ((TypeDeclaration)kjt.getJavaType()).isLibraryClass()) continue;
            ImmutableSet targets = specRepos.getContractTargets((KeYJavaType)kjt);
            for (IObserverFunction target : targets) {
                if (this.isInstanceMethodOfAbstractClass((KeYJavaType)kjt, target)) continue;
                ImmutableSet contracts = specRepos.getContracts((KeYJavaType)kjt, target);
                boolean startedProving = false;
                boolean allClosed = true;
                boolean lemmasLeft = false;
                for (Contract contract : contracts) {
                    if (contract.isAuxiliary()) continue;
                    Proof proof = this.findPreferablyClosedProof(contract);
                    if (proof == null) {
                        allClosed = false;
                        continue;
                    }
                    startedProving = true;
                    ProofStatus status = proof.mgt().getStatus();
                    if (status.getProofOpen()) {
                        allClosed = false;
                        continue;
                    }
                    if (!status.getProofClosedButLemmasLeft()) continue;
                    lemmasLeft = true;
                }
                this.targetIcons.put((Pair<KeYJavaType, IObserverFunction>)new Pair(kjt, (Object)target), startedProving ? (allClosed ? (lemmasLeft ? keyAlmostClosedIcon : keyClosedIcon) : keyIcon) : null);
            }
        }
        this.classTree.updateUI();
        DefaultListModel<ProofWrapper> model = new DefaultListModel<ProofWrapper>();
        for (Proof p : specRepos.getAllProofs()) {
            model.add(0, new ProofWrapper(p));
        }
        if (model.size() != this.proofList.getModel().getSize()) {
            changed = true;
        } else {
            changed = false;
            int n = model.size();
            for (int i = 0; i < n; ++i) {
                if (((ProofWrapper)model.get(i)).equals(this.proofList.getModel().getElementAt(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            this.proofList.setModel(model);
            this.proofList.updateUI();
        }
        this.updateContractPanel();
        this.updateStartButton();
    }

    static {
        keyIcon = IconFactory.keyHole(20, 20);
        keyAlmostClosedIcon = IconFactory.keyHoleAlmostClosed(20, 20);
        keyClosedIcon = IconFactory.keyHoleClosed(20);
    }

    private static final class ContractId {
        @Nullable
        public final String keyJavaTypeName;
        @Nullable
        public final String methodName;
        @Nullable
        public final String contractName;

        private ContractId(@Nullable String keyJavaTypeName, @Nullable String methodName, @Nullable String contractName) {
            this.keyJavaTypeName = keyJavaTypeName;
            this.methodName = methodName;
            this.contractName = contractName;
        }
    }

    private static final class ProofWrapper {
        public final Proof proof;

        public ProofWrapper(Proof proof) {
            this.proof = proof;
        }

        public String toString() {
            return this.proof.name().toString();
        }

        public boolean equals(Object o) {
            return o instanceof ProofWrapper && this.proof.equals(((ProofWrapper)o).proof);
        }

        public int hashCode() {
            return this.proof.hashCode();
        }
    }
}

