/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.AbstractUserInterfaceControl;
import de.uka.ilkd.key.core.InterruptListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.macros.scripts.ProofScriptEngine;
import de.uka.ilkd.key.macros.scripts.ScriptException;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.proof.Goal;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.util.List;
import java.util.Observer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofScriptWorker
extends SwingWorker<Object, Object>
implements InterruptListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProofScriptWorker.class);
    private final KeYMediator mediator;
    private final String script;
    private final Location initialLocation;
    private final Goal initiallySelectedGoal;
    private ProofScriptEngine engine;
    private JDialog monitor;
    private JTextArea logArea;
    private final Observer observer = (o, arg) -> this.publish(arg);

    public ProofScriptWorker(KeYMediator mediator, File file) throws IOException {
        this.initialLocation = new Location(file.toURI().toURL(), 1, 1);
        this.script = new String(Files.readAllBytes(file.toPath()));
        this.mediator = mediator;
        this.initiallySelectedGoal = null;
    }

    public ProofScriptWorker(KeYMediator mediator, String script, Location location) {
        this(mediator, script, location, null);
    }

    public ProofScriptWorker(KeYMediator mediator, String script, Location location, Goal initiallySelectedGoal) {
        this.mediator = mediator;
        this.script = script;
        this.initialLocation = location;
        this.initiallySelectedGoal = initiallySelectedGoal;
    }

    @Override
    protected Object doInBackground() throws Exception {
        try {
            this.engine = new ProofScriptEngine(this.script, this.initialLocation, this.initiallySelectedGoal);
            this.engine.setCommandMonitor(this.observer);
            this.engine.execute((AbstractUserInterfaceControl)this.mediator.getUI(), this.mediator.getSelectedProof());
        }
        catch (InterruptedException ex) {
            LOGGER.debug("Proof macro has been interrupted:", (Throwable)ex);
        }
        return null;
    }

    private void makeDialog() {
        URL url = this.initialLocation.getFileURL();
        if (this.monitor != null) {
            this.logArea.setText("Running script from URL '" + url + "':\n");
            return;
        }
        JDialog dlg = new JDialog((Window)MainWindow.getInstance(), "Running Script ...", Dialog.ModalityType.MODELESS);
        Container cp = dlg.getContentPane();
        this.logArea = new JTextArea();
        this.logArea.setFont(new Font("Monospaced", 0, 12));
        this.logArea.setEditable(false);
        this.logArea.setText("Running script from URL '" + url + "':\n");
        cp.add((Component)new JScrollPane(this.logArea), "Center");
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.interruptionPerformed());
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(cancelButton);
        cp.add((Component)panel, "South");
        dlg.setSize(750, 400);
        dlg.setLocationRelativeTo(MainWindow.getInstance());
        this.monitor = dlg;
    }

    @Override
    protected void process(List<Object> chunks) {
        Document doc = this.logArea.getDocument();
        for (Object chunk : chunks) {
            assert (chunk instanceof String);
            try {
                if (!((String)chunk).startsWith("'")) {
                    doc.insertString(doc.getLength(), "\n---\n" + chunk, null);
                    continue;
                }
                if (((String)chunk).startsWith("'echo ")) continue;
                doc.insertString(doc.getLength(), "\n---\nExecuting: " + chunk, null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    public void init() {
        this.mediator.stopInterface(true);
        this.mediator.setInteractive(false);
        this.mediator.addInterruptedListener(this);
        this.makeDialog();
        this.monitor.setVisible(true);
    }

    @Override
    public void done() {
        if (this.monitor != null) {
            this.monitor.setVisible(false);
        }
        try {
            this.get();
        }
        catch (CancellationException ex) {
            LOGGER.info("Scripting was cancelled.", (Throwable)ex);
        }
        catch (Throwable ex) {
            IssueDialog.showExceptionDialog(MainWindow.getInstance(), ex);
        }
        this.mediator.removeInterruptedListener(this);
        ProofScriptWorker.runWithDeadline(() -> this.mediator.startInterface(true), 1000);
        ProofScriptWorker.runWithDeadline(() -> this.mediator.getUI().getProofControl().stopAndWaitAutoMode(), 1000);
        try {
            if (!this.mediator.getSelectedProof().closed()) {
                this.mediator.getSelectionModel().setSelectedGoal(this.engine.getStateMap().getFirstOpenAutomaticGoal());
            }
        }
        catch (ScriptException e) {
            LOGGER.warn("", (Throwable)e);
        }
        this.mediator.setInteractive(true);
    }

    private static void runWithDeadline(Runnable runnable, int milliseconds) {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<?> future = executor.submit(runnable);
        executor.shutdown();
        try {
            future.get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            // empty catch block
        }
    }

    @Override
    public void interruptionPerformed() {
        this.cancel(true);
    }
}

