/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public final class ProofSelectionDialog
extends JDialog {
    private static final long serialVersionUID = -586107341789859969L;
    private static final String IDENT = "(.*)";
    private static final String TYPE = "(.*)";
    private static final String NUM = "(\\d+)";
    private static final Pattern PROOF_NAME_PATTERN = Pattern.compile("(.*)\\((.*)__(.*)\\)\\)\\.(.*).(\\d+).proof");
    private Path proofToLoad;

    private ProofSelectionDialog(Path bundlePath) throws IOException {
        super(MainWindow.getInstance(), "Choose proof to load", true);
        final JList<Path> list = this.createAndFillList(bundlePath);
        JScrollPane scrollPane = new JScrollPane(list);
        scrollPane.setBorder(new TitledBorder("Proofs found in bundle:"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2, 5, 5));
        this.getContentPane().add((Component)buttonPanel, "Last");
        JButton okButton = new JButton("OK");
        Dimension buttonDim = new Dimension(100, 27);
        okButton.setPreferredSize(buttonDim);
        okButton.setMinimumSize(buttonDim);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofSelectionDialog.this.proofToLoad = (Path)list.getSelectedValue();
                ProofSelectionDialog.this.setVisible(false);
                ProofSelectionDialog.this.dispose();
            }
        });
        if (list.getModel().getSize() == 0) {
            okButton.setEnabled(false);
        }
        buttonPanel.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setPreferredSize(buttonDim);
        cancelButton.setMinimumSize(buttonDim);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofSelectionDialog.this.setVisible(false);
                ProofSelectionDialog.this.dispose();
            }
        });
        buttonPanel.add(cancelButton);
        this.setMinimumSize(new Dimension(300, 200));
        this.pack();
    }

    private JList<Path> createAndFillList(Path bundlePath) throws IOException {
        ZipFile bundle = new ZipFile(bundlePath.toFile());
        List proofs = bundle.stream().filter(e -> !e.isDirectory()).filter(e -> e.getName().endsWith(".proof")).map(e -> Paths.get(e.getName(), new String[0])).collect(Collectors.toList());
        DefaultListModel<Path> model = new DefaultListModel<Path>();
        for (Path p : proofs) {
            model.addElement(p);
        }
        final JList<Path> list = new JList<Path>(model);
        list.setSelectionMode(0);
        list.setSelectedIndex(0);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() >= 2) {
                    ProofSelectionDialog.this.proofToLoad = (Path)list.getSelectedValue();
                    ProofSelectionDialog.this.setVisible(false);
                    ProofSelectionDialog.this.dispose();
                }
            }
        });
        list.setCellRenderer(new ListCellRenderer<Path>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends Path> jList, Path value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = new JLabel(ProofSelectionDialog.abbreviateProofPath(value));
                label.setOpaque(true);
                if (isSelected) {
                    label.setBackground(list.getSelectionBackground());
                    label.setForeground(list.getSelectionForeground());
                } else {
                    label.setBackground(list.getBackground());
                    label.setForeground(list.getForeground());
                }
                return label;
            }
        });
        return list;
    }

    private static String abbreviateProofPath(Path proofPath) {
        String pathString = proofPath.toString();
        Matcher m = PROOF_NAME_PATTERN.matcher(pathString);
        if (m.matches() && m.groupCount() == 5) {
            String className = m.group(1);
            String method = m.group(3);
            String type = m.group(4).toLowerCase();
            String num = m.group(5);
            type = type.contains("normal") ? "normal " : (type.contains("exceptional") ? "exceptional " : "");
            return className + "::" + method + ") " + type + num;
        }
        return pathString;
    }

    private static Path showDialog(Path bundlePath) {
        Path proofPath = null;
        try {
            ProofSelectionDialog dialog = new ProofSelectionDialog(bundlePath);
            dialog.setLocationRelativeTo(MainWindow.getInstance());
            dialog.setVisible(true);
            proofPath = dialog.proofToLoad;
        }
        catch (IOException exc) {
            IssueDialog.showExceptionDialog(MainWindow.getInstance(), exc);
        }
        return proofPath;
    }

    public static Path chooseProofToLoad(Path bundlePath) {
        if (ProofSelectionDialog.isProofBundle(bundlePath)) {
            return ProofSelectionDialog.showDialog(bundlePath);
        }
        return null;
    }

    public static boolean isProofBundle(Path path) {
        return path.toString().endsWith(".zproof");
    }
}

