/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ProofSelectionDialog;
import de.uka.ilkd.key.gui.actions.QuickSaveAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.settings.PathConfig;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecentFileMenu {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecentFileMenu.class);
    private static final int MAX_RECENT_FILES = 8;
    private int maxNumberOfEntries;
    private JMenu menu = new JMenu("Recent Files");
    private ActionListener lissy;
    private HashMap<JMenuItem, RecentFileEntry> recentFiles;
    private RecentFileEntry mostRecentFile;

    public RecentFileMenu(final KeYMediator mediator) {
        this.lissy = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String absPath = RecentFileMenu.this.getAbsolutePath((JMenuItem)e.getSource());
                File file = new File(absPath);
                if (ProofSelectionDialog.isProofBundle(file.toPath())) {
                    Path proofPath = ProofSelectionDialog.chooseProofToLoad(file.toPath());
                    if (proofPath == null) {
                        return;
                    }
                    mediator.getUI().loadProofFromBundle(file, proofPath.toFile());
                    return;
                }
                mediator.getUI().loadProblem(file);
            }
        };
        this.maxNumberOfEntries = 8;
        this.recentFiles = new LinkedHashMap<JMenuItem, RecentFileEntry>();
        this.menu.setEnabled(this.menu.getItemCount() != 0);
        this.menu.setIcon(IconFactory.recentFiles(16));
        this.load(PathConfig.getRecentFileStorage());
    }

    private void removeFromModelAndView(JMenuItem item, int index) {
        this.recentFiles.remove(item);
        this.menu.remove(index);
    }

    private void addToModelAndView(String name) {
        if (QuickSaveAction.QUICK_SAVE_PATH.endsWith(name)) {
            return;
        }
        RecentFileEntry entry = new RecentFileEntry(name);
        if (new File(entry.getAbsolutePath()).exists()) {
            JMenuItem item = new JMenuItem(entry.getFileName());
            item.setToolTipText(entry.getAbsolutePath());
            this.recentFiles.put(item, entry);
            item.addActionListener(this.lissy);
            this.menu.insert(item, 0);
            this.mostRecentFile = entry;
        }
    }

    public String getAbsolutePath(JMenuItem item) {
        return this.recentFiles.get(item).getAbsolutePath();
    }

    public void addRecentFile(String name) {
        LOGGER.debug("recentfilemenu: add file: {}", (Object)name);
        LOGGER.debug("recentfilemenu: at menu count: {}", (Object)this.menu.getItemCount());
        int index = -1;
        JMenuItem item = null;
        for (int i = 0; i < this.menu.getItemCount(); ++i) {
            if (this.menu.getItem(i) == null) continue;
            LOGGER.debug("{}", (Object)i);
            LOGGER.debug("item is {}", (Object)this.menu.getItem(i));
            LOGGER.debug("name is {}", (Object)this.menu.getItem(i).getText());
            if (!this.recentFiles.get(this.menu.getItem(i)).getAbsolutePath().equals(name)) continue;
            item = this.menu.getItem(i);
            index = i;
            break;
        }
        if (index != -1) {
            this.removeFromModelAndView(item, index);
        }
        if (this.menu.getItemCount() == this.maxNumberOfEntries) {
            this.removeFromModelAndView(this.menu.getItem(this.menu.getItemCount() - 1), this.menu.getItemCount() - 1);
        }
        this.addToModelAndView(name);
        this.menu.setEnabled(this.menu.getItemCount() != 0);
    }

    public void setMaxNumberOfEntries(int max) {
        if (this.maxNumberOfEntries > max && this.menu.getItemCount() > max) {
            for (int i = this.menu.getItemCount() - 1; i > max; --i) {
                this.menu.remove(i);
            }
        }
        this.maxNumberOfEntries = max;
    }

    public JMenu getMenu() {
        return this.menu;
    }

    public void load(Properties p) {
        int i = this.maxNumberOfEntries;
        do {
            String s;
            if ((s = p.getProperty("RecentFile" + i)) == null) continue;
            this.addRecentFile(s);
        } while (--i >= 0);
    }

    public void store(Properties p) {
        for (int i = 0; i < this.menu.getItemCount(); ++i) {
            p.setProperty("RecentFile" + i, this.getAbsolutePath(this.menu.getItem(i)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(String filename) {
        FileInputStream propStream = null;
        try {
            propStream = new FileInputStream(filename);
            Properties p = new Properties();
            p.load(propStream);
            Enumeration<?> e = p.propertyNames();
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                if (s.indexOf("RecentFile") == -1) continue;
                this.addRecentFile(p.getProperty(s));
            }
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("Could not read RecentFileList. Did not find file {}", (Object)filename);
        }
        catch (IOException ioe) {
            LOGGER.debug("Could not read RecentFileList. Some IO Error occured ", (Throwable)ioe);
        }
        finally {
            try {
                if (propStream != null) {
                    propStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public RecentFileEntry getMostRecent() {
        return this.mostRecentFile;
    }

    public void store(String filename) {
        File localRecentFiles = new File(filename);
        Properties p = new Properties();
        try (FileInputStream fin = new FileInputStream(localRecentFiles);
             FileOutputStream fout = new FileOutputStream(localRecentFiles);){
            localRecentFiles.createNewFile();
            p.load(fin);
            this.store(p);
            p.store(fout, "recent files");
        }
        catch (IOException ex) {
            LOGGER.info("Cound not write recentFileList", (Throwable)ex);
        }
    }

    public static class RecentFileEntry {
        private String fileName;
        private String absolutePath;

        public RecentFileEntry(String absolutePath) {
            this.absolutePath = absolutePath;
            int lastIndex = absolutePath.lastIndexOf(File.separatorChar);
            this.fileName = lastIndex == -1 ? absolutePath : absolutePath.substring(lastIndex + 1);
        }

        public String getAbsolutePath() {
            return this.absolutePath;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String toString() {
            return this.fileName;
        }
    }
}

