/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class SearchBar
extends JPanel {
    private static final long serialVersionUID = -4821960226273983607L;
    public JTextField searchField = new JTextField(20);
    private JButton prev;
    private JButton next;
    private JButton close;
    private final ColorSettings.ColorProperty ALERT_COLOR = ColorSettings.define("[searchBar]alert", "", new Color(255, 178, 178));

    public SearchBar() {
        this.prev = new JButton(IconFactory.previous(16));
        this.next = new JButton(IconFactory.next(16));
        this.close = new JButton(IconFactory.close(16));
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.setVisible(false);
            }
        });
        this.next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.searchNext();
                SearchBar.this.searchField.requestFocusInWindow();
            }
        });
        this.prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchBar.this.searchPrevious();
                SearchBar.this.searchField.requestFocusInWindow();
            }
        });
        this.searchField.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.searchNext();
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.setVisible(false);
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                SearchBar.this.search();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchBar.this.search();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchBar.this.search();
            }
        });
        Font font = this.prev.getFont().deriveFont(20.0f);
        this.prev.setFont(font);
        this.next.setFont(font);
        this.close.setFont(font);
        this.prev.setToolTipText("Jump to previous match");
        this.next.setToolTipText("Jump to next match");
        this.close.setToolTipText("Close search bar");
        Insets insets = new Insets(0, 4, 0, 4);
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.GRAY, 1), new EmptyBorder(insets));
        this.prev.setBorder(border);
        this.next.setBorder(border);
        this.close.setBorder(border);
        this.createUI();
        this.setVisible(false);
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            this.searchField.selectAll();
            this.searchField.requestFocus();
        }
    }

    public abstract void searchPrevious();

    public abstract void searchNext();

    public abstract boolean search(String var1);

    public void search() {
        boolean b = this.search(this.searchField.getText());
        if (b) {
            this.searchField.setBackground(Color.WHITE);
        } else {
            this.searchField.setBackground(this.ALERT_COLOR.get());
        }
    }

    public void createUI() {
        this.setLayout(new BoxLayout(this, 2));
        this.add(new JLabel("Search: "));
        this.add(this.searchField);
        this.add(this.prev);
        this.prev.setMargin(new Insets(2, 1, 2, 1));
        this.add(this.next);
        this.next.setMargin(new Insets(2, 1, 2, 1));
        this.add(this.close);
        this.close.setMargin(new Insets(2, 1, 2, 1));
    }
}

