/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.MaxRuleAppSlider;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.init.JavaProfile;
import de.uka.ilkd.key.settings.ProofSettings;
import de.uka.ilkd.key.strategy.Strategy;
import de.uka.ilkd.key.strategy.StrategyFactory;
import de.uka.ilkd.key.strategy.StrategyProperties;
import de.uka.ilkd.key.strategy.definition.AbstractStrategyPropertyDefinition;
import de.uka.ilkd.key.strategy.definition.IDefaultStrategyPropertiesFactory;
import de.uka.ilkd.key.strategy.definition.OneOfStrategyPropertyDefinition;
import de.uka.ilkd.key.strategy.definition.StrategyPropertyValueDefinition;
import de.uka.ilkd.key.strategy.definition.StrategySettingsDefinition;
import de.uka.ilkd.key.util.Triple;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.key_project.util.java.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StrategySelectionView
extends JPanel
implements TabPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(StrategySelectionView.class);
    private static final long serialVersionUID = -267867794853527874L;
    private static final StrategyFactory FACTORY = JavaProfile.DEFAULT;
    private static final StrategySettingsDefinition DEFINITION = FACTORY.getSettingsDefinition();
    private static final String JAVACARDDL_STRATEGY_NAME = FACTORY.name().toString();
    private KeYMediator mediator;
    private StrategySelectionComponents components;
    private boolean predefChanged = true;
    private final KeYSelectionListener mediatorListener = new KeYSelectionListener(){

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            StrategySelectionView.this.refresh(e.getSource().getSelectedProof());
        }
    };
    private JButton btnGo;

    public StrategySelectionView() {
        this.layoutPane();
        this.refresh(this.mediator == null ? null : this.mediator.getSelectedProof());
        this.setVisible(true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                StrategySelectionView.this.components.getMaxRuleAppSlider().refresh();
            }
        });
        KeYGuiExtensionFacade.installKeyboardShortcuts(this.mediator, this, KeYGuiExtension.KeyboardShortcuts.STRATEGY_SELECTION_VIEW);
    }

    public StrategySelectionView(MainWindow window, KeYMediator mediator) {
        this();
        this.setMediator(mediator);
        this.btnGo.setAction(window.getAutoModeAction());
    }

    private void layoutPane() {
        assert (this.components == null) : "Content can not be created a second time!";
        this.components = new StrategySelectionComponents();
        JPanel javaDLOptionsPanel = new JPanel();
        JScrollPane javaDLOptionsScrollPane = new JScrollPane(javaDLOptionsPanel, 20, 30);
        javaDLOptionsPanel.setEnabled(true);
        this.setLayout(new BoxLayout(this, 1));
        GridBagConstraints gbcpanel5 = new GridBagConstraints();
        GridBagLayout javaDLOptionsLayout = new GridBagLayout();
        javaDLOptionsPanel.setLayout(javaDLOptionsLayout);
        javaDLOptionsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.btnGo = new JButton();
        JPanel timeout = this.createDefaultPanel(this.components);
        JPanel goPanel = new JPanel();
        GridBagLayout goLayout = new GridBagLayout();
        goPanel.setLayout(goLayout);
        goPanel.setAlignmentX(0.0f);
        gbcpanel5.gridx = 1;
        gbcpanel5.gridy = 0;
        gbcpanel5.gridwidth = 1;
        gbcpanel5.gridheight = 1;
        gbcpanel5.fill = 0;
        gbcpanel5.weightx = 1.0;
        gbcpanel5.weighty = 0.0;
        gbcpanel5.anchor = 17;
        gbcpanel5.insets = new Insets(4, 4, 4, 4);
        goLayout.setConstraints(this.btnGo, gbcpanel5);
        goPanel.add(this.btnGo);
        gbcpanel5.gridx = 2;
        gbcpanel5.gridy = 0;
        gbcpanel5.gridwidth = 1;
        gbcpanel5.gridheight = 1;
        gbcpanel5.fill = 0;
        gbcpanel5.weightx = 1.0;
        gbcpanel5.weighty = 0.0;
        gbcpanel5.anchor = 17;
        gbcpanel5.insets = new Insets(0, 0, 0, 0);
        gbcpanel5.gridx = 3;
        gbcpanel5.gridy = 0;
        gbcpanel5.gridwidth = 1;
        gbcpanel5.gridheight = 1;
        gbcpanel5.fill = 0;
        gbcpanel5.weightx = 0.0;
        gbcpanel5.weighty = 0.0;
        gbcpanel5.anchor = 10;
        gbcpanel5.insets = new Insets(0, 0, 0, 0);
        goLayout.setConstraints(timeout, gbcpanel5);
        goPanel.add(timeout);
        this.fixVerticalSpace(goPanel);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(4));
        box.add(goPanel);
        box.add(Box.createVerticalStrut(8));
        if (DEFINITION.isShowMaxRuleApplications()) {
            MaxRuleAppSlider maxSlider = new MaxRuleAppSlider(this.mediator, DEFINITION.getMaxRuleApplicationsLabel());
            this.components.setMaxRuleAppSlider(maxSlider);
            maxSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    StrategySelectionView.this.predefChanged = true;
                    StrategySelectionView.this.refreshDefaultButton();
                }
            });
            maxSlider.setAlignmentX(0.0f);
            box.add(maxSlider);
            box.add(Box.createVerticalStrut(8));
        }
        javaDLOptionsScrollPane.setAlignmentX(0.0f);
        box.add(javaDLOptionsScrollPane);
        if (!DEFINITION.getProperties().isEmpty()) {
            javaDLOptionsScrollPane.setBorder(BorderFactory.createTitledBorder(DEFINITION.getPropertiesTitle()));
            javaDLOptionsPanel.setLayout(javaDLOptionsLayout);
            javaDLOptionsScrollPane.getVerticalScrollBar().setUnitIncrement(10);
            javaDLOptionsScrollPane.setAlignmentX(0.0f);
            box.add(javaDLOptionsScrollPane);
            int yCoord = 0;
            for (AbstractStrategyPropertyDefinition definition : DEFINITION.getProperties()) {
                yCoord = this.createStrategyProperty(this.components, FACTORY, javaDLOptionsPanel, javaDLOptionsLayout, yCoord, true, definition);
            }
            this.fixVerticalSpace(javaDLOptionsScrollPane);
        }
        this.add(box);
    }

    protected int createStrategyProperty(StrategySelectionComponents data, StrategyFactory factory, JPanel javaDLOptionsPanel, GridBagLayout javaDLOptionsLayout, int yCoord, boolean topLevel, AbstractStrategyPropertyDefinition definition) {
        if (definition instanceof OneOfStrategyPropertyDefinition) {
            JRadioButton radioButton;
            OneOfStrategyPropertyDefinition oneOfDefinition = (OneOfStrategyPropertyDefinition)definition;
            ButtonGroup buttonGroup = new ButtonGroup();
            if (!oneOfDefinition.getValues().isEmpty()) {
                data.addPropertyGroup(oneOfDefinition.getApiKey(), buttonGroup);
            }
            ++yCoord;
            JLabel label = new JLabel(oneOfDefinition.getName());
            label.setToolTipText(oneOfDefinition.getTooltip());
            if (topLevel) {
                this.addJavaDLOption(javaDLOptionsPanel, label, javaDLOptionsLayout, 1, yCoord, 7);
                ++yCoord;
                int gridx = 0;
                int column = 0;
                for (StrategyPropertyValueDefinition valueDefinition : oneOfDefinition.getValues()) {
                    radioButton = this.newButton(valueDefinition.getValue(), oneOfDefinition.getApiKey(), valueDefinition.getApiValue(), true, false, factory);
                    data.addPropertyButton(radioButton, oneOfDefinition.getApiKey());
                    radioButton.setToolTipText(valueDefinition.getTooltip());
                    buttonGroup.add(radioButton);
                    this.addJavaDLOption(javaDLOptionsPanel, radioButton, javaDLOptionsLayout, valueDefinition.getSwingGridx() >= 0 ? valueDefinition.getSwingGridx() : (gridx += 2), yCoord, valueDefinition.getSwingWidth() >= 0 ? valueDefinition.getSwingWidth() : 2);
                    if (oneOfDefinition.getColumnsPerRow() < 0 || ++column % oneOfDefinition.getColumnsPerRow() != 0) continue;
                    gridx = 0;
                    ++yCoord;
                }
            } else if (((StrategyPropertyValueDefinition)oneOfDefinition.getValues().get(0)).getSwingGridx() >= 0) {
                this.addJavaDLOption(javaDLOptionsPanel, label, javaDLOptionsLayout, 2, yCoord, 1);
                int gridx = 0;
                int column = 0;
                for (StrategyPropertyValueDefinition valueDefinition : oneOfDefinition.getValues()) {
                    radioButton = this.newButton(valueDefinition.getValue(), oneOfDefinition.getApiKey(), valueDefinition.getApiValue(), true, false, factory);
                    data.addPropertyButton(radioButton, oneOfDefinition.getApiKey());
                    radioButton.setToolTipText(valueDefinition.getTooltip());
                    buttonGroup.add(radioButton);
                    this.addJavaDLOption(javaDLOptionsPanel, radioButton, javaDLOptionsLayout, valueDefinition.getSwingGridx() >= 0 ? valueDefinition.getSwingGridx() : (gridx += 2), yCoord, valueDefinition.getSwingWidth() >= 0 ? valueDefinition.getSwingWidth() : 2);
                    if (oneOfDefinition.getColumnsPerRow() < 0 || ++column % oneOfDefinition.getColumnsPerRow() != 0) continue;
                    gridx = 0;
                    ++yCoord;
                }
            } else {
                JPanel queryAxiomPanel = new JPanel();
                queryAxiomPanel.add(label);
                for (StrategyPropertyValueDefinition valueDefinition : oneOfDefinition.getValues()) {
                    JRadioButton radioButton2 = this.newButton(valueDefinition.getValue(), oneOfDefinition.getApiKey(), valueDefinition.getApiValue(), true, false, factory);
                    data.addPropertyButton(radioButton2, oneOfDefinition.getApiKey());
                    radioButton2.setToolTipText(valueDefinition.getTooltip());
                    buttonGroup.add(radioButton2);
                    queryAxiomPanel.add(radioButton2);
                }
                this.addJavaDLOption(javaDLOptionsPanel, queryAxiomPanel, javaDLOptionsLayout, 2, yCoord, 7);
            }
        } else {
            throw new RuntimeException("Unsupported property definition \"" + definition + "\".");
        }
        this.addJavaDLOptionSpace(javaDLOptionsPanel, javaDLOptionsLayout, ++yCoord);
        for (AbstractStrategyPropertyDefinition subProperty : definition.getSubProperties()) {
            yCoord = this.createStrategyProperty(data, factory, javaDLOptionsPanel, javaDLOptionsLayout, yCoord, false, subProperty);
        }
        return yCoord;
    }

    private JRadioButton newButton(String text, String key, String command, boolean selected, boolean enabled, StrategyFactory factory) {
        JRadioButton result = new JRadioButton(text);
        result.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StrategySelectionView.this.predefChanged = true;
                StrategyProperties props = StrategySelectionView.this.getProperties();
                StrategySelectionView.this.updateStrategySettings(StrategySelectionView.this.mediator.getSelectedProof().getActiveStrategy().name().toString(), props);
            }
        });
        result.setEnabled(enabled);
        result.setActionCommand(command);
        return result;
    }

    private void addJavaDLOptionSpace(JPanel javaDLOptionsPanel, GridBagLayout javaDLOptionsLayout, int yCoord) {
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = yCoord;
        con.gridwidth = 9;
        con.gridheight = 1;
        con.fill = 2;
        con.weightx = 1.0;
        con.weighty = 0.0;
        con.anchor = 10;
        JLabel sep = new JLabel();
        javaDLOptionsLayout.setConstraints(sep, con);
        javaDLOptionsPanel.add(sep);
        this.addJavaDLOption(javaDLOptionsPanel, Box.createRigidArea(new Dimension(4, 4)), javaDLOptionsLayout, 0, yCoord, 1);
        this.addJavaDLOption(javaDLOptionsPanel, Box.createRigidArea(new Dimension(4, 4)), javaDLOptionsLayout, 1, yCoord, 1);
    }

    private void addJavaDLOption(JPanel javaDLOptionsPanel, Component widget, GridBagLayout javaDLOptionsLayout, int gridx, int gridy, int width) {
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = gridx;
        con.gridy = gridy;
        con.gridwidth = width;
        con.gridheight = 1;
        con.fill = 0;
        con.weightx = 0.0;
        con.weighty = 0.0;
        con.anchor = 17;
        javaDLOptionsLayout.setConstraints(widget, con);
        javaDLOptionsPanel.add(widget);
    }

    private void fixVerticalSpace(JComponent comp) {
        comp.setMaximumSize(new Dimension(Integer.MAX_VALUE, comp.getPreferredSize().height));
    }

    private JPanel createDefaultPanel(StrategySelectionComponents components) {
        JPanel panel = new JPanel();
        final JButton defaultButton = new JButton("Choose Predef");
        components.setDefaultButton(defaultButton);
        String[] existingPredefs = new String[1 + DEFINITION.getFurtherDefaults().size()];
        existingPredefs[0] = "Defaults";
        int i = 1;
        for (Triple furtherDefault : DEFINITION.getFurtherDefaults()) {
            existingPredefs[i] = (String)furtherDefault.first;
            ++i;
        }
        final JComboBox<String> strategyPredefSettingsCmb = new JComboBox<String>(existingPredefs);
        strategyPredefSettingsCmb.setSelectedIndex(0);
        components.setPredefsChoiceCmb(strategyPredefSettingsCmb);
        defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int newMaxSteps = 0;
                StrategyProperties newProps = null;
                int selIndex = strategyPredefSettingsCmb.getSelectedIndex();
                if (selIndex == 0) {
                    newMaxSteps = DEFINITION.getDefaultMaxRuleApplications();
                    newProps = DEFINITION.getDefaultPropertiesFactory().createDefaultStrategyProperties();
                } else {
                    Triple chosenDefault = (Triple)DEFINITION.getFurtherDefaults().get(selIndex - 1);
                    newMaxSteps = (Integer)chosenDefault.second;
                    newProps = ((IDefaultStrategyPropertiesFactory)chosenDefault.third).createDefaultStrategyProperties();
                }
                StrategySelectionView.this.mediator.getSelectedProof().getSettings().getStrategySettings().setMaxSteps(newMaxSteps);
                StrategySelectionView.this.updateStrategySettings(JAVACARDDL_STRATEGY_NAME, newProps);
                StrategySelectionView.this.predefChanged = false;
                StrategySelectionView.this.refresh(StrategySelectionView.this.mediator.getSelectedProof());
            }
        });
        strategyPredefSettingsCmb.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                defaultButton.getActionListeners()[0].actionPerformed(null);
            }
        });
        panel.add(strategyPredefSettingsCmb);
        panel.add(defaultButton);
        return panel;
    }

    public void setMediator(KeYMediator mediator) {
        if (this.mediator != null) {
            this.mediator.removeKeYSelectionListener(this.mediatorListener);
        }
        this.mediator = mediator;
        if (this.components.getMaxRuleAppSlider() != null) {
            this.components.getMaxRuleAppSlider().setMediator(this.mediator);
        }
        if (this.mediator != null) {
            this.mediator.addKeYSelectionListener(this.mediatorListener);
        }
    }

    public void refresh(Proof proof) {
        if (proof == null) {
            this.enableAll(false);
        } else {
            if (this.components.getMaxRuleAppSlider() != null) {
                this.components.getMaxRuleAppSlider().refresh();
            }
            StrategyProperties sp = proof.getSettings().getStrategySettings().getActiveStrategyProperties();
            for (Map.Entry<String, List<JRadioButton>> entry : this.components.getPropertyButtons().entrySet()) {
                String value = sp.getProperty(entry.getKey());
                for (JRadioButton button : entry.getValue()) {
                    button.setSelected(ObjectUtil.equals((Object)button.getActionCommand(), (Object)value));
                }
            }
            this.enableAll(true);
            this.refreshDefaultButton();
        }
    }

    private void refreshDefaultButton() {
        if (this.mediator.getSelectedProof() != null) {
            this.components.getDefaultButton().setEnabled(this.predefChanged);
        } else {
            this.components.getDefaultButton().setEnabled(false);
            this.components.getStrategyPredefSettingsCmb().setEnabled(false);
        }
    }

    private void enableAll(boolean enable) {
        if (this.components.getMaxRuleAppSlider() != null) {
            this.components.getMaxRuleAppSlider().setEnabled(enable);
        }
        this.components.getDefaultButton().setEnabled(enable);
        this.components.getStrategyPredefSettingsCmb().setEnabled(enable);
        for (Map.Entry<String, List<JRadioButton>> entry : this.components.getPropertyButtons().entrySet()) {
            for (JRadioButton button : entry.getValue()) {
                button.setEnabled(enable);
            }
        }
    }

    public Strategy getStrategy(String strategyName, Proof proof, StrategyProperties properties) {
        if (this.mediator != null) {
            for (StrategyFactory s : this.mediator.getProfile().supportedStrategies()) {
                if (!strategyName.equals(s.name().toString())) continue;
                return s.create(proof, properties);
            }
            LOGGER.info("Selected Strategy '{}' not found falling back to {}", (Object)strategyName, (Object)this.mediator.getProfile().getDefaultStrategyFactory().name());
        }
        return this.mediator != null ? this.mediator.getProfile().getDefaultStrategyFactory().create(proof, properties) : proof.getServices().getProfile().getDefaultStrategyFactory().create(proof, properties);
    }

    private StrategyProperties getProperties() {
        StrategyProperties p = new StrategyProperties();
        for (Map.Entry<String, ButtonGroup> entry : this.components.getPropertyGroups().entrySet()) {
            ButtonModel selected = entry.getValue().getSelection();
            if (selected != null) {
                p.setProperty(entry.getKey(), selected.getActionCommand());
                continue;
            }
            p.setProperty(entry.getKey(), DEFINITION.getDefaultPropertiesFactory().createDefaultStrategyProperties().getProperty(entry.getKey()));
        }
        return p;
    }

    private void updateStrategySettings(String strategyName, StrategyProperties p) {
        Proof proof = this.mediator.getSelectedProof();
        Strategy strategy = this.getStrategy(strategyName, proof, p);
        ProofSettings.DEFAULT_SETTINGS.getStrategySettings().setStrategy(strategy.name());
        ProofSettings.DEFAULT_SETTINGS.getStrategySettings().setActiveStrategyProperties(p);
        proof.getSettings().getStrategySettings().setStrategy(strategy.name());
        proof.getSettings().getStrategySettings().setActiveStrategyProperties(p);
        proof.setActiveStrategy(strategy);
        this.refresh(proof);
    }

    @Override
    public String getTitle() {
        return "Proof Search Strategy";
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public Icon getIcon() {
        return IconFactory.PROOF_SEARCH_STRATEGY.get(16.0f);
    }

    private static class StrategySelectionComponents {
        private final Map<String, List<JRadioButton>> propertyButtons = new HashMap<String, List<JRadioButton>>();
        private final Map<String, ButtonGroup> propertyGroups = new HashMap<String, ButtonGroup>();
        private MaxRuleAppSlider maxRuleAppSlider;
        private JButton defaultButton;
        private JComboBox<String> strategyPredefSettingsCmb;

        private StrategySelectionComponents() {
        }

        public MaxRuleAppSlider getMaxRuleAppSlider() {
            return this.maxRuleAppSlider;
        }

        public void setMaxRuleAppSlider(MaxRuleAppSlider maxRuleAppSlider) {
            this.maxRuleAppSlider = maxRuleAppSlider;
        }

        public void addPropertyButton(JRadioButton button, String key) {
            List<JRadioButton> buttons = this.propertyButtons.get(key);
            if (buttons == null) {
                buttons = new LinkedList<JRadioButton>();
                this.propertyButtons.put(key, buttons);
            }
            buttons.add(button);
        }

        public Map<String, List<JRadioButton>> getPropertyButtons() {
            return this.propertyButtons;
        }

        public JButton getDefaultButton() {
            return this.defaultButton;
        }

        public void setDefaultButton(JButton defaultButton) {
            this.defaultButton = defaultButton;
        }

        public JComboBox<String> getStrategyPredefSettingsCmb() {
            return this.strategyPredefSettingsCmb;
        }

        public void setPredefsChoiceCmb(JComboBox<String> strategyPredefSettingsCmb) {
            this.strategyPredefSettingsCmb = strategyPredefSettingsCmb;
        }

        public Map<String, ButtonGroup> getPropertyGroups() {
            return this.propertyGroups;
        }

        public void addPropertyGroup(String property, ButtonGroup group) {
            this.propertyGroups.put(property, group);
        }
    }
}

