/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.instantiation_model.TacletAssumesModel;
import de.uka.ilkd.key.control.instantiation_model.TacletInstantiationModel;
import de.uka.ilkd.key.gui.TacletMatchCompletionDialog;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.rule.IfFormulaInstantiation;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TacletIfSelectionDialog
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TacletIfSelectionDialog.class);
    private static final long serialVersionUID = -7456635942609535650L;
    private JPanel ifPanel = new JPanel();
    private final TacletInstantiationModel model;
    private final TacletMatchCompletionDialog owner;

    public TacletIfSelectionDialog(TacletInstantiationModel model, TacletMatchCompletionDialog owner) {
        this.model = model;
        this.owner = owner;
        this.layoutDialog();
        this.setVisible(true);
    }

    private void layoutDialog() {
        this.setLayout(new BoxLayout(this, 1));
        this.ifPanel = this.createIfPanel();
        this.add(this.ifPanel);
    }

    private JPanel createIfPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(new TitledBorder("Please instantiate the taclet's assumptions:"));
        for (int i = 0; i < this.model.ifChoiceModelCount(); ++i) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            JLabel label = new JLabel(ProofSaver.printAnything((Object)this.model.ifFma(i), (Services)this.model.proof().getServices())){
                private static final long serialVersionUID = -6925345438533627265L;

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(100, 10);
                }
            };
            p.add(label);
            JComboBox<IfFormulaInstantiation> ifChoice = new JComboBox<IfFormulaInstantiation>((ComboBoxModel)this.model.ifChoiceModel(i)){
                private static final long serialVersionUID = -6429999070946158788L;

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(800, (int)super.getPreferredSize().getHeight());
                }
            };
            IfComboRenderer rend = new IfComboRenderer(this.model.proof().getServices());
            ifChoice.setRenderer(rend);
            ifChoice.addActionListener(e -> {
                JComboBox cb = (JComboBox)e.getSource();
                this.updateInputField(p, cb);
            });
            p.add(ifChoice);
            this.updateInputField(p, ifChoice);
            panel.add(p);
        }
        return panel;
    }

    protected int current() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFocusAt(int field, int col) {
        this.ifPanel.setVisible(true);
        this.ifPanel.requestFocus();
        JTextField tf = (JTextField)((JPanel)this.ifPanel.getComponent(field)).getComponent(2);
        if (tf == null) {
            LOGGER.debug("None existing field requested");
        }
        if (tf != null && col >= 0 && col < tf.getColumns()) {
            try {
                tf.setCaretPosition(col - 1);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.debug("Something is wrong with the caret position calculation.", (Throwable)iae);
            }
            finally {
                tf.requestFocus();
                tf.validate();
            }
        }
        this.ifPanel.validate();
    }

    private void updateInputField(JPanel parent, JComboBox<?> cb) {
        TacletAssumesModel icm = (TacletAssumesModel)cb.getModel();
        int nr = parent.getComponentCount();
        if (icm.isManualInputSelected() && nr == 2) {
            JTextField inp = new JTextField(40);
            inp.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    TacletIfSelectionDialog.this.pushAllInputToModel();
                    TacletIfSelectionDialog.this.owner.setStatus();
                }
            });
            inp.addActionListener(e -> {
                this.pushAllInputToModel();
                this.owner.setStatus();
            });
            parent.add(inp);
            inp.setEnabled(true);
        }
        if (!icm.isManualInputSelected() && nr == 3) {
            parent.remove(parent.getComponent(2));
        }
        parent.revalidate();
        this.pushAllInputToModel();
        this.owner.setStatus();
    }

    protected void pushAllInputToModel() {
        for (int i = 0; i < this.ifPanel.getComponentCount(); ++i) {
            JPanel pan = (JPanel)this.ifPanel.getComponent(i);
            if (pan.getComponentCount() == 3 && ((JTextField)pan.getComponent(2)).getText() != null) {
                this.model.setManualInput(i, ((JTextField)pan.getComponent(2)).getText());
                continue;
            }
            this.model.setManualInput(i, "");
        }
    }

    static class IfComboRenderer
    implements ListCellRenderer<IfFormulaInstantiation> {
        private static final long serialVersionUID = -7145932915948630147L;
        private final Services services;
        private DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer();

        public IfComboRenderer(Services services) {
            this.services = services;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends IfFormulaInstantiation> list, IfFormulaInstantiation value, int index, boolean isSelected, boolean cellHasFocus) {
            this.cellRenderer.setOpaque(true);
            String valStr = value.toString(this.services);
            if (isSelected) {
                list.setToolTipText(valStr);
            }
            return this.cellRenderer.getListCellRendererComponent(list, valStr, index, isSelected, cellHasFocus);
        }
    }
}

