/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.InstantiationFileHandler;
import de.uka.ilkd.key.control.instantiation_model.TacletInstantiationModel;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ApplyTacletDialog;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.TableRowResizer;
import de.uka.ilkd.key.gui.TacletIfSelectionDialog;
import de.uka.ilkd.key.gui.nodeviews.PosInSequentTransferable;
import de.uka.ilkd.key.gui.utilities.BracketMatchingTextArea;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.ldt.LocSetLDT;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.TermLabel;
import de.uka.ilkd.key.logic.op.IObserverFunction;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.ModelChangeListener;
import de.uka.ilkd.key.proof.ModelEvent;
import de.uka.ilkd.key.proof.SVInstantiationExceptionWithPosition;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.TacletApp;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TacletMatchCompletionDialog
extends ApplyTacletDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(TacletMatchCompletionDialog.class);
    private static final long serialVersionUID = 5124050224007103908L;
    private DataTable[] dataTable;
    private int current = 0;
    private JTabbedPane alternatives;
    private Goal goal;
    private JScrollPane tablePane;
    private MainWindow mainWindow;

    public TacletMatchCompletionDialog(MainWindow parent, TacletInstantiationModel[] model, Goal goal, KeYMediator mediator) {
        super((Frame)parent, model, mediator);
        this.setName("tacletMatchDlg");
        this.mainWindow = parent;
        this.goal = goal;
        this.current = 0;
        this.dataTable = new DataTable[model.length];
        for (TacletInstantiationModel aModel : model) {
            aModel.prepareUnmatchedInstantiation();
        }
        this.setStatus();
        this.layoutDialog();
        this.pack();
        this.mainWindow.loadPreferences(this);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
        this.focusFirstEditableCell();
    }

    private void focusFirstEditableCell() {
        for (int i = 0; i < this.model.length; ++i) {
            if (this.model[i] == null) continue;
            DataTable table = this.dataTable[i];
            for (int row = 0; row < table.getRowCount(); ++row) {
                for (int column = 0; column < table.getColumnCount(); ++column) {
                    if (!table.isCellEditable(row, column)) continue;
                    table.editCellAt(row, column);
                    table.changeSelection(row, column, false, false);
                    ((PositionSettable)((Object)table.getCellEditor(row, column))).requestFocus();
                    return;
                }
            }
        }
    }

    public void setStatus() {
        this.setStatus(this.model[this.current].getStatusString());
    }

    private void layoutDialog() {
        JPanel tacletPanel = this.createTacletPanel();
        JPanel downPanel = new JPanel();
        downPanel.setLayout(new BoxLayout(downPanel, 1));
        downPanel.add(this.createInfoPanel());
        downPanel.add(this.createStatusPanel());
        downPanel.add(this.createButtonPanel(new ButtonListener()));
        JSplitPane splitPaneBot = new JSplitPane(0, tacletPanel, downPanel);
        splitPaneBot.setResizeWeight(1.0);
        splitPaneBot.setName("tacletMatchDlg.splitBottom");
        JSplitPane splitPane = new JSplitPane(0, this.createTacletDisplay(), splitPaneBot);
        splitPane.setName("tacletMatchDlg.split");
        this.getContentPane().add(splitPane);
        this.updateDataModel();
    }

    private JPanel createTacletPanel() {
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(new TitledBorder("Variable Instantiations"));
        this.alternatives = new JTabbedPane();
        EmptyBorder indents = new EmptyBorder(5, 5, 5, 5);
        for (int i = 0; i < this.model.length; ++i) {
            JPanel tabContent = new JPanel();
            tabContent.setLayout(new BoxLayout(tabContent, 1));
            JPanel instPanel = this.createInstantiationDisplay(i);
            instPanel.setBorder(indents);
            tabContent.add(instPanel);
            if (!this.model[i].application().taclet().ifSequent().isEmpty()) {
                TacletIfSelectionDialog ifSelection = new TacletIfSelectionDialog(this.model[i], this);
                this.dataTable[i].setIfSelectionPanel(ifSelection);
                tabContent.add(ifSelection);
            }
            this.alternatives.addTab("Alt " + i, null, tabContent, "Instantiations Alternatives");
        }
        panel.add(this.alternatives);
        return panel;
    }

    @Override
    protected int current() {
        return this.alternatives.getSelectedIndex();
    }

    @Override
    protected void pushAllInputToModel() {
        this.pushAllInputToModel(this.current());
    }

    private void pushAllInputToModel(int i) {
        if (this.dataTable[i].hasIfSelectionPanel()) {
            this.dataTable[i].getIfSelectionPanel().pushAllInputToModel();
        }
        if (this.dataTable[i].isEditing()) {
            this.dataTable[i].getCellEditor().stopCellEditing();
        }
    }

    private JPanel createInstantiationDisplay(int i) {
        JPanel panel = new JPanel(new BorderLayout());
        this.dataTable[i] = new DataTable(this, i, this.mediator);
        this.dataTable[i].setRowHeight(48);
        this.tablePane = new JScrollPane(this.dataTable[i]);
        this.adaptSizes(this.dataTable[i]);
        panel.add((Component)this.tablePane, "Center");
        return panel;
    }

    private void adaptSizes(DataTable dt) {
        int tableSize_x = dt.getTotalColumnWidth();
        int visible_rows = dt.getRowCount() > 8 ? 8 : dt.getRowCount();
        int tableSize_y = (visible_rows + 1) * 48;
        Dimension tableDim = new Dimension(tableSize_x, tableSize_y);
        this.tablePane.setPreferredSize(tableDim);
        this.validate();
    }

    private void setColumnName(int model, int col, String name) {
        this.dataTable[model].getColumn(this.dataTable[model].getColumnName(col)).setHeaderValue(name);
    }

    private void updateDataModel() {
        for (int i = 0; i < this.model.length; ++i) {
            if (this.model[i] == null) continue;
            this.dataTable[i].setModel((TableModel)this.model[i].tableModel());
            this.setColumnName(i, 0, "Variable");
            this.setColumnName(i, 1, "Instantiation");
        }
    }

    @Override
    protected void closeDlg() {
        if (this.mainWindow != null) {
            this.mainWindow.savePreferences(this);
        }
        super.closeDlg();
    }

    private static String printTerm(KeYMediator mediator, Term term) {
        NotationInfo ni = new NotationInfo();
        Services services = mediator.getServices();
        Term t = TermLabel.removeIrrelevantLabels((Term)term, (Services)services);
        LogicPrinter p = new LogicPrinter(new ProgramPrinter(), ni, services);
        boolean pretty = mediator.getNotationInfo().isPrettySyntax();
        ni.refresh(services, pretty, false);
        Map tbl = ni.getNotationTable();
        if (pretty) {
            LocSetLDT setLDT = services.getTypeConverter().getLocSetLDT();
            tbl.remove(setLDT.getUnion());
            tbl.remove(setLDT.getIntersect());
            tbl.remove(setLDT.getSetMinus());
            tbl.remove(setLDT.getElementOf());
            tbl.remove(setLDT.getSubset());
            tbl.remove(IObserverFunction.class);
            tbl.remove(IProgramMethod.class);
        }
        try {
            p.printTerm(t);
        }
        catch (IOException ioe) {
            return t.toString();
        }
        return p.result().toString();
    }

    static interface PositionSettable {
        public void setCaretPosition(int var1);

        public void setVisible(boolean var1);

        public void validate();

        public void requestFocus();
    }

    private static class DataTable
    extends JTable
    implements ModelChangeListener {
        private static final long serialVersionUID = 5988602390976062610L;
        JTextArea inputArea = new BracketMatchingTextArea("Nothing", 3, 16);
        final InputEditor iEditor = new InputEditor(this.inputArea);
        final InputCellRenderer iRenderer = new InputCellRenderer();
        private int modelNr;
        private TacletMatchCompletionDialog owner;
        private KeYMediator mediator;
        private TacletIfSelectionDialog ifSelectionPanel;

        private DataTable(TacletMatchCompletionDialog owner, int modelNr, final KeYMediator mediator) {
            super((TableModel)owner.model[modelNr].tableModel());
            this.modelNr = modelNr;
            this.owner = owner;
            this.mediator = mediator;
            owner.model[modelNr].addModelChangeListener((ModelChangeListener)this);
            this.setUpEditor();
            DropTarget aDropTarget = new DropTarget(this, new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent event) {
                }

                @Override
                public void dragExit(DropTargetEvent event) {
                }

                @Override
                public void dragOver(DropTargetDragEvent event) {
                }

                @Override
                public void drop(DropTargetDropEvent event) {
                    block9: {
                        Point dropLocation = event.getLocation();
                        DataTable dt = this;
                        int row = dt.rowAtPoint(dropLocation);
                        int column = dt.columnAtPoint(dropLocation);
                        if (row != -1 && column == 1 && dt.isCellEditable(row, column)) {
                            try {
                                Transferable transferable = event.getTransferable();
                                if (transferable.isDataFlavorSupported(PosInSequentTransferable.POS_IN_SEQUENT_TRANSFER)) {
                                    event.acceptDrop(2);
                                    PosInSequent pis = (PosInSequent)transferable.getTransferData(PosInSequentTransferable.POS_IN_SEQUENT_TRANSFER);
                                    Term term = pis.getPosInOccurrence().subTerm();
                                    String droppedString = TacletMatchCompletionDialog.printTerm(mediator, term);
                                    if (droppedString != null) {
                                        this.setValueAt(droppedString, row, column);
                                        this.repaint();
                                    }
                                    event.getDropTargetContext().dropComplete(true);
                                    break block9;
                                }
                                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                                    event.acceptDrop(2);
                                    String droppedString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                                    if (droppedString != null) {
                                        this.setValueAt(droppedString, row, column);
                                        this.repaint();
                                    }
                                    event.getDropTargetContext().dropComplete(true);
                                    break block9;
                                }
                                event.rejectDrop();
                            }
                            catch (IOException exception) {
                                exception.printStackTrace();
                                event.rejectDrop();
                            }
                            catch (UnsupportedFlavorException ufException) {
                                ufException.printStackTrace();
                                event.rejectDrop();
                            }
                        } else {
                            event.rejectDrop();
                        }
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent dtde) {
                }
            });
            this.setDropTarget(aDropTarget);
            new TableRowResizer(this);
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            return this.iEditor;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            return this.iRenderer;
        }

        @Override
        public Object getValueAt(int x, int y) {
            Object value = super.getValueAt(x, y);
            if (value == null) {
                return "";
            }
            return value;
        }

        private void setUpEditor() {
            this.setDefaultEditor(String.class, this.iEditor);
        }

        private void setIfSelectionPanel(TacletIfSelectionDialog ifSelectionPanel) {
            this.ifSelectionPanel = ifSelectionPanel;
        }

        private TacletIfSelectionDialog getIfSelectionPanel() {
            return this.ifSelectionPanel;
        }

        private boolean hasIfSelectionPanel() {
            return this.getIfSelectionPanel() != null;
        }

        public void modelChanged(ModelEvent me) {
            if (me.getSource() instanceof TacletInstantiationModel) {
                this.setModel((TableModel)((TacletInstantiationModel)me.getSource()).tableModel());
                this.repaint();
            }
        }

        public int getTotalColumnWidth() {
            return this.getColumnModel().getTotalColumnWidth();
        }

        @Override
        public void editingStopped(ChangeEvent e) {
            if (this.modelNr == this.owner.current()) {
                super.editingStopped(e);
                this.owner.pushAllInputToModel(this.modelNr);
                if (this.owner.checkAfterEachInput()) {
                    this.owner.setStatus(this.owner.model[this.modelNr].getStatusString());
                }
            }
        }

        class InputCellRenderer
        extends DefaultTableCellRenderer {
            private static final long serialVersionUID = -7270236368657110379L;
            JTextArea ta = new JTextArea("nothing");

            InputCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
                if (obj == null) {
                    obj = "";
                }
                this.ta.setRows(DataTable.this.getRowHeight(row) / 16);
                this.ta.setText(obj.toString());
                if (table.isCellEditable(row, column)) {
                    this.ta.setBackground(Color.white);
                    this.ta.setForeground(Color.black);
                } else {
                    this.ta.setBackground(new Color(215, 215, 215));
                    this.ta.setForeground(Color.black);
                }
                return this.ta;
            }
        }

        class InputEditor
        extends DefaultCellEditor
        implements PositionSettable {
            private static final long serialVersionUID = 1547755822847646366L;
            JPanel editPanel;
            JTextArea textarea;

            public InputEditor(JTextArea ta) {
                super(new JCheckBox());
                this.textarea = ta;
                this.editPanel = new JPanel();
                this.editPanel.setLayout(new BoxLayout(this.editPanel, 0));
                this.editPanel.add(new JScrollPane(this.textarea, 20, 30));
                Insets zeroIn = new Insets(0, 0, 0, 0);
                JButton less = new JButton("-");
                less.setMargin(zeroIn);
                JButton more = new JButton("+");
                more.setMargin(zeroIn);
                Dimension smallSq = new Dimension(20, 20);
                less.setMaximumSize(smallSq);
                less.setMinimumSize(smallSq);
                less.setPreferredSize(smallSq);
                more.setMaximumSize(smallSq);
                more.setMinimumSize(smallSq);
                more.setPreferredSize(smallSq);
                less.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (InputEditor.this.textarea.getRows() > 3) {
                            InputEditor.this.textarea.setRows(InputEditor.this.textarea.getRows() - 1);
                            DataTable.this.setRowHeight(DataTable.this.getSelectedRow(), DataTable.this.getRowHeight(DataTable.this.getSelectedRow()) - 16);
                            DataTable.this.setValueAt(InputEditor.this.textarea.getText(), DataTable.this.getSelectedRow(), DataTable.this.getSelectedColumn());
                        }
                    }
                });
                more.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InputEditor.this.textarea.setRows(InputEditor.this.textarea.getRows() + 1);
                        DataTable.this.setRowHeight(DataTable.this.getSelectedRow(), DataTable.this.getRowHeight(DataTable.this.getSelectedRow()) + 16);
                        DataTable.this.setValueAt(InputEditor.this.textarea.getText(), DataTable.this.getSelectedRow(), DataTable.this.getSelectedColumn());
                    }
                });
                this.editorComponent = this.editPanel;
                this.setClickCountToStart(1);
                DropTarget aDropTarget = new DropTarget(ta, new DropTargetListener(){

                    @Override
                    public void dragEnter(DropTargetDragEvent event) {
                    }

                    @Override
                    public void dragExit(DropTargetEvent event) {
                    }

                    @Override
                    public void dragOver(DropTargetDragEvent event) {
                    }

                    @Override
                    public void drop(DropTargetDropEvent event) {
                        Transferable transferable = event.getTransferable();
                        if (transferable.isDataFlavorSupported(PosInSequentTransferable.POS_IN_SEQUENT_TRANSFER)) {
                            try {
                                event.acceptDrop(2);
                                PosInSequent pis = (PosInSequent)transferable.getTransferData(PosInSequentTransferable.POS_IN_SEQUENT_TRANSFER);
                                Term term = pis.getPosInOccurrence().subTerm();
                                String droppedString = TacletMatchCompletionDialog.printTerm(DataTable.this.mediator, term);
                                if (droppedString != null) {
                                    int pos = InputEditor.this.textarea.viewToModel(event.getLocation());
                                    InputEditor.this.textarea.insert(droppedString, pos);
                                }
                                event.getDropTargetContext().dropComplete(true);
                            }
                            catch (Exception e) {
                                event.rejectDrop();
                            }
                        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            event.acceptDrop(2);
                            try {
                                String droppedString = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                                int pos = InputEditor.this.textarea.viewToModel(event.getLocation());
                                InputEditor.this.textarea.insert(droppedString, pos);
                                event.getDropTargetContext().dropComplete(true);
                            }
                            catch (UnsupportedFlavorException e) {
                                e.printStackTrace();
                                event.rejectDrop();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                event.rejectDrop();
                            }
                        } else {
                            event.rejectDrop();
                        }
                    }

                    @Override
                    public void dropActionChanged(DropTargetDragEvent dtde) {
                    }
                });
                ta.setDropTarget(aDropTarget);
            }

            @Override
            protected void fireEditingStopped() {
                super.fireEditingStopped();
            }

            @Override
            public Object getCellEditorValue() {
                return this.textarea.getText();
            }

            @Override
            public void setCaretPosition(int i) {
                this.textarea.setCaretPosition(i);
            }

            @Override
            public void setVisible(boolean b) {
                this.textarea.setVisible(b);
            }

            @Override
            public void validate() {
                this.textarea.validate();
            }

            @Override
            public void requestFocus() {
                this.textarea.requestFocus();
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                if (value == null) {
                    value = "";
                }
                this.textarea.setText(value.toString());
                this.textarea.setRows(DataTable.this.getRowHeight(row) / 16);
                return this.editorComponent;
            }
        }
    }

    class ButtonListener
    implements ActionListener {
        private void errorPositionKnown(String errorMessage, int row, int col, boolean inIfSequent) {
            if (inIfSequent) {
                TacletMatchCompletionDialog.this.dataTable[TacletMatchCompletionDialog.this.current()].getIfSelectionPanel().requestFocusAt(row, col);
            } else {
                boolean tableCol = true;
                TacletMatchCompletionDialog.this.dataTable[TacletMatchCompletionDialog.this.current()].editCellAt(row, 1);
                TacletMatchCompletionDialog.this.dataTable[TacletMatchCompletionDialog.this.current()].setEditingRow(row);
                TacletMatchCompletionDialog.this.dataTable[TacletMatchCompletionDialog.this.current()].setEditingColumn(1);
                PositionSettable ed = (PositionSettable)((Object)TacletMatchCompletionDialog.this.dataTable[TacletMatchCompletionDialog.this.current()].getCellEditor(row, 1));
                try {
                    ed.setCaretPosition(col - 1);
                }
                catch (IllegalArgumentException iae) {
                    LOGGER.debug("tacletmatchcompletiondialog:: something is wrong with the caret position calculation.");
                }
                ed.setVisible(true);
                ed.validate();
                ed.requestFocus();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TacletMatchCompletionDialog.this.cancelButton) {
                this.closeDialog();
            } else if (e.getSource() == TacletMatchCompletionDialog.this.applyButton) {
                try {
                    TacletMatchCompletionDialog.this.pushAllInputToModel();
                    TacletApp app = TacletMatchCompletionDialog.this.model[TacletMatchCompletionDialog.this.current()].createTacletApp();
                    if (app == null) {
                        JOptionPane.showMessageDialog(TacletMatchCompletionDialog.this, "Could not apply rule", "Rule Application Failure", 0);
                        return;
                    }
                    TacletMatchCompletionDialog.this.mediator().getUI().getProofControl().applyInteractive((RuleApp)app, TacletMatchCompletionDialog.this.goal);
                }
                catch (Exception exc) {
                    if (exc instanceof SVInstantiationExceptionWithPosition) {
                        this.errorPositionKnown(exc.getMessage(), ((SVInstantiationExceptionWithPosition)exc).getRow(), ((SVInstantiationExceptionWithPosition)exc).getColumn(), ((SVInstantiationExceptionWithPosition)exc).inIfSequent());
                    }
                    IssueDialog.showExceptionDialog(TacletMatchCompletionDialog.this, exc);
                    return;
                }
                InstantiationFileHandler.saveListFor((TacletInstantiationModel)TacletMatchCompletionDialog.this.model[TacletMatchCompletionDialog.this.current()]);
                this.closeDialog();
            }
        }

        private void closeDialog() {
            TacletMatchCompletionDialog.this.closeDlg();
            TacletMatchCompletionDialog.this.setVisible(false);
            TacletMatchCompletionDialog.this.dispose();
        }
    }
}

