/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.extension.api.DefaultContextMenuKind;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.notification.events.AbandonTaskEvent;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.ProofTreeAdapter;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import de.uka.ilkd.key.proof.ProofTreeListener;
import de.uka.ilkd.key.proof.mgt.BasicTask;
import de.uka.ilkd.key.proof.mgt.EnvNode;
import de.uka.ilkd.key.proof.mgt.ProofEnvironment;
import de.uka.ilkd.key.proof.mgt.ProofStatus;
import de.uka.ilkd.key.proof.mgt.TaskTreeModel;
import de.uka.ilkd.key.proof.mgt.TaskTreeNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskTree
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTree.class);
    private static final long serialVersionUID = -6084969108377936099L;
    private JTree delegateView;
    private KeYMediator mediator;
    private MouseListener mouseListener = new TaskTreeMouseListener();
    private ProofTreeListener proofTreeListener = new TaskTreeProofTreeListener();
    private TaskTreeModel model = new TaskTreeModel();

    public TaskTree(KeYMediator mediator) {
        this.mediator = mediator;
        mediator.addKeYSelectionListener(new TaskTreeSelectionListener());
        this.delegateView = new JTree();
        this.delegateView.setModel(this.model);
        this.delegateView.setCellRenderer(new TaskTreeIconCellRenderer());
        this.delegateView.addMouseListener(this.mouseListener);
        this.setLayout(new BorderLayout());
        this.add((Component)this.delegateView, "Center");
        this.delegateView.setShowsRootHandles(false);
        this.delegateView.setRootVisible(false);
        this.delegateView.putClientProperty("JTree.lineStyle", "Horizontal");
    }

    JTree jtree() {
        return this.delegateView;
    }

    public void addProof(ProofAggregate plist) {
        Proof[] proofs;
        TaskTreeNode bp = this.model.addProof(plist);
        for (Proof proof : proofs = plist.getProofs()) {
            proof.addProofTreeListener(this.proofTreeListener);
            this.mediator.getCurrentlyOpenedProofs().addElement(proof);
        }
        this.delegateView.validate();
        this.delegateView.scrollPathToVisible(new TreePath(bp.getPath()));
        this.delegateView.setVisible(true);
        this.setVisible(true);
    }

    public void removeTask(Proof p) {
        TaskTreeNode taskForProof = this.model.getTaskForProof(p);
        if (taskForProof instanceof BasicTask) {
            taskForProof = ((BasicTask)taskForProof).getRootTask();
        }
        this.removeTask(taskForProof);
    }

    public void removeTask(TaskTreeNode tn) {
        this.model.removeTask(tn);
        this.mediator.notify(new AbandonTaskEvent());
        for (int i = 0; i < tn.allProofs().length; ++i) {
            tn.allProofs()[i].removeProofTreeListener(this.proofTreeListener);
            tn.allProofs()[i].mgt().removeProofListener();
        }
        MainWindow.getInstance().getProofTreeView().removeProofs(tn.allProofs());
        TreePath path = this.delegateView.getPathForRow(this.delegateView.getRowCount() - 1);
        if (path != null) {
            TaskTreeNode tn0 = (TaskTreeNode)path.getLastPathComponent();
            this.mediator.setProof(tn0.proof());
        } else {
            this.mediator.setProof(null);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        Font myFont = UIManager.getFont("KEY_FONT_PROOF_LIST_VIEW");
        if (myFont != null) {
            this.setFont(myFont);
        } else {
            LOGGER.debug("KEY_FONT_PROOF_LIST_VIEW not available, use standard font.");
        }
    }

    public TaskTreeNode getSelectedTask() {
        TreePath path = this.delegateView.getSelectionModel().getSelectionPath();
        if (path != null && path.getLastPathComponent() instanceof TaskTreeNode) {
            return (TaskTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    public BasicTask[] getAllSelectedBasicTasks() {
        TreePath[] paths = this.delegateView.getSelectionModel().getSelectionPaths();
        if (paths == null) {
            return new BasicTask[0];
        }
        LinkedList<BasicTask> result = new LinkedList<BasicTask>();
        for (TreePath path : paths) {
            if (!(path.getLastPathComponent() instanceof BasicTask)) continue;
            result.add((BasicTask)path.getLastPathComponent());
        }
        return result.toArray(new BasicTask[result.size()]);
    }

    private void problemChosen() {
        TaskTreeNode prob = this.getSelectedTask();
        if (prob != null && prob.proof() != null && this.mediator != null) {
            this.mediator.setProof(prob.proof());
        }
    }

    public boolean containsProof(Proof proof) {
        boolean contains = false;
        for (int i = 0; !contains && i < this.model.getChildCount(this.model.getRoot()); ++i) {
            Object rootChild = this.model.getChild(this.model.getRoot(), i);
            if (!(rootChild instanceof EnvNode)) continue;
            EnvNode envNode = (EnvNode)rootChild;
            for (int j = 0; !contains && j < envNode.getChildCount(); ++j) {
                TreeNode envChild = envNode.getChildAt(j);
                if (!(envChild instanceof TaskTreeNode)) continue;
                TaskTreeNode taskChild = (TaskTreeNode)envChild;
                contains = taskChild.proof() == proof;
            }
        }
        return contains;
    }

    public void removeProof(Proof proof) {
        if (proof != null) {
            Object child;
            int i;
            ProofEnvironment env = proof.getEnv();
            DefaultMutableTreeNode envNode = null;
            for (i = 0; i < this.model.getChildCount(this.model.getRoot()); ++i) {
                child = this.model.getChild(this.model.getRoot(), i);
                if (!(child instanceof EnvNode)) continue;
                EnvNode envChild = (EnvNode)child;
                if (!(env != null ? env.equals((Object)envChild.getProofEnv()) : envChild.getProofEnv() == null)) continue;
                envNode = envChild;
            }
            if (envNode != null) {
                for (i = 0; i < envNode.getChildCount(); ++i) {
                    TaskTreeNode taskChild;
                    child = envNode.getChildAt(i);
                    if (!(child instanceof TaskTreeNode) || (taskChild = (TaskTreeNode)child).proof() != proof) continue;
                    this.removeTask(taskChild);
                }
            }
        }
    }

    public TaskTreeModel getModel() {
        return this.model;
    }

    class TaskTreeSelectionListener
    implements KeYSelectionListener {
        TaskTreeSelectionListener() {
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            if (e.getSource().getSelectedProof() == null) {
                return;
            }
            TaskTreeNode ttn = TaskTree.this.model.getTaskForProof(e.getSource().getSelectedProof());
            TaskTree.this.jtree().setSelectionPath(new TreePath(ttn.getPath()));
            TaskTree.this.validate();
        }
    }

    static class TaskTreeIconCellRenderer
    extends DefaultTreeCellRenderer
    implements Serializable {
        private static final long serialVersionUID = 2423935787625012908L;
        static final Icon keyIcon = IconFactory.keyHole(20, 20);
        static final Icon keyClosedIcon = IconFactory.keyHoleClosed(20);
        static final Icon keyAlmostClosedIcon = IconFactory.keyHoleAlmostClosed(20, 20);

        public TaskTreeIconCellRenderer() {
            this.setToolTipText("Task");
        }

        @Override
        public Component getTreeCellRendererComponent(JTree list, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ProofStatus ps;
            Object newValue = value instanceof TaskTreeNode ? ((TaskTreeNode)value).shortDescr() : value;
            DefaultTreeCellRenderer sup = (DefaultTreeCellRenderer)super.getTreeCellRendererComponent(list, newValue, selected, expanded, leaf, row, hasFocus);
            sup.setIcon(null);
            if (value instanceof TaskTreeNode && (ps = ((TaskTreeNode)value).getStatus()) != null) {
                if (ps.getProofClosed()) {
                    sup.setIcon(keyClosedIcon);
                }
                if (ps.getProofClosedButLemmasLeft()) {
                    sup.setIcon(keyAlmostClosedIcon);
                }
                if (ps.getProofOpen()) {
                    sup.setIcon(keyIcon);
                }
            }
            return sup;
        }
    }

    class TaskTreeProofTreeListener
    extends ProofTreeAdapter {
        TaskTreeProofTreeListener() {
        }

        public void proofClosed(ProofTreeEvent e) {
            TaskTree.this.delegateView.repaint();
        }

        public void proofGoalRemoved(ProofTreeEvent e) {
        }

        public void proofGoalsAdded(ProofTreeEvent e) {
        }

        public void proofGoalsChanged(ProofTreeEvent e) {
        }
    }

    class TaskTreeMouseListener
    extends MouseAdapter {
        TaskTreeMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TaskTree.this.problemChosen();
            this.checkPopup(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.checkPopup(e);
        }

        private void checkPopup(MouseEvent e) {
            JPopupMenu menu;
            if (e.isPopupTrigger() && (menu = KeYGuiExtensionFacade.createContextMenu(DefaultContextMenuKind.PROOF_LIST, TaskTree.this.mediator.getSelectedProof(), TaskTree.this.mediator)).getComponentCount() > 0) {
                menu.show(TaskTree.this, e.getX(), e.getY());
            }
        }
    }
}

