/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui;

import de.uka.ilkd.key.control.AbstractProofControl;
import de.uka.ilkd.key.control.KeYEnvironment;
import de.uka.ilkd.key.control.TermLabelVisibilityManager;
import de.uka.ilkd.key.control.UserInterfaceControl;
import de.uka.ilkd.key.control.instantiation_model.TacletInstantiationModel;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.AutoDismissDialog;
import de.uka.ilkd.key.gui.BlockContractExternalCompletion;
import de.uka.ilkd.key.gui.BlockContractInternalCompletion;
import de.uka.ilkd.key.gui.DependencyContractCompletion;
import de.uka.ilkd.key.gui.FunctionalOperationContractCompletion;
import de.uka.ilkd.key.gui.InteractiveRuleApplicationCompletion;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.LoopInvariantRuleCompletion;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofManagementDialog;
import de.uka.ilkd.key.gui.ProofScriptWorker;
import de.uka.ilkd.key.gui.TacletMatchCompletionDialog;
import de.uka.ilkd.key.gui.mergerule.MergeRuleCompletion;
import de.uka.ilkd.key.gui.notification.events.GeneralFailureEvent;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.macros.ProofMacroFinishedInfo;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.event.ProofDisposedEvent;
import de.uka.ilkd.key.proof.init.IPersistablePO;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.proof.init.KeYUserProblemFile;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.proof.init.ProofInputException;
import de.uka.ilkd.key.proof.init.ProofOblInput;
import de.uka.ilkd.key.proof.io.AbstractProblemLoader;
import de.uka.ilkd.key.proof.io.GZipProofSaver;
import de.uka.ilkd.key.proof.io.ProblemLoader;
import de.uka.ilkd.key.proof.io.ProblemLoaderException;
import de.uka.ilkd.key.proof.io.ProofBundleSaver;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.prover.ProverCore;
import de.uka.ilkd.key.prover.TaskFinishedInfo;
import de.uka.ilkd.key.prover.TaskStartedInfo;
import de.uka.ilkd.key.prover.impl.ApplyStrategyInfo;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.speclang.PositionedString;
import de.uka.ilkd.key.ui.AbstractMediatorUserInterfaceControl;
import de.uka.ilkd.key.ui.MediatorProofControl;
import de.uka.ilkd.key.util.KeYConstants;
import de.uka.ilkd.key.util.MiscTools;
import de.uka.ilkd.key.util.Pair;
import de.uka.ilkd.key.util.ThreadUtilities;
import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.JOptionPane;
import org.key_project.util.collection.ImmutableSet;

public class WindowUserInterfaceControl
extends AbstractMediatorUserInterfaceControl {
    private final MainWindow mainWindow;
    private final LinkedList<InteractiveRuleApplicationCompletion> completions = new LinkedList();

    public WindowUserInterfaceControl(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.completions.add(new FunctionalOperationContractCompletion());
        this.completions.add(new DependencyContractCompletion());
        this.completions.add(new LoopInvariantRuleCompletion());
        this.completions.add(new BlockContractInternalCompletion(mainWindow));
        this.completions.add(new BlockContractExternalCompletion(mainWindow));
        this.completions.add(MergeRuleCompletion.INSTANCE);
    }

    @Override
    protected MediatorProofControl createProofControl() {
        return new MediatorProofControl(this){

            @Override
            public boolean isAutoModeSupported(Proof proof) {
                return super.isAutoModeSupported(proof) && WindowUserInterfaceControl.this.mainWindow.getProofList().containsProof(proof);
            }
        };
    }

    public void loadProblem(File file, List<File> classPath, File bootClassPath, List<File> includes) {
        this.mainWindow.addRecentFile(file.getAbsolutePath());
        ProblemLoader problemLoader = this.getProblemLoader(file, classPath, bootClassPath, includes, this.getMediator());
        problemLoader.runAsynchronously();
    }

    @Override
    public void loadProblem(File file) {
        this.loadProblem(file, null, null, null);
    }

    @Override
    public void loadProofFromBundle(File proofBundle, File proofFilename) {
        this.mainWindow.addRecentFile(proofBundle.getAbsolutePath());
        ProblemLoader problemLoader = this.getProblemLoader(proofBundle, null, null, null, this.getMediator());
        problemLoader.setProofPath(proofFilename);
        problemLoader.runAsynchronously();
    }

    public void progressStarted(Object sender) {
        this.mainWindow.getMediator().stopInterface(true);
    }

    public void progressStopped(Object sender) {
        this.mainWindow.getMediator().startInterface(true);
    }

    public void reportException(Object sender, ProofOblInput input, Exception e) {
        this.reportStatus(sender, input.name() + " failed");
    }

    public void reportStatus(Object sender, String status, int progress) {
        this.mainWindow.setStatusLine(status, progress);
    }

    public void reportStatus(Object sender, String status) {
        this.mainWindow.setStatusLine(status);
    }

    public void resetStatus(Object sender) {
        this.mainWindow.setStandardStatusLine();
    }

    public void taskFinished(TaskFinishedInfo info) {
        super.taskFinished(info);
        if (info != null && info.getSource() instanceof ProverCore) {
            if (!this.isAtLeastOneMacroRunning()) {
                this.resetStatus((Object)this);
            }
            ApplyStrategyInfo result = (ApplyStrategyInfo)info.getResult();
            Proof proof = info.getProof();
            if (proof != null && !proof.closed() && this.mainWindow.getMediator().getSelectedProof() == proof) {
                Goal g = result.nonCloseableGoal();
                if (g == null) {
                    g = (Goal)proof.openGoals().head();
                }
                this.mainWindow.getMediator().goalChosen(g);
                if (this.inStopAtFirstUncloseableGoalMode(info.getProof())) {
                    AutoDismissDialog dialog = new AutoDismissDialog("Couldn't close Goal Nr. " + g.node().serialNr() + " automatically");
                    dialog.show();
                }
            }
            this.mainWindow.displayResults(info.toString());
        } else if (info != null && info.getSource() instanceof ProofMacro) {
            if (!this.isAtLeastOneMacroRunning()) {
                this.resetStatus((Object)this);
                assert (info instanceof ProofMacroFinishedInfo);
                Proof proof = info.getProof();
                if (proof != null && !proof.closed() && this.mainWindow.getMediator().getSelectedProof() == proof) {
                    Goal g = (Goal)proof.openGoals().head();
                    this.mainWindow.getMediator().goalChosen(g);
                    if (this.inStopAtFirstUncloseableGoalMode(info.getProof())) {
                        AutoDismissDialog dialog = new AutoDismissDialog("Couldn't close Goal Nr. " + g.node().serialNr() + " automatically");
                        dialog.show();
                    }
                }
            }
        } else if (info != null && info.getSource() instanceof ProblemLoader) {
            this.resetStatus((Object)this);
            Throwable result = (Throwable)info.getResult();
            if (info.getResult() != null) {
                IssueDialog.showExceptionDialog(this.mainWindow, result);
            } else if (this.getMediator().getUI().isSaveOnly()) {
                this.mainWindow.displayResults("Finished Saving!");
            } else {
                KeYMediator mediator = this.mainWindow.getMediator();
                mediator.getNotationInfo().refresh(mediator.getServices());
                ProblemLoader problemLoader = (ProblemLoader)((Object)info.getSource());
                if (problemLoader.hasProofScript()) {
                    try {
                        Pair scriptAndLoc = problemLoader.readProofScript();
                        ProofScriptWorker psw = new ProofScriptWorker(this.mainWindow.getMediator(), (String)scriptAndLoc.first, (Location)scriptAndLoc.second);
                        psw.init();
                        psw.execute();
                    }
                    catch (ProofInputException e) {
                        e.printStackTrace();
                    }
                } else if (this.macroChosen()) {
                    this.applyMacro();
                }
            }
        } else {
            this.resetStatus((Object)this);
            if (info != null && !info.toString().isEmpty()) {
                this.mainWindow.displayResults(info.toString());
            }
        }
        Runtime.getRuntime().gc();
    }

    protected boolean inStopAtFirstUncloseableGoalMode(Proof proof) {
        return proof.getSettings().getStrategySettings().getActiveStrategyProperties().getProperty("STOPMODE_OPTIONS_KEY").equals("STOPMODE_NONCLOSE");
    }

    public void taskProgress(int position) {
        super.taskProgress(position);
        this.mainWindow.getStatusLine().setProgress(position);
    }

    public void taskStarted(TaskStartedInfo info) {
        super.taskStarted(info);
        this.mainWindow.setStatusLine(info.getMessage(), info.getSize());
    }

    public void setMaximum(int maximum) {
        this.mainWindow.getStatusLine().setProgressBarMaximum(maximum);
    }

    public void setProgress(int progress) {
        this.mainWindow.getStatusLine().setProgress(progress);
    }

    @Override
    public void notifyAutoModeBeingStarted() {
        this.mainWindow.setCursor(new Cursor(3));
        super.notifyAutoModeBeingStarted();
    }

    @Override
    public void notifyAutomodeStopped() {
        this.mainWindow.setCursor(new Cursor(0));
        super.notifyAutomodeStopped();
    }

    public void completeAndApplyTacletMatch(TacletInstantiationModel[] models, Goal goal) {
        new TacletMatchCompletionDialog(this.mainWindow, models, goal, this.mainWindow.getMediator());
    }

    @Override
    public boolean confirmTaskRemoval(String string) {
        int answer = JOptionPane.showConfirmDialog(MainWindow.getInstance(), string, "Abandon Proof", 0);
        return answer == 0;
    }

    @Override
    public void openExamples() {
        this.mainWindow.openExamples();
    }

    public IBuiltInRuleApp completeBuiltInRuleApp(IBuiltInRuleApp app, Goal goal, boolean forced) {
        if (this.mainWindow.getMediator().isInAutoMode()) {
            return AbstractProofControl.completeBuiltInRuleAppByDefault((IBuiltInRuleApp)app, (Goal)goal, (boolean)forced);
        }
        IBuiltInRuleApp result = app;
        for (InteractiveRuleApplicationCompletion compl : this.completions) {
            if (!compl.canComplete(app)) continue;
            result = compl.complete(app, goal, forced);
            break;
        }
        return result != null && result.complete() ? result : null;
    }

    @Override
    public KeYMediator getMediator() {
        return this.mainWindow.getMediator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractProblemLoader load(Profile profile, File file, List<File> classPath, File bootClassPath, List<File> includes, Properties poPropertiesToForce, boolean forceNewProfileOfNewProofs) throws ProblemLoaderException {
        if (file != null) {
            this.mainWindow.getRecentFiles().addRecentFile(file.getAbsolutePath());
        }
        try {
            this.getMediator().stopInterface(true);
            AbstractProblemLoader abstractProblemLoader = super.load(profile, file, classPath, bootClassPath, includes, poPropertiesToForce, forceNewProfileOfNewProofs);
            return abstractProblemLoader;
        }
        finally {
            this.getMediator().startInterface(true);
        }
    }

    public File saveProof(Proof proof, String fileExtension) {
        MainWindow mainWindow = MainWindow.getInstance();
        KeYFileChooser fc = KeYFileChooser.getFileChooser("Choose filename to save proof");
        fc.setFileFilter(KeYFileChooser.DEFAULT_FILTER);
        Pair<File, String> f = WindowUserInterfaceControl.fileName(proof, fileExtension);
        int result = fc.showSaveDialog(mainWindow, (File)f.first, (String)f.second);
        File file = null;
        if (result == 0) {
            String errorMsg;
            file = fc.getSelectedFile();
            String filename = file.getAbsolutePath();
            Object saver = fc.useCompression() ? new GZipProofSaver(proof, filename, KeYConstants.INTERNAL_VERSION) : new ProofSaver(proof, filename, KeYConstants.INTERNAL_VERSION);
            try {
                errorMsg = saver.save();
            }
            catch (IOException e) {
                errorMsg = e.toString();
            }
            if (errorMsg != null) {
                mainWindow.notify(new GeneralFailureEvent("Saving Proof failed.\n Error: " + errorMsg));
            } else {
                proof.setProofFile(file);
            }
        }
        return file;
    }

    public void saveProofBundle(Proof proof) {
        MainWindow mainWindow = MainWindow.getInstance();
        KeYFileChooser fileChooser = KeYFileChooser.getFileChooser("Choose filename to save proof");
        fileChooser.setFileFilter(KeYFileChooser.PROOF_BUNDLE_FILTER);
        Pair<File, String> f = WindowUserInterfaceControl.fileName(proof, ".zproof");
        int result = fileChooser.showSaveDialog(mainWindow, (File)f.first, (String)f.second);
        if (result == 0) {
            String errorMsg;
            File file = fileChooser.getSelectedFile();
            ProofBundleSaver saver = new ProofBundleSaver(proof, file);
            try {
                errorMsg = saver.save();
            }
            catch (IOException e) {
                errorMsg = e.toString();
            }
            if (errorMsg != null) {
                mainWindow.notify(new GeneralFailureEvent("Saving Proof failed.\n Error: " + errorMsg));
            } else {
                proof.setProofFile(file);
            }
        }
    }

    protected static Pair<File, String> fileName(Proof proof, String fileExtension) {
        Object defaultName;
        KeYFileChooser jFC = KeYFileChooser.getFileChooser("Choose filename to save proof");
        File selectedFile = null;
        if (proof != null) {
            selectedFile = proof.getProofFile();
        }
        if (selectedFile == null) {
            String prefix;
            Object name = proof.name().toString();
            if (((String)name).startsWith(prefix = "Taclet: ")) {
                name = "Taclet:" + ((String)name).substring(prefix.length());
            }
            defaultName = MiscTools.toValidFileName((String)name) + fileExtension;
            selectedFile = new File(jFC.getCurrentDirectory(), (String)defaultName);
        } else if (selectedFile.getName().endsWith(".proof") && fileExtension.equals(".proof")) {
            defaultName = selectedFile.getName();
        } else {
            String proofName = proof.name().toString();
            if (proofName.endsWith(".key")) {
                proofName = proofName.substring(0, proofName.lastIndexOf(".key"));
            } else if (proofName.endsWith(".proof")) {
                proofName = proofName.substring(0, proofName.lastIndexOf(".proof"));
            }
            defaultName = MiscTools.toValidFileName((String)proofName) + fileExtension;
            selectedFile = new File(selectedFile.getParentFile(), (String)defaultName);
        }
        return new Pair((Object)selectedFile, defaultName);
    }

    @Override
    public void proofDisposing(ProofDisposedEvent e) {
        super.proofDisposing(e);
        ThreadUtilities.invokeAndWait(() -> this.mainWindow.getProofList().removeProof(e.getSource()));
    }

    public boolean selectProofObligation(InitConfig initConfig) {
        return ProofManagementDialog.showInstance(initConfig);
    }

    @Override
    public void registerProofAggregate(ProofAggregate pa) {
        super.registerProofAggregate(pa);
        this.mainWindow.addProblem(pa);
        this.mainWindow.setStandardStatusLine();
    }

    public void loadingStarted(AbstractProblemLoader loader) {
        this.getMediator().stopInterface(true);
        super.loadingStarted(loader);
    }

    public void loadingFinished(AbstractProblemLoader loader, IPersistablePO.LoadedPOContainer poContainer, ProofAggregate proofList, AbstractProblemLoader.ReplayResult result) throws ProblemLoaderException {
        super.loadingFinished(loader, poContainer, proofList, result);
        if (proofList != null) {
            this.getMediator().setProof(loader.getProof());
            if (result != null) {
                if ("".equals(result.getStatus())) {
                    this.resetStatus((Object)this);
                } else {
                    this.reportStatus((Object)this, result.getStatus());
                }
                this.getMediator().getSelectionModel().setSelectedNode(result.getNode());
                if (result.hasErrors()) {
                    throw new ProblemLoaderException(loader, "Proof could only be loaded partially.\nIn summary " + result.getErrorList().size() + " not loadable rule application(s) have been detected.\nThe first one:\n" + ((Throwable)result.getErrorList().get(0)).getMessage(), (Throwable)result.getErrorList().get(0));
                }
            } else {
                this.getMediator().getSelectionModel().setSelectedNode(loader.getProof().root());
            }
        }
        this.getMediator().resetNrGoalsClosedByHeuristics();
        if (poContainer != null && poContainer.getProofOblInput() instanceof KeYUserProblemFile) {
            ((KeYUserProblemFile)poContainer.getProofOblInput()).close();
        }
    }

    public static KeYEnvironment<WindowUserInterfaceControl> loadInMainWindow(Profile profile, File location, List<File> classPaths, File bootClassPath, List<File> includes, boolean forceNewProfileOfNewProofs, boolean makeMainWindowVisible) throws ProblemLoaderException {
        MainWindow main = MainWindow.getInstance();
        if (makeMainWindowVisible && !main.isVisible()) {
            main.setVisible(true);
        }
        AbstractProblemLoader loader = main.getUserInterface().load(profile, location, classPaths, bootClassPath, includes, null, forceNewProfileOfNewProofs);
        InitConfig initConfig = loader.getInitConfig();
        return new KeYEnvironment((UserInterfaceControl)main.getUserInterface(), initConfig, loader.getProof(), loader.getProofScript(), loader.getResult());
    }

    @Override
    public void notify(NotificationEvent event) {
        this.mainWindow.notify(event);
    }

    public void reportWarnings(ImmutableSet<PositionedString> warnings) {
        IssueDialog.showWarningsIfNecessary(this.mainWindow, warnings);
    }

    public TermLabelVisibilityManager getTermLabelVisibilityManager() {
        return this.mainWindow.getVisibleTermLabels();
    }
}

