/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.proof.ProofTreeAdapter;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import de.uka.ilkd.key.proof.ProofTreeListener;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.key_project.util.collection.ImmutableList;

public final class AutoModeAction
extends MainWindowAction {
    private static final KeyStroke START_KEY = KeyStroke.getKeyStroke(32, 128);
    private static final KeyStroke STOP_KEY = KeyStroke.getKeyStroke(27, 0);
    private static final long serialVersionUID = -7702898691162947994L;
    final Icon startLogo = IconFactory.autoModeStartLogo(16);
    final Icon stopLogo = IconFactory.autoModeStopLogo(16);
    private Proof associatedProof;
    private final ProofTreeListener ptl = new ProofTreeAdapter(){

        public void proofStructureChanged(ProofTreeEvent e) {
            if (e.getSource() == AutoModeAction.this.associatedProof) {
                AutoModeAction.this.enable();
            }
        }

        public void proofClosed(ProofTreeEvent e) {
            if (e.getSource() == AutoModeAction.this.associatedProof) {
                AutoModeAction.this.enable();
            }
        }

        public void proofGoalsAdded(ProofTreeEvent e) {
            Proof p = e.getSource();
            ImmutableList newGoals = e.getGoals();
            if (newGoals.size() == 0 && !p.closed()) {
                AutoModeAction.this.mainWindow.setStatusLine("1 goal closed, " + p.openGoals().size() + " remaining");
            }
        }
    };

    public AutoModeAction(MainWindow mainWindow) {
        super(mainWindow);
        this.associatedProof = this.getMediator().getSelectedProof();
        this.putValue("hideActionText", Boolean.TRUE);
        this.setName(this.getStartCommand());
        this.setTooltip("Start/stop automated proof search");
        this.setIcon(this.startLogo);
        this.setAcceleratorKey(START_KEY);
        this.enable();
        if (this.associatedProof != null && !this.associatedProof.containsProofTreeListener(this.ptl)) {
            this.associatedProof.addProofTreeListener(this.ptl);
        }
        this.getMediator().addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                if (AutoModeAction.this.associatedProof != null) {
                    AutoModeAction.this.associatedProof.removeProofTreeListener(AutoModeAction.this.ptl);
                }
                AutoModeAction.this.associatedProof = e.getSource().getSelectedProof();
                AutoModeAction.this.enable();
                if (AutoModeAction.this.associatedProof != null) {
                    AutoModeAction.this.associatedProof.addProofTreeListener(AutoModeAction.this.ptl);
                }
            }
        });
        this.getMediator().getUI().getProofControl().addAutoModeListener(new AutoModeListener(){

            public void autoModeStarted(ProofEvent e) {
                if (AutoModeAction.this.associatedProof != null) {
                    AutoModeAction.this.associatedProof.removeProofTreeListener(AutoModeAction.this.ptl);
                }
                AutoModeAction.this.putValue("Name", "Stop");
                AutoModeAction.this.putValue("SmallIcon", AutoModeAction.this.stopLogo);
                AutoModeAction.this.putValue("AcceleratorKey", STOP_KEY);
            }

            public void autoModeStopped(ProofEvent e) {
                if (AutoModeAction.this.associatedProof != null && AutoModeAction.this.associatedProof == e.getSource() && !AutoModeAction.this.associatedProof.containsProofTreeListener(AutoModeAction.this.ptl)) {
                    AutoModeAction.this.associatedProof.addProofTreeListener(AutoModeAction.this.ptl);
                }
                AutoModeAction.this.putValue("Name", AutoModeAction.this.getStartCommand());
                AutoModeAction.this.putValue("SmallIcon", AutoModeAction.this.startLogo);
                AutoModeAction.this.putValue("AcceleratorKey", START_KEY);
            }
        });
    }

    public void enable() {
        this.setEnabled(this.associatedProof != null && !this.associatedProof.closed());
    }

    private String getStartCommand() {
        if (this.associatedProof != null && !this.associatedProof.root().leaf()) {
            return "Continue";
        }
        return "Start";
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getMediator().isInAutoMode()) {
            KeYMediator r = this.getMediator();
            Proof proof = r.getSelectedProof();
            if (r.getUI().getProofControl().isAutoModeSupported(proof)) {
                r.getUI().getProofControl().startAutoMode(proof, proof.openEnabledGoals());
            }
        } else {
            this.getMediator().getUI().getProofControl().stopAndWaitAutoMode();
        }
    }
}

