/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public final class EditMostRecentFileAction
extends MainWindowAction {
    private static final long serialVersionUID = -6214327707255790570L;

    public EditMostRecentFileAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Edit Last Opened File");
        this.setIcon(IconFactory.editFile(16));
        this.setTooltip("Open the last opened file with the default external editor");
        if (!Main.getKeyDesktop().supportsEdit() && !Main.getKeyDesktop().supportsOpen()) {
            this.setEnabled(false);
        }
        this.lookupAcceleratorKey();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String recentFile;
        if (this.mainWindow.getRecentFiles() != null && this.mainWindow.getRecentFiles().getMostRecent() != null && (recentFile = this.mainWindow.getRecentFiles().getMostRecent().getAbsolutePath()) != null) {
            File f = new File(recentFile);
            try {
                EditFileActionHandler.getInstance().workWithFile(f);
            }
            catch (Exception exc) {
                this.setEnabled(false);
            }
        }
    }

    public static class EditFileActionHandler {
        public static EditFileActionHandler instance = new EditFileActionHandler();

        public void workWithFile(File file) throws IOException {
            Main.getKeyDesktop().open(file);
        }

        public static EditFileActionHandler getInstance() {
            return instance;
        }

        public static void setInstance(EditFileActionHandler instance) {
            EditFileActionHandler.instance = instance;
        }
    }
}

