/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.sourceview.JavaDocument;
import de.uka.ilkd.key.gui.sourceview.TextLineNumber;
import de.uka.ilkd.key.parser.Location;
import de.uka.ilkd.key.util.ExceptionTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nullable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.key_project.util.java.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSourceFileAction
extends KeyAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditSourceFileAction.class);
    private static final String READONLY_TOOLTIP = "The resource is readonly, probably the URL points into a zip/jar archive!";
    private static final int SYNTAX_HIGHLIGHTING_REFRESH_INTERVAL = 800;
    private final Window parent;
    private final Throwable exception;

    public EditSourceFileAction(Window parent, Throwable exception) {
        this.setName("Edit File");
        this.setIcon(IconFactory.editFile(16));
        this.parent = parent;
        this.exception = exception;
        this.setEnabled(exception != null);
    }

    private static void textAreaGoto(JTextComponent textArea, int line, int col) {
        int i;
        String text = textArea.getText();
        for (i = 0; i < text.length() && line > 1; ++i) {
            if (text.charAt(i) != '\n') continue;
            --line;
        }
        if ((i += col - 1) > textArea.getDocument().getLength()) {
            i = textArea.getDocument().getLength();
        }
        textArea.setCaretPosition(i);
    }

    private static JScrollPane createParserMessageScrollPane(Throwable exception, int columnNumber) {
        JTextArea parserMessage = new JTextArea();
        String message = exception.getMessage();
        message = message == null ? "" : message;
        parserMessage.setText(message);
        parserMessage.setEditable(false);
        parserMessage.setColumns(columnNumber);
        parserMessage.setRows(message.length() / (columnNumber - 10));
        parserMessage.setLineWrap(true);
        parserMessage.setWrapStyleWord(true);
        parserMessage.setBorder(new TitledBorder("Parser Message"));
        JScrollPane parserMessageScrollPane = new JScrollPane(parserMessage);
        parserMessageScrollPane.setVerticalScrollBarPolicy(20);
        parserMessageScrollPane.setHorizontalScrollBarPolicy(30);
        return parserMessageScrollPane;
    }

    private JTextPane createSrcTextPane(final Location location) throws IOException {
        final JTextPane textPane = new JTextPane(){

            @Override
            public void addNotify() {
                super.addNotify();
                this.requestFocus();
                EditSourceFileAction.textAreaGoto(this, location.getLine(), location.getColumn());
            }
        };
        String source = IOUtil.readFrom((URL)location.getFileURL());
        source = source.replace("\r", "");
        if (location.getFileURL().toString().endsWith(".java")) {
            JavaDocument doc = new JavaDocument();
            try {
                doc.insertString(0, source, new SimpleAttributeSet());
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            textPane.setDocument(doc);
            textPane.addKeyListener(new KeyAdapter(){
                private Timer timer = new Timer();

                @Override
                public void keyTyped(KeyEvent e) {
                    this.restartTimer();
                }

                private void restartTimer() {
                    this.timer.cancel();
                    this.timer = new Timer();
                    TimerTask task = new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            JTextPane jTextPane = textPane;
                            synchronized (jTextPane) {
                                int pos = textPane.getCaretPosition();
                                int start = textPane.getSelectionStart();
                                int end = textPane.getSelectionEnd();
                                String content = textPane.getText();
                                try {
                                    JavaDocument newDoc = new JavaDocument();
                                    newDoc.insertString(0, content, new SimpleAttributeSet());
                                    textPane.setDocument(newDoc);
                                    textPane.setCaretPosition(pos);
                                    textPane.setSelectionStart(start);
                                    textPane.setSelectionEnd(end);
                                }
                                catch (BadLocationException ex) {
                                    ex.printStackTrace();
                                }
                                textPane.repaint();
                            }
                        }
                    };
                    this.timer.schedule(task, 800L);
                }
            });
        } else {
            textPane.setText(source);
        }
        Font font = UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW");
        if (font == null) {
            font = new Font("Monospaced", 0, 12);
        }
        textPane.setFont(font);
        return textPane;
    }

    @Nullable
    private static File tryGetFile(@Nullable URL sourceURL) {
        File sourceFile = null;
        if (sourceURL != null && sourceURL.getProtocol().equals("file")) {
            try {
                sourceFile = Paths.get(sourceURL.toURI()).toFile();
            }
            catch (URISyntaxException e) {
                LOGGER.debug("Exception", (Throwable)e);
            }
        }
        return sourceFile;
    }

    private JPanel createButtonPanel(URL sourceURL, JTextPane textPane, JDialog dialog) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        JButton saveButton = new JButton("Save");
        JButton reloadButton = new JButton("Save, Close and Reload");
        JButton cancelButton = new JButton("Cancel");
        ActionListener closeAction = event -> dialog.dispose();
        cancelButton.addActionListener(closeAction);
        File sourceFile = EditSourceFileAction.tryGetFile(sourceURL);
        if (sourceFile == null) {
            saveButton.setEnabled(false);
            reloadButton.setEnabled(false);
            textPane.setEditable(false);
            saveButton.setToolTipText(READONLY_TOOLTIP);
            reloadButton.setToolTipText(READONLY_TOOLTIP);
            textPane.setToolTipText(READONLY_TOOLTIP);
        } else {
            ActionListener saveAction = event -> {
                try {
                    String text = textPane.getText().replace("\n", System.lineSeparator());
                    Files.write(sourceFile.toPath(), text.getBytes(), new OpenOption[0]);
                }
                catch (IOException ioe) {
                    String message = "Cannot write to file:\n" + ioe.getMessage();
                    JOptionPane.showMessageDialog(this.parent, message);
                }
            };
            ActionListener reloadAction = event -> {
                this.parent.setVisible(false);
                MainWindow.getInstance().loadProblem(sourceFile);
            };
            saveButton.addActionListener(saveAction);
            reloadButton.addActionListener(event -> {
                saveAction.actionPerformed(event);
                closeAction.actionPerformed(event);
                reloadAction.actionPerformed(event);
            });
        }
        buttonPanel.add(saveButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(reloadButton);
        return buttonPanel;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.exception == null) {
            JOptionPane.showMessageDialog(SwingUtilities.windowForComponent((Component)arg0.getSource()), "The given exception does not carry any positional information.", "Position not available", 0);
            return;
        }
        try {
            Location location = ExceptionTools.getLocation((Throwable)this.exception);
            if (!Location.isValidLocation((Location)location)) {
                throw new IOException("Cannot recover file location from exception.");
            }
            String prefix = EditSourceFileAction.tryGetFile(location.getFileURL()) != null ? "Edit " : "[Readonly] ";
            JDialog dialog = new JDialog(this.parent, prefix + location.getFileURL(), Dialog.ModalityType.DOCUMENT_MODAL);
            dialog.setDefaultCloseOperation(2);
            int columnNumber = 75;
            JScrollPane parserMessageScrollPane = EditSourceFileAction.createParserMessageScrollPane(this.exception, 75);
            JTextPane txtSource = this.createSrcTextPane(location);
            JPanel nowrap = new JPanel(new BorderLayout());
            nowrap.add(txtSource);
            JScrollPane sourceScrollPane = new JScrollPane();
            sourceScrollPane.setViewportView(nowrap);
            sourceScrollPane.getVerticalScrollBar().setUnitIncrement(30);
            sourceScrollPane.getHorizontalScrollBar().setUnitIncrement(30);
            sourceScrollPane.setBorder(new TitledBorder(location.getFileURL().toString()));
            TextLineNumber lineNumbers = new TextLineNumber(txtSource, 2);
            sourceScrollPane.setRowHeaderView(lineNumbers);
            sourceScrollPane.setVerticalScrollBarPolicy(20);
            sourceScrollPane.setHorizontalScrollBarPolicy(30);
            JPanel buttonPanel = this.createButtonPanel(location.getFileURL(), txtSource, dialog);
            Container container = dialog.getContentPane();
            JSplitPane splitPane = new JSplitPane(0);
            splitPane.setTopComponent(parserMessageScrollPane);
            splitPane.setBottomComponent(sourceScrollPane);
            container.add((Component)splitPane, "Center");
            container.add((Component)buttonPanel, "South");
            dialog.pack();
            int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width - 25;
            int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height - 25;
            int width = Math.min(dialog.getWidth(), screenWidth);
            int height = Math.min(dialog.getHeight(), screenHeight);
            dialog.setSize(width, height);
            dialog.setLocationRelativeTo(this.parent);
            dialog.setVisible(true);
        }
        catch (IOException ioe) {
            String message = "Cannot open file:\n" + ioe.getMessage();
            JOptionPane.showMessageDialog(this.parent, message);
        }
    }
}

