/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.settings.PathConfig;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.EventObject;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExitMainAction
extends MainWindowAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExitMainAction.class);
    public static boolean exitSystem = true;
    private static final long serialVersionUID = 5881706859613947592L;
    public final WindowListener windowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            ExitMainAction.this.exitMain();
        }
    };

    public ExitMainAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Exit");
        this.setIcon(IconFactory.quit(16));
        this.setTooltip("Leave KeY.");
        this.setAcceleratorLetter(81);
        this.lookupAcceleratorKey();
    }

    protected void exitMain() {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        if (vs.confirmExit()) {
            int option = JOptionPane.showConfirmDialog(this.mainWindow, "Really Quit?\n", "Exit", 0);
            if (option == 0) {
                this.exitMainWithoutInteraction();
            }
        } else {
            this.exitMainWithoutInteraction();
        }
    }

    public void saveSettings() {
        this.mainWindow.savePreferences(this.mainWindow);
        this.mainWindow.syncPreferences();
    }

    public void exitMainWithoutInteraction() {
        this.mainWindow.getRecentFiles().store(PathConfig.getRecentFileStorage());
        this.getMediator().fireShutDown(new EventObject(this));
        LOGGER.info("Have a nice day.");
        this.saveSettings();
        if (exitSystem) {
            System.exit(0);
        } else {
            this.mainWindow.setVisible(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exitMain();
    }
}

