/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeManager;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.settings.GeneralSettings;
import java.awt.event.ActionEvent;
import org.key_project.util.collection.ImmutableList;

public final class GoalBackAction
extends MainWindowAction {
    private static final long serialVersionUID = 4574670781882014062L;
    private boolean longName = false;

    public GoalBackAction(MainWindow mainWindow, boolean longName) {
        super(mainWindow);
        this.longName = longName;
        this.putValue("SmallIcon", IconFactory.goalBackLogo(16));
        this.putValue("ShortDescription", "Undo the last rule application.");
        this.initListeners();
        this.updateName();
        this.setAcceleratorLetter(90);
        KeyStrokeManager.lookupAndOverride(this);
    }

    public void initListeners() {
        final KeYSelectionListener selListener = new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
                Proof proof = GoalBackAction.this.getMediator().getSelectedProof();
                if (proof == null) {
                    GoalBackAction.this.setEnabled(false);
                } else {
                    Node selNode = GoalBackAction.this.getMediator().getSelectedNode();
                    GoalBackAction.this.setEnabled(selNode != null && !proof.root().leaf() && (!GeneralSettings.noPruningClosed || !selNode.isClosed()));
                }
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                this.selectedNodeChanged(e);
            }
        };
        this.getMediator().addKeYSelectionListener(selListener);
        this.getMediator().getUI().getProofControl().addAutoModeListener(new AutoModeListener(){

            public void autoModeStarted(ProofEvent e) {
                GoalBackAction.this.getMediator().removeKeYSelectionListener(selListener);
                GoalBackAction.this.setEnabled(false);
            }

            public void autoModeStopped(ProofEvent e) {
                GoalBackAction.this.getMediator().addKeYSelectionListener(selListener);
                selListener.selectedNodeChanged(null);
            }
        });
        selListener.selectedNodeChanged(new KeYSelectionEvent(this.getMediator().getSelectionModel()));
    }

    public void updateName() {
        RuleApp app;
        Goal goal;
        Object appliedRule = "";
        if (this.longName && this.getMediator() != null && (goal = this.findNewestGoal(this.getMediator().getSelectedNode())) != null && goal.node() != null && goal.node().parent() != null && (app = goal.node().parent().getAppliedRuleApp()) != null) {
            appliedRule = " (" + app.rule().displayName() + ")";
        }
        this.putValue("Name", "Undo Last Rule Application" + (String)appliedRule);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Node selNode = this.getMediator().getSelectedNode();
        Goal selGoal = this.getMediator().getSelectedGoal();
        if (selGoal == null && selNode != null) {
            selGoal = this.findNewestGoal(selNode);
        }
        if (selGoal != null) {
            this.getMediator().setBack(selGoal);
            this.getMediator().getSelectionModel().setSelectedNode(selGoal.node());
        }
    }

    private Goal findNewestGoal(Node subtree) {
        if (subtree == null) {
            return null;
        }
        Proof proof = subtree.proof();
        ImmutableList closedGoals = proof.getClosedSubtreeGoals(subtree);
        ImmutableList openGoals = proof.getSubtreeGoals(subtree);
        int closedID = -1;
        Goal closed = null;
        int openID = -1;
        Goal open = null;
        for (Goal g : closedGoals) {
            if (g.node().serialNr() <= closedID) continue;
            closedID = g.node().serialNr();
            closed = g;
        }
        for (Goal g : openGoals) {
            if (g.node().serialNr() <= openID) continue;
            openID = g.node().serialNr();
            open = g;
        }
        return closedID > openID ? closed : open;
    }
}

