/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import de.uka.ilkd.key.settings.ViewSettings;
import java.awt.event.ActionEvent;
import javax.swing.Icon;

public class HeatmapToggleAction
extends MainWindowAction {
    private static final long serialVersionUID = 1L;
    public static final Icon ICON_SELECTED = IconFactory.HEATMAP_DEACTIVATE.get();
    public static final Icon ICON_NOT_SELECTED = IconFactory.HEATMAP_ACTIVATE.get();

    public HeatmapToggleAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Toggle Heatmap");
        this.setMenuPath("View.Heatmap");
        this.setEnabled(this.getMediator().getSelectedProof() != null);
        this.putValue("LongDescription", "Enable or disable age heatmaps in the sequent view.");
        this.setIcon();
        this.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("SwingSelectedKey")) {
                this.setIcon();
            }
        });
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        this.setSelected(vs.isShowHeatmap());
        SettingsListener setListener = e -> this.setSelected(vs.isShowHeatmap());
        vs.addSettingsListener(setListener);
        KeYSelectionListener selListener = new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
                Proof proof = HeatmapToggleAction.this.getMediator().getSelectedProof();
                HeatmapToggleAction.this.setEnabled(proof != null);
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                this.selectedNodeChanged(e);
            }
        };
        this.getMediator().addKeYSelectionListener(selListener);
    }

    private void setIcon() {
        this.setIcon(this.isSelected() ? ICON_SELECTED : ICON_NOT_SELECTED);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ViewSettings vs;
        vs.setHeatmapOptions(!(vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings()).isShowHeatmap(), vs.isHeatmapSF(), vs.isHeatmapNewest(), vs.getMaxAgeForHeatmap());
    }
}

