/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;

public final class HidePackagePrefixToggleAction
extends MainWindowAction {
    public static final String NAME = "Hide Package Prefix";
    public static final String TOOL_TIP = "If ticked, class names are written without package prefixes.";
    private static final long serialVersionUID = 3184733794964047845L;
    private final SettingsListener viewSettingsListener = new SettingsListener(){

        public void settingsChanged(EventObject e) {
            HidePackagePrefixToggleAction.this.handleViewSettingsChanged(e);
        }
    };

    public HidePackagePrefixToggleAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName(NAME);
        this.setTooltip(TOOL_TIP);
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().addSettingsListener(this.viewSettingsListener);
        this.updateSelectedState();
    }

    protected void updateSelectedState() {
        boolean hidePackage;
        NotationInfo.DEFAULT_HIDE_PACKAGE_PREFIX = hidePackage = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isHidePackagePrefix();
        this.setSelected(hidePackage);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selected;
        NotationInfo.DEFAULT_HIDE_PACKAGE_PREFIX = selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setHidePackagePrefix(selected);
        this.updateMainWindow();
    }

    protected void updateMainWindow() {
        this.mainWindow.makePrettyView();
    }

    protected void handleViewSettingsChanged(EventObject e) {
        this.updateSelectedState();
        this.updateMainWindow();
    }
}

