/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.lemmatagenerator.LemmaSelectionDialog;
import de.uka.ilkd.key.gui.lemmatagenerator.LoadUserTacletsDialog;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofAggregate;
import de.uka.ilkd.key.proof.init.ProblemInitializer;
import de.uka.ilkd.key.proof.init.Profile;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.inst.SVInstantiations;
import de.uka.ilkd.key.taclettranslation.lemma.TacletLoader;
import de.uka.ilkd.key.taclettranslation.lemma.TacletSoundnessPOLoader;
import de.uka.ilkd.key.util.ProgressMonitor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.SwingUtilities;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSet;

public abstract class LemmaGenerationAction
extends MainWindowAction {
    private static final long serialVersionUID = 1L;

    public LemmaGenerationAction(MainWindow mainWindow) {
        super(mainWindow);
        this.putValue("Name", this.getTitle());
        this.putValue("ShortDescription", this.getDescription());
        if (this.proofIsRequired()) {
            this.getMediator().enableWhenProofLoaded(this);
        }
    }

    protected abstract void loadTaclets();

    protected abstract String getTitle();

    protected abstract String getDescription();

    protected abstract boolean proofIsRequired();

    protected final void handleException(Throwable exception) {
        IssueDialog.showExceptionDialog(this.mainWindow, exception);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            this.loadTaclets();
        }
        catch (Throwable exception) {
            this.handleException(exception);
        }
    }

    public static class ProveAndAddTaclets
    extends LemmaGenerationAction {
        private static final long serialVersionUID = 1L;

        public ProveAndAddTaclets(MainWindow mainWindow) {
            super(mainWindow);
        }

        @Override
        protected void loadTaclets() {
            LoadUserTacletsDialog chooser = new LoadUserTacletsDialog(LoadUserTacletsDialog.Mode.LOAD);
            boolean loaded = chooser.showAsDialog();
            if (!loaded) {
                return;
            }
            final Proof proof = this.getMediator().getSelectedProof();
            File fileForLemmata = chooser.getFileForTaclets();
            boolean loadAsLemmata = chooser.isGenerateProofObligations();
            List<File> filesForAxioms = chooser.getFilesForAxioms();
            ProblemInitializer problemInitializer = new ProblemInitializer((ProgressMonitor)this.mainWindow.getUserInterface(), new Services(proof.getServices().getProfile()), (ProblemInitializer.ProblemInitializerListener)this.mainWindow.getUserInterface());
            TacletLoader.TacletFromFileLoader tacletLoader = new TacletLoader.TacletFromFileLoader((ProgressMonitor)this.mainWindow.getUserInterface(), (ProblemInitializer.ProblemInitializerListener)this.mainWindow.getUserInterface(), problemInitializer, fileForLemmata, filesForAxioms, proof.getInitConfig().copy());
            AbstractLoaderListener listener = new AbstractLoaderListener(this.mainWindow){

                @Override
                public void doStopped(Throwable exception) {
                    IssueDialog.showExceptionDialog(mainWindow, exception);
                }

                @Override
                public void doStopped(ProofAggregate p, ImmutableSet<Taclet> taclets, boolean addAxioms) {
                    this.getMediator().startInterface(true);
                    if (p != null) {
                        mainWindow.getUserInterface().registerProofAggregate(p);
                    }
                    if (p != null || addAxioms) {
                        ImmutableList base = proof.getInitConfig().getTaclets();
                        base = base.prependReverse(taclets);
                        proof.getInitConfig().setTaclets(base);
                        for (Taclet taclet : taclets) {
                            for (Goal goal : proof.openGoals()) {
                                goal.addTaclet(taclet, SVInstantiations.EMPTY_SVINSTANTIATIONS, false);
                            }
                        }
                    }
                }
            };
            TacletSoundnessPOLoader loader = new TacletSoundnessPOLoader((TacletSoundnessPOLoader.LoaderListener)listener, (TacletSoundnessPOLoader.TacletFilter)new LemmaSelectionDialog(), loadAsLemmata, (TacletLoader)tacletLoader, proof.getInitConfig(), false);
            loader.start();
        }

        @Override
        protected String getTitle() {
            return "Load User-Defined Taclets...";
        }

        @Override
        protected String getDescription() {
            return "Loads additional taclets and creates the corresponding proof.";
        }

        @Override
        protected boolean proofIsRequired() {
            return true;
        }
    }

    public static class ProveUserDefinedTaclets
    extends LemmaGenerationAction {
        private static final long serialVersionUID = 1L;
        private LoadUserTacletsDialog chooser;

        public ProveUserDefinedTaclets(MainWindow mainWindow) {
            super(mainWindow);
        }

        @Override
        protected void loadTaclets() {
            boolean loaded;
            if (this.chooser == null) {
                this.chooser = new LoadUserTacletsDialog(LoadUserTacletsDialog.Mode.PROVE);
            }
            if (!(loaded = this.chooser.showAsDialog())) {
                return;
            }
            File fileForLemmata = this.chooser.getFileForTaclets();
            boolean loadAsLemmata = this.chooser.isGenerateProofObligations();
            List<File> filesForAxioms = this.chooser.getFilesForAxioms();
            Profile profile = this.mainWindow.getMediator().getProfile();
            ProblemInitializer problemInitializer = new ProblemInitializer((ProgressMonitor)this.mainWindow.getUserInterface(), new Services(profile), (ProblemInitializer.ProblemInitializerListener)this.mainWindow.getUserInterface());
            TacletLoader.TacletFromFileLoader tacletLoader = new TacletLoader.TacletFromFileLoader((ProgressMonitor)this.mainWindow.getUserInterface(), (ProblemInitializer.ProblemInitializerListener)this.mainWindow.getUserInterface(), problemInitializer, profile, fileForLemmata, filesForAxioms);
            AbstractLoaderListener listener = new AbstractLoaderListener(this.mainWindow){

                @Override
                public void doStopped(Throwable exception) {
                    IssueDialog.showExceptionDialog(mainWindow, exception);
                }

                @Override
                public void doStopped(ProofAggregate p, ImmutableSet<Taclet> taclets, boolean addAxioms) {
                    this.getMediator().startInterface(true);
                    if (p != null) {
                        mainWindow.getUserInterface().registerProofAggregate(p);
                    }
                }
            };
            TacletSoundnessPOLoader loader = new TacletSoundnessPOLoader((TacletSoundnessPOLoader.LoaderListener)listener, (TacletSoundnessPOLoader.TacletFilter)new LemmaSelectionDialog(), loadAsLemmata, (TacletLoader)tacletLoader, tacletLoader.getProofEnvForTaclets().getInitConfigForEnvironment(), true);
            loader.start();
        }

        @Override
        protected String getTitle() {
            return "User-Defined Taclets...";
        }

        @Override
        protected String getDescription() {
            return "Loads user-defined taclets and creates the corresponding proof obligations.";
        }

        @Override
        protected boolean proofIsRequired() {
            return false;
        }
    }

    public static class ProveKeYTaclets
    extends LemmaGenerationAction {
        private static final long serialVersionUID = 1L;

        public ProveKeYTaclets(MainWindow mainWindow) {
            super(mainWindow);
        }

        @Override
        protected void loadTaclets() {
            TacletLoader.KeYsTacletsLoader tacletLoader = new TacletLoader.KeYsTacletsLoader((ProgressMonitor)this.mainWindow.getUserInterface(), (ProblemInitializer.ProblemInitializerListener)this.mainWindow.getUserInterface(), this.mainWindow.getMediator().getProfile());
            AbstractLoaderListener listener = new AbstractLoaderListener(this.mainWindow){

                @Override
                public void doStopped(Throwable exception) {
                    IssueDialog.showExceptionDialog(mainWindow, exception);
                }

                @Override
                public void doStopped(ProofAggregate p, ImmutableSet<Taclet> taclets, boolean addAxioms) {
                    this.getMediator().startInterface(true);
                    if (p != null) {
                        mainWindow.getUserInterface().registerProofAggregate(p);
                    }
                }
            };
            TacletSoundnessPOLoader loader = new TacletSoundnessPOLoader((TacletSoundnessPOLoader.LoaderListener)listener, (TacletSoundnessPOLoader.TacletFilter)new LemmaSelectionDialog(), true, (TacletLoader)tacletLoader, tacletLoader.getProofEnvForTaclets().getInitConfigForEnvironment(), true);
            loader.start();
        }

        @Override
        protected String getTitle() {
            return "KeY's Taclets...";
        }

        @Override
        protected String getDescription() {
            return "Creates a proof obligation for some selected taclets.";
        }

        @Override
        protected boolean proofIsRequired() {
            return false;
        }
    }

    private static abstract class AbstractLoaderListener
    implements TacletSoundnessPOLoader.LoaderListener {
        private final MainWindow mainWindow;

        private AbstractLoaderListener(MainWindow mainWindow) {
            this.mainWindow = mainWindow;
        }

        public void started() {
            this.mainWindow.getMediator().stopInterface(true);
        }

        public void progressStarted(Object sender) {
            this.mainWindow.getUserInterface().progressStarted(sender);
        }

        public void reportStatus(Object sender, String status) {
            this.mainWindow.getUserInterface().reportStatus(sender, status);
        }

        public void resetStatus(Object sender) {
            this.mainWindow.getUserInterface().resetStatus(sender);
        }

        public final void stopped(final ProofAggregate p, final ImmutableSet<Taclet> taclets, final boolean addAsAxioms) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.doStopped(p, (ImmutableSet<Taclet>)taclets, addAsAxioms);
                }
            });
        }

        protected abstract void doStopped(ProofAggregate var1, ImmutableSet<Taclet> var2, boolean var3);

        public final void stopped(final Throwable exception) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    this.doStopped(exception);
                }
            });
        }

        protected abstract void doStopped(Throwable var1);
    }

    public static enum Mode {
        ProveUserDefinedTaclets,
        ProveKeYTaclets,
        ProveAndAddUserDefinedTaclets;

    }
}

