/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.util.KeYResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class LicenseAction
extends MainWindowAction {
    public static final String KEY_FALLBACK = "\u00a9 Copyright 2001\u20132021 Karlsruhe Institute of Technology, Chalmers University of Technology, and Technische Universit\u00e4t Darmstadt\nKeY is protected by the GNU General Public License v2";
    private static final long serialVersionUID = 5606343347731759150L;

    public LicenseAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("License");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showLicense();
    }

    private JComponent createLicenseViewer(String s) {
        JTextArea text = new JTextArea(s, 20, 40);
        text.setEditable(false);
        text.setCaretPosition(0);
        JScrollPane scroll = new JScrollPane(text);
        return scroll;
    }

    private String readStream(URL resource, String fallback) {
        StringBuffer sb = new StringBuffer();
        try {
            int c;
            InputStreamReader inp = new InputStreamReader(resource.openStream(), "UTF-8");
            char[] buf = new char[1024];
            while ((c = inp.read(buf)) > 0) {
                sb.append(buf, 0, c);
            }
            inp.close();
        }
        catch (IOException ioe) {
            return fallback;
        }
        return sb.toString();
    }

    public void showLicense() {
        URL lic = KeYResourceManager.getManager().getResourceFile(MainWindow.class, "LICENSE.TXT");
        URL thirdPartyLic = KeYResourceManager.getManager().getResourceFile(MainWindow.class, "THIRD_PARTY_LICENSES.txt");
        JDialog fr = new JDialog((Frame)this.mainWindow, "KeY License");
        fr.getContentPane().setLayout(new BorderLayout());
        JTabbedPane pane = new JTabbedPane();
        fr.add(pane);
        pane.addTab("KeY License", this.createLicenseViewer(this.readStream(lic, KEY_FALLBACK)));
        pane.addTab("Third party libraries", this.createLicenseViewer(this.readStream(thirdPartyLic, "")));
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> ((JDialog)((JButton)e.getSource()).getTopLevelAncestor()).dispose());
        fr.getContentPane().add((Component)okButton, "South");
        fr.setDefaultCloseOperation(2);
        fr.setSize(600, 900);
        fr.setLocationRelativeTo(this.mainWindow);
        fr.setVisible(true);
    }
}

