/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.ProofMacroMenu;
import de.uka.ilkd.key.gui.keyshortcuts.KeyStrokeManager;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.macros.ProofMacro;
import de.uka.ilkd.key.pp.PosInSequent;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class MacroKeyBinding
extends AbstractAction {
    private static final long serialVersionUID = 1529344940571000989L;
    private final SequentView sequentView;
    private final KeYMediator mediator;
    private final ProofMacro macro;

    public MacroKeyBinding(KeYMediator mediator, SequentView sequentView, ProofMacro macro) {
        super("Invoking macro " + macro.getClass());
        this.sequentView = sequentView;
        this.mediator = mediator;
        this.macro = macro;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PosInSequent mousePos;
        boolean isGoal;
        PosInOccurrence posInOcc = null;
        boolean bl = isGoal = this.mediator.getSelectedGoal() != null;
        if (isGoal && (mousePos = this.sequentView.getLastPosInSequent()) != null) {
            posInOcc = mousePos.getPosInOccurrence();
        }
        if (this.macro.canApplyTo(this.mediator.getSelectedNode(), posInOcc)) {
            this.mediator.getUI().getProofControl().runMacro(this.mediator.getSelectedNode(), this.macro, posInOcc);
        }
    }

    public static void registerMacroKeyBindings(KeYMediator mediator, SequentView sequentView, JComponent comp) {
        for (ProofMacro macro : ProofMacroMenu.REGISTERED_MACROS) {
            KeyStroke ks = KeyStrokeManager.get(macro);
            if (ks == null) continue;
            String command = "invoke macro " + macro.getClass();
            comp.getInputMap(1).put(ks, command);
            comp.getActionMap().put(command, new MacroKeyBinding(mediator, sequentView, macro));
        }
    }
}

