/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeYMenuCheckBox;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import java.util.EventObject;

public class MinimizeInteraction
extends KeYMenuCheckBox {
    public static final String NAME = "Minimize Interaction";
    public static final String TOOL_TIP = "If ticked and automated strategy (play button) is used, the prover tries to minimize user interaction, e.g., if the prover can find instantiations by itself, it will not ask the user to provide them.";
    private static final long serialVersionUID = -3381517803006651928L;
    private final MainWindow mainWindow;
    private final SettingsListener generalSettingsListener = new SettingsListener(){

        public void settingsChanged(EventObject e) {
            MinimizeInteraction.this.handleGeneralSettingsChanged(e);
        }
    };

    public MinimizeInteraction(MainWindow mainWindow) {
        super(mainWindow, NAME);
        this.mainWindow = mainWindow;
        this.setName("MinimizeInteractionInstance");
        this.setTooltip(TOOL_TIP);
        ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().addSettingsListener(this.generalSettingsListener);
        this.updateSelectedState();
    }

    protected void updateSelectedState() {
        this.setSelected(ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().tacletFilter());
    }

    @Override
    public void handleClickEvent() {
        boolean tacletFilter = this.isSelected();
        this.updateMainWindow(tacletFilter);
        ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().setTacletFilter(tacletFilter);
    }

    protected void updateMainWindow(boolean b) {
        this.mainWindow.getUserInterface().getProofControl().setMinimizeInteraction(b);
    }

    protected void handleGeneralSettingsChanged(EventObject e) {
        this.updateSelectedState();
        boolean tacletFilter = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings().tacletFilter();
        this.updateMainWindow(tacletFilter);
    }
}

