/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofSelectionDialog;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public class OpenFileAction
extends MainWindowAction {
    private static final long serialVersionUID = -8548805965130100236L;

    public OpenFileAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Load...");
        this.setIcon(IconFactory.openKeYFile(16));
        this.setTooltip("Browse and load problem or proof files.");
        this.setAcceleratorLetter(79);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeYFileChooser fc = KeYFileChooser.getFileChooser("Select file to load proof or problem");
        fc.setFileFilter(KeYFileChooser.DEFAULT_FILTER);
        int result = fc.showOpenDialog(this.mainWindow);
        if (result == 0) {
            File file = fc.getSelectedFile();
            if (ProofSelectionDialog.isProofBundle(file.toPath())) {
                Path proofPath = ProofSelectionDialog.chooseProofToLoad(file.toPath());
                if (proofPath == null) {
                    return;
                }
                this.mainWindow.loadProofFromBundle(file, proofPath.toFile());
                return;
            }
            if (ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getNotifyLoadBehaviour() && file.toString().endsWith(".java")) {
                JCheckBox checkbox = new JCheckBox("Don't show this warning again");
                Object[] message = new Object[]{"When you load a Java file, all java files in the current", "directory and all subdirectories will be loaded as well.", checkbox};
                JOptionPane.showMessageDialog(this.mainWindow, message, "Please note", 2);
                ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setNotifyLoadBehaviour(!checkbox.isSelected());
                ProofIndependentSettings.DEFAULT_INSTANCE.saveSettings();
            }
            this.mainWindow.loadProblem(file);
        }
    }
}

