/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofSelectionDialog;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Path;

public final class OpenMostRecentFileAction
extends MainWindowAction {
    private static final long serialVersionUID = 4855372503837208313L;

    public OpenMostRecentFileAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Reload");
        this.setIcon(IconFactory.openMostRecent(16));
        this.setTooltip("Reload last opened file.");
        this.setAcceleratorLetter(82);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String recentFile;
        if (this.mainWindow.getRecentFiles() != null && this.mainWindow.getRecentFiles().getMostRecent() != null && (recentFile = this.mainWindow.getRecentFiles().getMostRecent().getAbsolutePath()) != null) {
            File file = new File(recentFile);
            KeYFileChooser.getFileChooser("Select file to load").setSelectedFile(file);
            if (ProofSelectionDialog.isProofBundle(file.toPath())) {
                Path proofPath = ProofSelectionDialog.chooseProofToLoad(file.toPath());
                if (proofPath == null) {
                    return;
                }
                this.mainWindow.loadProofFromBundle(file, proofPath.toFile());
            } else {
                this.mainWindow.loadProblem(file);
            }
        }
    }
}

