/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.WindowUserInterfaceControl;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.proof.io.ProblemLoader;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Collections;
import javax.swing.KeyStroke;

public class OpenSingleJavaFileAction
extends MainWindowAction {
    public OpenSingleJavaFileAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Open Single Java File...");
        this.setTooltip("Browse and load a single Java file without classpath.");
        this.setAcceleratorKey(KeyStroke.getKeyStroke(79, 128));
        this.lookupAcceleratorKey();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        KeYFileChooser fc = KeYFileChooser.getFileChooser("Select a Java file");
        fc.setFileFilter(KeYFileChooser.JAVA_FILTER);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(0);
        int result = fc.showOpenDialog(this.mainWindow);
        if (result == 0) {
            File file = fc.getSelectedFile();
            this.mainWindow.addRecentFile(file.getAbsolutePath());
            WindowUserInterfaceControl ui = this.mainWindow.getUserInterface();
            ProblemLoader pl = ui.getProblemLoader(file, Collections.emptyList(), null, Collections.emptyList(), ui.getMediator());
            pl.setLoadSingleJavaFile(true);
            pl.runAsynchronously();
        }
    }
}

