/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.SettingsListener;
import java.awt.event.ActionEvent;
import java.util.EventObject;
import javax.swing.JCheckBoxMenuItem;

public class PrettyPrintToggleAction
extends MainWindowAction {
    public static final String NAME = "Use Pretty Syntax";
    public static final String TOOL_TIP = "If ticked, infix notations are used.";
    private static final long serialVersionUID = 8633254204256247698L;
    private final SettingsListener viewSettingsListener = new SettingsListener(){

        public void settingsChanged(EventObject e) {
            PrettyPrintToggleAction.this.handleViewSettingsChanged(e);
        }
    };

    public PrettyPrintToggleAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName(NAME);
        this.setTooltip(TOOL_TIP);
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().addSettingsListener(this.viewSettingsListener);
        this.updateSelectedState();
    }

    protected void updateSelectedState() {
        boolean prettySyntax;
        NotationInfo.DEFAULT_PRETTY_SYNTAX = prettySyntax = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isUsePretty();
        this.setSelected(prettySyntax);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean selected;
        NotationInfo.DEFAULT_PRETTY_SYNTAX = selected = ((JCheckBoxMenuItem)e.getSource()).isSelected();
        ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setUsePretty(selected);
        this.updateMainWindow(selected);
    }

    protected void updateMainWindow(boolean prettySyntax) {
        this.mainWindow.getUnicodeToggleAction().setEnabled(prettySyntax);
        this.mainWindow.getHidePackagePrefixToggleAction().setEnabled(prettySyntax);
        this.mainWindow.makePrettyView();
    }

    protected void handleViewSettingsChanged(EventObject e) {
        this.updateSelectedState();
        boolean prettySyntax = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isUsePretty();
        this.updateMainWindow(prettySyntax);
    }
}

