/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofManagementDialog;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.notification.events.GeneralFailureEvent;
import java.awt.event.ActionEvent;

public final class ProofManagementAction
extends MainWindowAction {
    private static final long serialVersionUID = 7696620742992568551L;

    public ProofManagementAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Proof Management");
        this.setTooltip("Browse contracts and possible proof targets");
        this.setIcon(IconFactory.proofMgt(16));
        this.setAcceleratorLetter(77);
        this.setEnabled(this.enabled());
        this.getMediator().addKeYSelectionListener(new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                ProofManagementAction.this.setEnabled(ProofManagementAction.this.enabled());
            }
        });
    }

    private boolean enabled() {
        return this.getMediator().getSelectedProof() != null && this.getMediator().getSelectedProof().getServices().getJavaModel() != null && !this.getMediator().getSelectedProof().getServices().getJavaModel().isEmpty();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showProofManagement();
    }

    private void showProofManagement() {
        if (this.getMediator().getSelectedProof() == null) {
            this.mainWindow.notify(new GeneralFailureEvent("Please load a proof first"));
        } else {
            ProofManagementDialog.showInstance(this.getMediator().getSelectedProof().getEnv().getInitConfigForEnvironment());
        }
    }
}

