/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofScriptWorker;
import de.uka.ilkd.key.proof.Proof;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class ProofScriptFromFileAction
extends AbstractAction {
    private static final long serialVersionUID = -3181592516055470032L;
    private final KeYMediator mediator;
    private static File lastDirectory;

    public ProofScriptFromFileAction(KeYMediator mediator) {
        super("Run proof script from file...");
        this.mediator = mediator;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File dir = null;
        if (lastDirectory != null) {
            dir = lastDirectory;
        } else {
            Proof currentProof = this.mediator.getSelectedProof();
            if (currentProof != null) {
                File currentFile = currentProof.getProofFile();
                if (currentFile != null) {
                    dir = currentFile.getParentFile();
                }
            } else {
                dir = new File(".");
            }
        }
        try {
            MainWindow mainWindow = MainWindow.getInstance();
            KeYFileChooser fc = KeYFileChooser.getFileChooser("Select file to load");
            fc.setFileFilter(fc.getAcceptAllFileFilter());
            fc.setCurrentDirectory(dir);
            int res = fc.showOpenDialog(mainWindow);
            if (res == 0) {
                File selectedFile = fc.getSelectedFile();
                lastDirectory = selectedFile.getParentFile();
                ProofScriptWorker psw = new ProofScriptWorker(this.mediator, selectedFile);
                psw.init();
                psw.execute();
            }
        }
        catch (Exception ex) {
            IssueDialog.showExceptionDialog(MainWindow.getInstance(), ex);
        }
    }
}

