/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.settings.GeneralSettings;
import java.awt.event.ActionEvent;

public final class PruneProofAction
extends MainWindowAction {
    private static final long serialVersionUID = 9133317783386913373L;

    public PruneProofAction(MainWindow mainWindow) {
        super(mainWindow);
        this.init();
        this.putValue("Name", "Prune Proof");
        this.putValue("SmallIcon", IconFactory.pruneLogo(16));
        this.putValue("ShortDescription", "Prune the tree below the selected node.");
        this.lookupAcceleratorKey();
    }

    public void init() {
        final KeYSelectionListener selListener = new KeYSelectionListener(){

            @Override
            public void selectedNodeChanged(KeYSelectionEvent e) {
                Node selNode;
                Proof proof = PruneProofAction.this.getMediator().getSelectedProof();
                boolean enabled = false;
                if (proof != null && (selNode = PruneProofAction.this.getMediator().getSelectedNode()) != null && !selNode.leaf() && (proof.getSubtreeGoals(selNode).size() > 0 || !GeneralSettings.noPruningClosed && proof.getClosedSubtreeGoals(selNode).size() > 0)) {
                    enabled = true;
                }
                PruneProofAction.this.setEnabled(enabled);
            }

            @Override
            public void selectedProofChanged(KeYSelectionEvent e) {
                this.selectedNodeChanged(e);
            }
        };
        this.getMediator().addKeYSelectionListener(selListener);
        this.getMediator().getUI().getProofControl().addAutoModeListener(new AutoModeListener(){

            public void autoModeStarted(ProofEvent e) {
                PruneProofAction.this.getMediator().removeKeYSelectionListener(selListener);
                PruneProofAction.this.setEnabled(false);
            }

            public void autoModeStopped(ProofEvent e) {
                PruneProofAction.this.getMediator().addKeYSelectionListener(selListener);
                selListener.selectedNodeChanged(null);
            }
        });
        selListener.selectedNodeChanged(new KeYSelectionEvent(this.getMediator().getSelectionModel()));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getMediator().setBack(this.getMediator().getSelectedNode());
    }
}

