/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.TaskTree;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.util.KeYConstants;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import org.key_project.util.java.IOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QuickSaveAction
extends MainWindowAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskTree.class);
    private static final long serialVersionUID = -7084304175671744403L;
    private static final File TMP_DIR = IOUtil.getTempDirectory();
    public static final String QUICK_SAVE_PATH = TMP_DIR + File.separator + ".quicksave.key";

    public QuickSaveAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Quicksave");
        this.setTooltip("Save current proof to a temporal location.");
        mainWindow.getMediator().enableWhenProofLoaded(this);
    }

    public static void quickSave(MainWindow mainWindow) {
        if (mainWindow.getMediator().ensureProofLoaded()) {
            String filename = QUICK_SAVE_PATH;
            Proof proof = mainWindow.getMediator().getSelectedProof();
            try {
                new ProofSaver(proof, filename, KeYConstants.INTERNAL_VERSION).save();
                String status = "File quicksaved: " + filename;
                mainWindow.setStatusLine(status);
                LOGGER.debug(status);
            }
            catch (IOException x) {
                mainWindow.popupWarning("Quicksaving file " + filename + " failed:\n" + x.getMessage(), "Quicksave failed");
                LOGGER.debug("Quicksaving file {} failed.", (Object)filename, (Object)x);
            }
        } else {
            mainWindow.popupWarning("No proof.", "Oops...");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        QuickSaveAction.quickSave(this.mainWindow);
    }
}

